/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.xm3d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsbase.util.export.ExportDialog;
import org.freehep.graphicsbase.util.export.ExportFileType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.core.Animateable;
import vmm3d.core.Animation;
import vmm3d.core.BasicAnimator;
import vmm3d.core.Exhibit;
import vmm3d.core.Filmstrip;
import vmm3d.core.I18n;
import vmm3d.core.Parameter;
import vmm3d.core.Prefs;
import vmm3d.core.SaveAndRestore;
import vmm3d.core.UserExhibit;
import vmm3d.core.Util;
import vmm3d.core.View;
import vmm3d.xm3d.DisplayXM;
import vmm3d.xm3d.DocPrefsDialog;
import vmm3d.xm3d.Galleries;
import vmm3d.xm3d.SavedAnimationSupport;
import vmm3d.xm3d.WindowXM;

public class Menus
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    public static final int NO_FILE_SYSTEM = 1;
    public static final int NO_ACCELERATORS = 2;
    public static final int SINGLE_EXHIBIT = 4;
    public static final int SINGLE_GALLERY = 8;
    public static final int NO_EXIT = 16;
    public static final int SCAVIS = 17;
    private int optionFlags;
    private WindowXM window;
    private DisplayXM display;
    private JMenu fileMenu;
    private JMenu galleryMenu;
    private JMenu exhibitMenu;
    private JMenu actionMenu;
    private JMenu documentationMenu;
    private JMenu viewMenu;
    private JMenu settingsMenu;
    private JMenu animateMenu;
    private AbstractAction morphAction;
    private AbstractAction cyclicMorphAction;
    private AbstractAction playFilmstripAction;
    private AbstractAction saveAnimationAsPngAction;
    private AbstractAction saveAnimationAsJpegAction;
    private AbstractAction playSavedAnimationAction;
    private JMenu speedSubmenu;
    private JRadioButtonMenuItem speedSelect1;
    private JRadioButtonMenuItem speedSelect2;
    private JRadioButtonMenuItem speedSelect3;
    private JRadioButtonMenuItem speedSelect4;
    private AbstractAction saveAction;
    private AbstractAction newViewAction;
    private AbstractAction newSynchronizedViewAction;
    private JMenuItem saveAsPngCommand;
    private JMenuItem saveAsJpegCommand;
    private JMenuItem saveAsEpsCommand;
    private JMenuItem saveAsPdfCommand;
    private JMenuItem saveAsSvgCommand;
    private AbstractAction showATE;
    private AbstractAction showATG;
    private JFileChooser fileDialog;
    private Galleries galleries;
    private View[] alternativeViews;
    private JRadioButtonMenuItem[] viewSelect;
    public static final String FILE_EXTENSION = "3dxmj";

    public Menus(WindowXM window) {
        this(window, null, 0);
    }

    Menus(WindowXM window, DisplayXM display, int optionFlags) {
        this.window = window;
        if (display == null) {
            display = window.getDisplay();
        }
        this.display = display;
        this.optionFlags = optionFlags;
        display.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("Status")) {
                    Menus.this.setUpForDisplayStatus((String)evt.getNewValue());
                } else if (evt.getPropertyName().equals("FilmstripAvailable")) {
                    Menus.this.setUpForDisplayFilmstrip((Boolean)evt.getNewValue());
                }
            }
        });
        this.createMenus();
        if (window != null) {
            this.add(this.fileMenu);
        }
        if (optionFlags != 17) {
            if ((optionFlags & 4) == 0 && (optionFlags & 8) == 0) {
                this.add(this.galleryMenu);
            }
            if ((optionFlags & 4) == 0) {
                this.add(this.exhibitMenu);
            }
            this.add(this.actionMenu);
            this.add(this.settingsMenu);
            this.add(this.viewMenu);
        }
        if (optionFlags == 17) {
            this.add(this.fileMenu);
            this.add(this.galleryMenu);
            this.add(this.exhibitMenu);
            this.add(this.actionMenu);
            this.add(this.settingsMenu);
            this.add(this.viewMenu);
        }
        this.setUpMenusForNoExhibit();
    }

    int getOptionFlags() {
        return this.optionFlags;
    }

    public void install(View view, Exhibit exhibit) {
        Animation create;
        this.alternativeViews = null;
        this.viewSelect = null;
        if (this.window != null) {
            this.window.setTitle(exhibit.getTitle());
        }
        this.getAlternativeViews(exhibit);
        if (view == null) {
            view = this.alternativeViews == null ? exhibit.getDefaultView() : this.alternativeViews[0];
        }
        this.display.install(view, exhibit);
        this.setUpMenusForNewExhibit(view, exhibit);
        String galleryName = this.galleries.findGalleryForExhibit(exhibit);
        if (galleryName != null) {
            this.galleries.selectGalleryByName(galleryName, this, this.exhibitMenu);
        }
        if ((create = exhibit.getCreateAnimation(view)) != null) {
            this.display.installAnimation(create);
        }
    }

    void installExhibit(Galleries.ExhibitItem exhibitInfo) {
        Exhibit exhibit = null;
        View view = null;
        this.alternativeViews = null;
        this.viewSelect = null;
        if (exhibitInfo != null && exhibitInfo.isXML) {
            try {
                ArrayList<View> views;
                ClassLoader cl = this.getClass().getClassLoader();
                URL imageURL = cl.getResource(exhibitInfo.classname);
                InputStream in = imageURL.openStream();
                exhibit = SaveAndRestore.readExhibitFromXML(in, exhibitInfo.classname);
                if (exhibitInfo.name != exhibitInfo.classname) {
                    exhibit.setName(exhibitInfo.name);
                }
                if ((views = exhibit.getViews()) != null && views.size() > 0) {
                    view = views.get(0);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.window, I18n.tr("3dxm.menus.error.BadXMLFile", exhibitInfo.classname, e.getMessage()));
                e.printStackTrace();
            }
        } else if (exhibitInfo != null) {
            try {
                exhibit = (Exhibit)Class.forName(exhibitInfo.classname).newInstance();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.window, I18n.tr("3dxm.menus.error.BadClassName", exhibitInfo.classname));
                e.printStackTrace();
            }
            if (exhibit instanceof UserExhibit && (view = ((UserExhibit)((Object)exhibit)).getUserExhibitSupport().showCreateDialog(this.display)) == null) {
                return;
            }
        }
        if (exhibit == null) {
            if (this.window != null) {
                this.window.setTitle(I18n.tr("3dxm.window.defaultname"));
            }
            this.display.install(null, null);
            this.setUpMenusForNoExhibit();
            return;
        }
        if (this.window != null) {
            this.window.setTitle(exhibit.getTitle());
        }
        this.getAlternativeViews(exhibit);
        if (view == null) {
            view = this.alternativeViews == null ? exhibit.getDefaultView() : this.alternativeViews[0];
        }
        this.display.install(view, exhibit);
        this.setUpMenusForNewExhibit(view, exhibit);
        Animation create = exhibit.getCreateAnimation(view);
        if (create != null) {
            this.display.installAnimation(create);
        }
    }

    private void getAlternativeViews(Exhibit exhibit) {
        View[] extraViews = exhibit.getAlternativeViews();
        if (extraViews != null) {
            this.alternativeViews = new View[extraViews.length + 1];
            this.alternativeViews[0] = exhibit.getDefaultView();
            for (int i = 0; i < extraViews.length; ++i) {
                this.alternativeViews[i + 1] = extraViews[i];
            }
        }
    }

    private void setUpForDisplayStatus(String status) {
        if (this.saveAction != null) {
            this.saveAction.setEnabled(status.equals("idle"));
        }
        this.newViewAction.setEnabled(status.equals("idle"));
        this.newSynchronizedViewAction.setEnabled(status.equals("idle"));
        if (this.saveAsJpegCommand != null) {
            this.saveAsJpegCommand.setEnabled(!status.equals("empty") && !status.equals("running"));
        }
        if (this.saveAsPngCommand != null) {
            this.saveAsPngCommand.setEnabled(!status.equals("empty") && !status.equals("running"));
        }
    }

    private void setUpForDisplayFilmstrip(boolean filmstripAvailable) {
        this.playFilmstripAction.setEnabled(filmstripAvailable);
        if (this.saveAnimationAsJpegAction != null) {
            this.saveAnimationAsJpegAction.setEnabled(filmstripAvailable);
        }
        if (this.saveAnimationAsPngAction != null) {
            this.saveAnimationAsPngAction.setEnabled(filmstripAvailable);
        }
    }

    private void setUpMenusForNoExhibit() {
        this.actionMenu.removeAll();
        this.viewMenu.removeAll();
        this.settingsMenu.removeAll();
        this.actionMenu.setEnabled(false);
        this.viewMenu.setEnabled(false);
        this.animateMenu.setEnabled(false);
        this.settingsMenu.setEnabled(false);
        this.checkATEandATG();
    }

    private void setUpMenusForNewExhibit(View view, Exhibit exhibit) {
        this.actionMenu.removeAll();
        this.actionMenu.setEnabled(false);
        ActionList actions = view.getActionsForViewAndExhibit();
        if (actions != null && actions.getItemCount() > 0) {
            this.actionMenu.setEnabled(true);
            this.addMenuItems(actions, this.actionMenu);
        }
        if (this.alternativeViews != null) {
            if (this.viewSelect == null) {
                ButtonGroup group = new ButtonGroup();
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        Object src = evt.getSource();
                        for (int i = 0; i < Menus.this.alternativeViews.length; ++i) {
                            if (src != Menus.this.viewSelect[i]) continue;
                            Menus.this.swapInAlternativeView(Menus.this.alternativeViews[i]);
                            return;
                        }
                    }
                };
                this.viewSelect = new JRadioButtonMenuItem[this.alternativeViews.length];
                for (int i = 0; i < this.alternativeViews.length; ++i) {
                    this.viewSelect[i] = new JRadioButtonMenuItem(this.alternativeViews[i].getTitle());
                    group.add(this.viewSelect[i]);
                    this.viewSelect[i].addActionListener(listener);
                    if (this.alternativeViews[i] != view) continue;
                    this.viewSelect[i].setSelected(true);
                }
            }
            if (this.actionMenu.getMenuComponentCount() > 0) {
                this.actionMenu.addSeparator();
            }
            for (int i = 0; i < this.alternativeViews.length; ++i) {
                this.actionMenu.add(this.viewSelect[i]);
            }
            this.actionMenu.setEnabled(true);
        }
        ActionList viewCommands = view.getViewCommands();
        this.viewMenu.removeAll();
        if (viewCommands != null && viewCommands.getItemCount() > 0) {
            this.viewMenu.setEnabled(true);
            this.addMenuItems(viewCommands, this.viewMenu);
        } else {
            this.viewMenu.setEnabled(false);
        }
        ActionList settingsCommands = view.getSettingsCommandsForViewAndExhibit();
        this.settingsMenu.removeAll();
        if (settingsCommands != null && settingsCommands.getItemCount() > 0) {
            this.settingsMenu.setEnabled(true);
            this.addMenuItems(settingsCommands, this.settingsMenu);
        } else {
            this.settingsMenu.setEnabled(false);
        }
        ActionList animateCommands = view.getAdditionalAnimationsForViewAndExhibit();
        this.animateMenu.removeAll();
        this.animateMenu.add(this.speedSubmenu);
        this.animateMenu.addSeparator();
        this.animateMenu.add(this.morphAction);
        this.animateMenu.add(this.cyclicMorphAction);
        this.animateMenu.addSeparator();
        if (animateCommands != null && animateCommands.getItemCount() > 0) {
            this.addMenuItems(animateCommands, this.animateMenu);
            this.animateMenu.addSeparator();
        }
        this.animateMenu.add(this.playFilmstripAction);
        this.animateMenu.setEnabled(true);
        Parameter[] params = view.getViewAndExhibitParameters();
        boolean animated = false;
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof Animateable)) continue;
            animated = true;
            break;
        }
        this.galleries.setUpExhibitMenu(this, this.exhibitMenu);
        if (exhibit instanceof UserExhibit) {
            if (((UserExhibit)((Object)exhibit)).getUserExhibitSupport().getAllowNewParameters()) {
                animated = true;
            }
            if (((UserExhibit)((Object)exhibit)).getUserExhibitSupport().getAllowChangeUserDataCommand()) {
                AbstractActionVMM changeUserDataAction = ((UserExhibit)((Object)exhibit)).getUserExhibitSupport().makeChangeUserDataAction(view);
                this.exhibitMenu.addSeparator();
                this.exhibitMenu.add(changeUserDataAction);
            }
        }
        this.speedSelect1.setSelected(true);
        this.display.setTimeDilationForAnimations(1.0);
        this.morphAction.setEnabled(animated);
        this.cyclicMorphAction.setEnabled(animated);
        this.checkATEandATG();
    }

    private void swapInAlternativeView(View view) {
        if (this.display.getView() == view || this.display.getExhibit() == null) {
            return;
        }
        Exhibit exhibit = this.display.getExhibit();
        view.takeExhibit(this.display.getView(), true);
        this.display.install(view, exhibit);
        Animation create = exhibit.getCreateAnimation(view);
        if (create != null) {
            this.display.installAnimation(create);
        }
        this.setUpMenusForNewExhibit(view, exhibit);
    }

    private void addMenuItems(ActionList items, JMenu menu) {
        if (items != null) {
            for (int i = 0; i < items.getItemCount(); ++i) {
                JMenuItem[] menuItems;
                if (items.getItem(i) == null) {
                    menu.addSeparator();
                    continue;
                }
                for (JMenuItem m : menuItems = items.getItem(i).getMenuItems()) {
                    if (m == null) {
                        menu.addSeparator();
                        continue;
                    }
                    if ((this.optionFlags & 2) != 0) {
                        if (m instanceof JMenu) {
                            int ct = ((JMenu)m).getMenuComponentCount();
                            for (int j = 0; j < ct; ++j) {
                                Component c = ((JMenu)m).getMenuComponent(j);
                                if (c == null || !(c instanceof JMenuItem) || c instanceof JMenu) continue;
                                ((JMenuItem)c).setAccelerator(null);
                            }
                        } else {
                            m.setAccelerator(null);
                        }
                    }
                    menu.add(m);
                }
            }
        }
    }

    private void createMenus() {
        String accel;
        boolean noFileSystem = (this.optionFlags & 1) != 0;
        boolean noAccelerators = (this.optionFlags & 2) != 0;
        this.fileMenu = new JMenu(noFileSystem ? I18n.tr("3dxm.menus.LauncherApplet.WindowsMenuName") : I18n.tr("3dxm.menus.fileMenuName"));
        this.galleryMenu = new JMenu(I18n.tr("3dxm.menus.galleryMenuName"));
        this.actionMenu = new JMenu(I18n.tr("3dxm.menus.actionMenuName"));
        this.exhibitMenu = new JMenu(I18n.tr("3dxm.gallery.PlaneCurves"));
        this.documentationMenu = new JMenu(I18n.tr("3dxm.menus.documentationMenuName"));
        this.viewMenu = new JMenu(I18n.tr("3dxm.menus.viewMenuName"));
        this.settingsMenu = new JMenu(I18n.tr("3dxm.menus.settingsMenuName"));
        this.animateMenu = new JMenu(I18n.tr("3dxm.menus.animateMenuName"));
        this.documentationMenu.add(new AbstractAction(I18n.tr("3dxm.command.documentation.GettingStarted")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String resourceName = null;
                String language = I18n.getLocale().getLanguage().toLowerCase();
                if (!language.equals("en")) {
                    resourceName = "vmm3d/xm3d/getting_started_" + language + ".html";
                    if (this.getClass().getClassLoader().getResource(resourceName) == null) {
                        resourceName = null;
                    }
                }
                if (resourceName == null) {
                    resourceName = "vmm3d/xm3d/getting_started.html";
                }
                WindowXM.showHTMLDocWindow(resourceName);
            }
        });
        this.documentationMenu.addSeparator();
        this.showATE = new AbstractAction(I18n.tr("3dxm.command.documentation.ATE")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (Menus.this.display == null || Menus.this.display.getExhibit() == null) {
                    return;
                }
                String exhibitName = Menus.this.display.getExhibit().getName();
                Menus.this.showDocumentation(exhibitName + ".ATE.html");
            }
        };
        this.documentationMenu.add(this.showATE);
        this.showATG = new AbstractAction(I18n.tr("3dxm.command.documentation.ATG")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String galleryName = Menus.this.galleries.currentGalleryName();
                if (galleryName == null) {
                    return;
                }
                Menus.this.showDocumentation(galleryName + ".ATG.html");
            }
        };
        this.documentationMenu.add(this.showATG);
        this.documentationMenu.addSeparator();
        this.documentationMenu.add(new AbstractAction(I18n.tr("3dxm.command.documentation.DocPrefs")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DocPrefsDialog(Menus.this.display).setVisible(true);
                Galleries.setDocumentationLocation();
                Menus.this.checkATEandATG();
            }
        });
        this.documentationMenu.add(new AbstractAction(I18n.tr("About the Documentation")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(Menus.this.display, I18n.tr("3dxm.documentation.about.text"));
            }
        });
        try {
            this.galleries = new Galleries();
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.window, I18n.tr("3dxm.menus.error.BadGalleryInfo", e.toString()));
            System.exit(0);
        }
        this.galleries.setUpGalleryMenu(this, this.galleryMenu, this.exhibitMenu);
        if ((this.optionFlags & 4) == 0) {
            accel = noAccelerators ? null : "N";
            this.fileMenu.add(new AbstractActionVMM(I18n.tr("3dxm.command.New"), accel){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WindowXM newWin = new WindowXM(Menus.this.window);
                    if ((Menus.this.optionFlags & 8) != 0) {
                        String gallery = Menus.this.galleries.currentGalleryName();
                        Menus newWinMenus = newWin.getMenus();
                        newWinMenus.galleries.selectGalleryByName(gallery, newWinMenus, newWinMenus.exhibitMenu);
                    }
                    newWin.setVisible(true);
                }
            });
        }
        this.newViewAction = new AbstractAction(I18n.tr("3dxm.command.NewView")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Exhibit exhibit = Menus.this.display.getExhibit();
                if (exhibit == null) {
                    return;
                }
                WindowXM w = new WindowXM(Menus.this.window);
                w.getMenus().getAlternativeViews(exhibit);
                View view = w.getMenus().alternativeViews == null ? exhibit.getDefaultView() : w.getMenus().alternativeViews[0];
                w.getDisplay().install(view, exhibit);
                w.getMenus().setUpMenusForNewExhibit(view, exhibit);
                w.setTitle(Menus.this.window.getTitle());
                w.getMenus().galleries.selectGalleryByName(Menus.this.galleries.currentGalleryName(), w.getMenus(), w.getMenus().exhibitMenu);
                w.setVisible(true);
            }
        };
        this.newViewAction.setEnabled(false);
        this.fileMenu.add(this.newViewAction);
        this.newSynchronizedViewAction = new AbstractAction(I18n.tr("3dxm.command.NewViewShareTransform")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Exhibit exhibit = Menus.this.display.getExhibit();
                if (exhibit == null) {
                    return;
                }
                WindowXM w = new WindowXM(Menus.this.window);
                w.getMenus().getAlternativeViews(exhibit);
                View view = w.getMenus().alternativeViews == null ? exhibit.getDefaultView() : w.getMenus().alternativeViews[0];
                view.takeExhibit(Menus.this.display.getView(), true);
                w.getDisplay().install(view, null);
                w.getMenus().setUpMenusForNewExhibit(view, exhibit);
                w.setTitle(Menus.this.window.getTitle());
                w.getMenus().galleries.selectGalleryByName(Menus.this.galleries.currentGalleryName(), w.getMenus(), w.getMenus().exhibitMenu);
                w.setVisible(true);
            }
        };
        this.newSynchronizedViewAction.setEnabled(false);
        this.fileMenu.add(this.newSynchronizedViewAction);
        if (!noFileSystem) {
            accel = noAccelerators ? null : "O";
            this.fileMenu.add(new AbstractActionVMM(I18n.tr("3dxm.command.Open"), accel){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Menus.this.doOpen();
                }
            });
            this.fileMenu.addSeparator();
            accel = noAccelerators ? null : "S";
            this.saveAction = new AbstractActionVMM(I18n.tr("3dxm.command.Save"), accel){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Menus.this.doSave();
                }
            };
            this.saveAsJpegCommand = new JMenuItem(I18n.tr("3dxm.command.SaveAsJpeg"));
            this.saveAsPngCommand = new JMenuItem(I18n.tr("3dxm.command.SaveAsPng"));
            this.saveAsEpsCommand = new JMenuItem(I18n.tr("3dxm.command.SaveAsEps"));
            this.saveAsPdfCommand = new JMenuItem(I18n.tr("3dxm.command.SaveAsPdf"));
            this.saveAsSvgCommand = new JMenuItem(I18n.tr("3dxm.command.SaveAsSvg"));
            ActionListener saveImageListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() == Menus.this.saveAsJpegCommand) {
                        Menus.this.doSaveImage("JPEG");
                    } else if (evt.getSource() == Menus.this.saveAsPngCommand) {
                        Menus.this.doSaveImage("PNG");
                    } else if (evt.getSource() == Menus.this.saveAsEpsCommand) {
                        Menus.this.doSaveImage("EPS");
                    } else if (evt.getSource() == Menus.this.saveAsPdfCommand) {
                        Menus.this.doSaveImage("PDF");
                    } else if (evt.getSource() == Menus.this.saveAsSvgCommand) {
                        Menus.this.doSaveImage("SVG");
                    }
                }
            };
            this.saveAnimationAsPngAction = new AbstractActionVMM(I18n.tr("3dxm.command.saveAnimationPngFormat")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Menus.this.doSaveAnimation("PNG");
                }
            };
            this.saveAnimationAsPngAction.setEnabled(false);
            this.saveAnimationAsJpegAction = new AbstractActionVMM(I18n.tr("3dxm.command.saveAnimationJpegFormat")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Menus.this.doSaveAnimation("JPEG");
                }
            };
            this.saveAnimationAsJpegAction.setEnabled(false);
            this.playSavedAnimationAction = new AbstractActionVMM(I18n.tr("3dxm.command.playSavedAnimation")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Menus.this.doPlaySavedAnimation();
                }
            };
            this.saveAsJpegCommand.addActionListener(saveImageListener);
            this.saveAsPngCommand.addActionListener(saveImageListener);
            this.saveAsEpsCommand.addActionListener(saveImageListener);
            this.saveAsPdfCommand.addActionListener(saveImageListener);
            this.saveAsSvgCommand.addActionListener(saveImageListener);
            this.saveAction.setEnabled(false);
            this.saveAsJpegCommand.setEnabled(false);
            this.saveAsPngCommand.setEnabled(false);
            this.fileMenu.add(this.saveAction);
            this.fileMenu.add(this.saveAsPngCommand);
        }
        accel = noAccelerators ? null : "W";
        this.fileMenu.add(new AbstractActionVMM(I18n.tr("3dxm.command.Close"), accel){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Menus.this.window.dispose();
            }
        });
        if ((this.optionFlags & 0x10) == 0) {
            accel = noAccelerators ? null : "Q";
            this.fileMenu.add(new AbstractActionVMM(I18n.tr("3dxm.command.Quit"), accel){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    System.exit(0);
                }
            });
        }
        accel = noAccelerators ? null : "P";
        this.playFilmstripAction = new AbstractActionVMM(I18n.tr("3dxm.command.playback"), accel){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Menus.this.display.playFilmstrip();
            }
        };
        this.playFilmstripAction.setEnabled(false);
        this.morphAction = new AbstractAction(I18n.tr("3dxm.command.Morph")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Exhibit currentExhibit = Menus.this.display.getExhibit();
                if (currentExhibit == null) {
                    return;
                }
                BasicAnimator anim = currentExhibit.getMorphingAnimation(Menus.this.display.getView(), 2);
                if (anim != null) {
                    Menus.this.display.installAnimation(anim);
                } else {
                    JOptionPane.showMessageDialog(Menus.this.display, I18n.tr("3dxm.morphing.noAnimation"));
                }
            }
        };
        this.cyclicMorphAction = new AbstractAction(I18n.tr("3dxm.command.CyclicMorph")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Exhibit currentExhibit = Menus.this.display.getExhibit();
                if (currentExhibit == null) {
                    return;
                }
                BasicAnimator anim = currentExhibit.getMorphingAnimation(Menus.this.display.getView(), 1);
                if (anim != null) {
                    Menus.this.display.installAnimation(anim);
                } else {
                    JOptionPane.showMessageDialog(Menus.this.display, I18n.tr("3dxm.morphing.noAnimation"));
                }
            }
        };
        this.speedSelect1 = new JRadioButtonMenuItem(I18n.tr("3dxm.command.NormalSpeed"), true);
        this.speedSelect2 = new JRadioButtonMenuItem(I18n.tr("3dxm.command.HalfSpeed"), true);
        this.speedSelect3 = new JRadioButtonMenuItem(I18n.tr("3dxm.command.QuarterSpeed"), true);
        this.speedSelect4 = new JRadioButtonMenuItem(I18n.tr("3dxm.command.EighthSpeed"), true);
        if ((this.optionFlags & 2) == 0) {
            this.speedSelect1.setAccelerator(Util.getAccelerator("1"));
            this.speedSelect2.setAccelerator(Util.getAccelerator("2"));
            this.speedSelect3.setAccelerator(Util.getAccelerator("3"));
            this.speedSelect4.setAccelerator(Util.getAccelerator("4"));
        }
        ButtonGroup speedGroup = new ButtonGroup();
        speedGroup.add(this.speedSelect1);
        speedGroup.add(this.speedSelect2);
        speedGroup.add(this.speedSelect3);
        speedGroup.add(this.speedSelect4);
        SetSpeedAction speedAction = new SetSpeedAction();
        this.speedSelect1.addActionListener(speedAction);
        this.speedSelect2.addActionListener(speedAction);
        this.speedSelect3.addActionListener(speedAction);
        this.speedSelect4.addActionListener(speedAction);
        this.speedSubmenu = new JMenu(I18n.tr("3dxm.command.AnimationSpeed"));
        this.speedSubmenu.add(this.speedSelect1);
        this.speedSubmenu.add(this.speedSelect2);
        this.speedSubmenu.add(this.speedSelect3);
        this.speedSubmenu.add(this.speedSelect4);
    }

    private void showDocumentation(String document) {
        URL docURL;
        String documentationBaseURL;
        boolean useExternalBrowser = Prefs.getBoolean("3dxm.docprefs.useExternalBrowser", false);
        String externalBrowserCommand = null;
        if (useExternalBrowser && ((externalBrowserCommand = Prefs.get("3dxm.docprefs.externalBrowserCommand", null)) == null || externalBrowserCommand.indexOf("%f") < 0)) {
            useExternalBrowser = false;
        }
        if ((documentationBaseURL = Prefs.get("3dxm.docprefs.documentationBaseURL", I18n.tr("3dxm.DocPrefsDialog.DefaultDocumentationLocation"))).startsWith("http://")) {
            String doc = documentationBaseURL.endsWith("/") ? documentationBaseURL + document : documentationBaseURL + "/" + document;
            try {
                docURL = new URL(doc);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.window, I18n.tr("3dxm.documentation.error.BadDocumentationLocation", doc));
                return;
            }
        }
        File docFile = new File(documentationBaseURL, document);
        try {
            docURL = docFile.getAbsoluteFile().toURI().toURL();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.window, I18n.tr("3dxm.documentation.error.BadDocumentationLocation", docFile.getAbsolutePath()));
            return;
        }
        if (!useExternalBrowser) {
            WindowXM.showHTMLDocWindow(docURL);
        } else {
            String command = externalBrowserCommand.replace("%f", docURL.toString());
            String errorMessage = this.runCommand(command);
            if (errorMessage != null) {
                JOptionPane.showMessageDialog(this.window, I18n.tr(errorMessage));
            }
        }
    }

    private String runCommand(final String command) {
        class Runner
        extends Thread {
            volatile String errorMessage = null;

            Runner() {
            }

            @Override
            public void run() {
                Process process;
                System.out.println("Running external command: " + command);
                try {
                    process = Runtime.getRuntime().exec(command);
                }
                catch (Exception e) {
                    this.errorMessage = I18n.tr("3dxm.documentation.error.cantLaunchBrowser", command);
                    return;
                }
                BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                try {
                    String e = err.readLine();
                    while (e != null) {
                        if (this.errorMessage == null) {
                            this.errorMessage = I18n.tr("3dxm.documentation.error.errorFromBrowserProcess");
                        }
                        e = err.readLine();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Runner runner = new Runner();
        runner.start();
        try {
            runner.join(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (runner.errorMessage != null && !runner.isAlive()) {
            return runner.errorMessage;
        }
        return null;
    }

    void gotDocumnetationFileList(TreeSet<String> documentationFiles) {
        if (this.galleries.currentGalleryName() != null) {
            this.showATG.setEnabled(documentationFiles.contains(this.galleries.currentGalleryName() + ".ATG.html"));
        }
        if (this.display.getExhibit() != null) {
            this.showATE.setEnabled(documentationFiles.contains(this.display.getExhibit().getName() + ".ATE.html"));
        }
    }

    private void checkATEandATG() {
        if (this.galleries.currentGalleryName() == null) {
            this.showATG.setEnabled(false);
        } else {
            this.showATG.setEnabled(Galleries.documentationFileExists(this, this.galleries.currentGalleryName() + ".ATG.html"));
        }
        if (this.display.getExhibit() == null) {
            this.showATE.setEnabled(false);
        } else {
            this.showATE.setEnabled(Galleries.documentationFileExists(this, this.display.getExhibit().getName() + ".ATE.html"));
        }
    }

    private void setupFileDialog() {
        File dir;
        String directory;
        if (this.fileDialog == null) {
            this.fileDialog = new JFileChooser();
        }
        if ((directory = Prefs.get("filechooser.directory")) != null && (dir = new File(directory)).isDirectory()) {
            this.fileDialog.setCurrentDirectory(dir);
        }
    }

    private void saveFileDialogDirectory() {
        File dir = this.fileDialog.getCurrentDirectory();
        if (dir != null) {
            String dirName = dir.getAbsolutePath();
            Prefs.put("filechooser.directory", dirName);
            Prefs.save("filechooser.directory");
        }
    }

    private void doOpen() {
        View[] extraViews;
        Exhibit exhibit;
        this.setupFileDialog();
        this.fileDialog.setDialogTitle(I18n.tr("3dxm.dialog.openDialog.title"));
        int option = this.fileDialog.showOpenDialog(this.display);
        if (option != 0) {
            return;
        }
        File selectedFile = this.fileDialog.getSelectedFile();
        String galleryName = null;
        try {
            Document exhibitDoc = SaveAndRestore.readXMLDocument(selectedFile);
            NodeList galleryElements = exhibitDoc.getDocumentElement().getElementsByTagName("gallery_3dxm");
            if (galleryElements.getLength() > 0) {
                Element galleryElement = (Element)galleryElements.item(0);
                galleryName = galleryElement.getAttribute("name").trim();
            }
            exhibit = SaveAndRestore.readExhibitFromXML(selectedFile);
        }
        catch (Exception e) {
            this.errorMessage(I18n.tr("3dxm.dialog.openDialog.error", e.getMessage()));
            return;
        }
        this.window.setTitle(exhibit.getTitle());
        this.galleries.selectGalleryByName(galleryName, this, this.exhibitMenu);
        ArrayList<View> views = exhibit.getViews();
        View view = views == null || views.size() == 0 ? exhibit.getDefaultView() : views.get(0);
        this.display.install(view, exhibit);
        Animation create = exhibit.getCreateAnimation(view);
        if (create != null) {
            this.display.installAnimation(create);
        }
        if ((extraViews = exhibit.getAlternativeViews()) != null) {
            this.alternativeViews = new View[extraViews.length + 1];
            this.alternativeViews[0] = exhibit.getDefaultView();
            for (int i = 0; i < extraViews.length; ++i) {
                this.alternativeViews[i + 1] = extraViews[i];
            }
        }
        this.setUpMenusForNewExhibit(view, exhibit);
        this.saveFileDialogDirectory();
    }

    private void doSave() {
        PrintWriter out;
        int response;
        if (this.display.getExhibit() == null) {
            return;
        }
        this.display.stopAnimation();
        this.setupFileDialog();
        String defaultName = I18n.tr("3dxm.dialog.saveDialog.SettingsFileNameForExhibit", this.display.getExhibit().getTitle()) + '.' + FILE_EXTENSION;
        File selectedFile = new File(defaultName);
        this.fileDialog.setSelectedFile(selectedFile);
        this.fileDialog.setDialogTitle(I18n.tr("3dxm.dialog.saveDialog.title"));
        int option = this.fileDialog.showSaveDialog(this.display);
        if (option != 0) {
            return;
        }
        selectedFile = this.fileDialog.getSelectedFile();
        if (!selectedFile.exists() && !selectedFile.getName().toLowerCase().endsWith(".3dxmj")) {
            selectedFile = new File(selectedFile.getParent(), selectedFile.getName() + '.' + FILE_EXTENSION);
        }
        if (selectedFile.exists() && (response = JOptionPane.showConfirmDialog(this.display, I18n.tr("3dxm.dialog.saveDialog.fileExists", selectedFile.getName()), I18n.tr("3dxm.dialog.saveDialog.confirmSaveTitle"), 0, 2)) == 1) {
            return;
        }
        try {
            out = new PrintWriter(new FileWriter(selectedFile));
        }
        catch (IOException e) {
            this.errorMessage(I18n.tr("3dxm.dialog.error.cantOpenOutputFile", selectedFile.getName()));
            return;
        }
        Document doc = SaveAndRestore.exhibitToXML(this.display.getExhibit(), this.display.getView());
        String galleryName = this.galleries.currentGalleryName();
        if (galleryName != null) {
            Element galleryElement = doc.createElement("gallery_3dxm");
            galleryElement.setAttribute("name", galleryName);
            doc.getDocumentElement().appendChild(galleryElement);
        }
        try {
            SaveAndRestore.writeXMLDocument(out, doc);
        }
        catch (Exception e) {
            this.errorMessage(I18n.tr("3dxm.dialog.error.cantWriteFile", selectedFile.getName()));
            return;
        }
        out.close();
        if (out.checkError()) {
            this.errorMessage(I18n.tr("3dxm.dialog.error.cantWriteFile", selectedFile.getName()));
            return;
        }
        this.saveFileDialogDirectory();
    }

    private void doSaveImage(String format) {
        if (this.display.getView() == null || this.display.getExhibit() == null) {
            return;
        }
        ExportDialog export = new ExportDialog();
        export.showExportDialog((Component)this.window, "Export view as", (Component)this.display, "JHPlotMX");
    }

    public boolean export(String file) {
        String[] ext;
        if (this.display.getView() == null || this.display.getExhibit() == null) {
            return false;
        }
        ExportFileType t = null;
        File f = new File(file);
        String fext = file.substring(file.lastIndexOf(46) + 1, file.length());
        List list = ExportFileType.getExportFileTypes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !fext.equalsIgnoreCase((ext = (t = (ExportFileType)iterator.next()).getExtensions())[0])) {
            t = null;
        }
        if (t == null) {
            return true;
        }
        boolean err = false;
        String rootKey = this.getClass().getName();
        String SAVE_AS_TYPE = rootKey + ".SaveAsType";
        String SAVE_AS_FILE = rootKey + ".SaveAsFile";
        Properties props = new Properties();
        String a = t.getDescription();
        props.put(SAVE_AS_FILE, file);
        props.put(SAVE_AS_TYPE, a);
        ExportFileType tt = t;
        DisplayXM com = this.display;
        this.display.getView().setNeedRecalculate(false);
        try {
            tt.exportToFile(f, (Component)com, (Component)com, props, "DataMelt (C) S.Chekanov");
        }
        catch (IOException x) {
            System.err.println("Error when making the image " + file);
        }
        this.display.getView().setNeedRecalculate(true);
        return err;
    }

    private void drawToGraphics2D(VectorGraphics g, int width, int height) {
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
    }

    private void doSaveAnimation(String format) {
        BufferedOutputStream out;
        int response;
        Filmstrip filmstrip = this.display.getSavedFilmstrip();
        if (filmstrip == null) {
            return;
        }
        this.display.stopAnimation();
        int looping = this.display.getSavedFilmstripLooping();
        boolean cyclic = looping == 1;
        this.setupFileDialog();
        String defaultName = this.display.getExhibit() == null ? I18n.tr("3dxm.dialog.saveAnimationDialog.AnimationFileNameForExhibit", format.toLowerCase()) + ".3dxmja" : I18n.tr("3dxm.dialog.saveAnimationDialog.AnimationFileNameForExhibit", this.display.getExhibit().getTitle()) + ".3dxmja";
        File selectedFile = new File(defaultName);
        this.fileDialog.setSelectedFile(selectedFile);
        this.fileDialog.setDialogTitle(I18n.tr("3dxm.dialog.saveAnimationDialog.title", format));
        int option = this.fileDialog.showSaveDialog(this.display);
        if (option != 0) {
            return;
        }
        selectedFile = this.fileDialog.getSelectedFile();
        if (!selectedFile.exists() && !selectedFile.getName().toLowerCase().endsWith(".3dxmja")) {
            selectedFile = new File(selectedFile.getParent(), selectedFile.getName() + ".3dxmja");
        }
        if (selectedFile.exists() && (response = JOptionPane.showConfirmDialog(this.display, I18n.tr("3dxm.dialog.saveDialog.fileExists", selectedFile.getName()), I18n.tr("3dxm.dialog.saveDialog.confirmSaveTitle"), 0, 2)) == 1) {
            return;
        }
        try {
            out = new BufferedOutputStream(new FileOutputStream(selectedFile));
        }
        catch (IOException e) {
            this.errorMessage(I18n.tr("3dxm.dialog.error.cantWriteFile", selectedFile.getName()));
            return;
        }
        this.display.setCursor(Cursor.getPredefinedCursor(3));
        try {
            boolean saved = SavedAnimationSupport.saveAnimation(this.display, out, filmstrip, cyclic, format);
            if (!saved) {
                selectedFile.delete();
            }
        }
        catch (IOException e) {
            this.errorMessage(I18n.tr("3dxm.dialog.error.errorSavingAnimation", selectedFile.getName(), e.getMessage()));
            e.printStackTrace();
        }
        this.display.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPlaySavedAnimation() {
        ZipFile zipFile;
        this.display.stopAnimation();
        this.setupFileDialog();
        this.fileDialog.setDialogTitle(I18n.tr("3dxm.dialog.playSavedAnimation.title"));
        int option = this.fileDialog.showOpenDialog(this.display);
        if (option != 0) {
            return;
        }
        File selectedFile = this.fileDialog.getSelectedFile();
        try {
            zipFile = new ZipFile(selectedFile);
        }
        catch (IOException e) {
            this.errorMessage(I18n.tr("3dxm.dialog.playSavedAnimation.CantRead", selectedFile.getName()));
            return;
        }
        this.display.discardFilmstrip();
        try {
            SavedAnimationSupport.readAndPlay(this.display, zipFile);
        }
        catch (Exception e) {
            this.errorMessage(I18n.tr("3dxm.dialog.playSavedAnimation.error", selectedFile.getName(), e.getMessage()));
            return;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception exception) {}
        }
    }

    private void errorMessage(String message) {
        JOptionPane.showMessageDialog(this.display, message, I18n.tr("3dxm.dialog.errormessage.title"), 0);
    }

    private class SetSpeedAction
    implements ActionListener {
        private SetSpeedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src == Menus.this.speedSelect1) {
                Menus.this.display.setTimeDilationForAnimations(1.0);
            } else if (src == Menus.this.speedSelect2) {
                Menus.this.display.setTimeDilationForAnimations(2.0);
            } else if (src == Menus.this.speedSelect3) {
                Menus.this.display.setTimeDilationForAnimations(4.0);
            } else if (src == Menus.this.speedSelect4) {
                Menus.this.display.setTimeDilationForAnimations(8.0);
            }
        }
    }
}

