/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.xm3d;

import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import vmm3d.core.Exhibit;
import vmm3d.core.I18n;
import vmm3d.core.SaveAndRestore;
import vmm3d.core.UserExhibit;
import vmm3d.core.View;
import vmm3d.xm3d.DisplayXM;
import vmm3d.xm3d.WindowXM;

public class MainForWebStart {
    public static void main(String[] args) {
        boolean singleExhibit = false;
        boolean singleGallery = false;
        String exhibitName = null;
        DisplayXM.noSplash();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("--SingleExhibit")) {
                singleExhibit = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("--SingleGallery")) {
                singleGallery = true;
                continue;
            }
            if (args[i].toLowerCase().startsWith("--locale=")) {
                String locale = args[i].substring(9).toLowerCase();
                if (locale.length() != 2) continue;
                I18n.setLocale(new Locale(locale));
                continue;
            }
            if (args[i].startsWith("-")) continue;
            exhibitName = args[i];
        }
        Exhibit exhibit = null;
        View view = null;
        if (exhibitName != null) {
            try {
                if (exhibitName.endsWith(".xml")) {
                    ClassLoader cl = MainForWebStart.class.getClassLoader();
                    URL url = cl.getResource(exhibitName);
                    if (url == null) {
                        throw new Exception("Can't find resource file.");
                    }
                    InputStream in = url.openStream();
                    exhibit = SaveAndRestore.readExhibitFromXML(in, "Settings File");
                    view = exhibit.getViews().get(0);
                } else {
                    exhibit = (Exhibit)Class.forName(exhibitName).newInstance();
                    if (exhibit instanceof UserExhibit) {
                        view = ((UserExhibit)((Object)exhibit)).getUserExhibitSupport().defaults();
                        if (view == null) {
                            throw new Exception("Error while creating user exhibits with default settings");
                        }
                    } else {
                        view = exhibit.getDefaultView();
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Could not load specified exhibit, \"" + exhibitName + "\".");
                e.printStackTrace();
                singleGallery = false;
                singleExhibit = false;
                exhibit = null;
                view = null;
            }
        }
        int options = 1;
        if (exhibitName != null && singleExhibit) {
            options |= 4;
        } else if (exhibitName != null && singleGallery) {
            options |= 8;
        }
        WindowXM window = new WindowXM(options);
        if (exhibit != null) {
            window.getMenus().install(view, exhibit);
        }
        window.setVisible(true);
    }
}

