/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.xm3d;

import java.awt.Color;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComponent;
import vmm3d.core.Exhibit;
import vmm3d.core.I18n;
import vmm3d.core.SaveAndRestore;
import vmm3d.core.UserExhibit;
import vmm3d.core.View;
import vmm3d.xm3d.DisplayXM;
import vmm3d.xm3d.MainForWebStart;
import vmm3d.xm3d.Menus;

public class EmbeddedApplet
extends JApplet {
    private DisplayXM display;

    @Override
    public void init() {
        String locale = this.getParameter("Locale");
        if (locale != null && locale.length() == 2) {
            I18n.setLocale(new Locale(locale));
        }
        I18n.addFile("vmm3d.xm3d.stringsXM");
        DisplayXM.noSplash();
        int menuOptions = 19;
        this.display = new DisplayXM();
        JComponent holder = (JComponent)this.display.getHolder();
        holder.setBorder(BorderFactory.createLineBorder(Color.GRAY, 2));
        if ("no".equalsIgnoreCase(this.getParameter("StatusBar"))) {
            this.display.setShowStatusBar(false);
        }
        String exhibitName = this.getParameter("Exhibit");
        Exhibit exhibit = null;
        View view = null;
        if (exhibitName != null) {
            try {
                if (exhibitName.endsWith(".xml")) {
                    ClassLoader cl = MainForWebStart.class.getClassLoader();
                    URL url = cl.getResource(exhibitName);
                    if (url == null) {
                        url = new URL(this.getDocumentBase(), exhibitName);
                    }
                    InputStream settings = url.openStream();
                    exhibit = SaveAndRestore.readExhibitFromXML(settings, "Settings File");
                    view = exhibit.getViews().get(0);
                } else {
                    exhibit = (Exhibit)Class.forName(exhibitName).newInstance();
                    if (exhibit instanceof UserExhibit) {
                        view = ((UserExhibit)((Object)exhibit)).getUserExhibitSupport().defaults();
                        if (view == null) {
                            throw new Exception("Error while creating user exhibits with default settings");
                        }
                    } else {
                        view = exhibit.getDefaultView();
                    }
                }
                if ("yes".equalsIgnoreCase(this.getParameter("SingleExhibit"))) {
                    menuOptions |= 4;
                } else if ("yes".equalsIgnoreCase(this.getParameter("SingleGallery"))) {
                    menuOptions |= 8;
                }
            }
            catch (Exception e) {
                System.out.println("Can't load Exhibit specified by applet param \"" + exhibitName + "\"");
                e.printStackTrace();
                exhibit = null;
            }
        }
        Menus menuBar = new Menus(null, this.display, menuOptions);
        if (exhibit != null) {
            menuBar.install(view, exhibit);
        }
        this.display.setStopAnimationsOnResize(false);
        this.setJMenuBar(menuBar);
        this.setContentPane(holder);
    }

    @Override
    public void stop() {
        this.display.stopAnimation();
    }
}

