/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.xm3d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import vmm3d.core.I18n;
import vmm3d.core.Prefs;
import vmm3d.core.SettingsDialog;
import vmm3d.core.Util;

public class DocPrefsDialog
extends SettingsDialog {
    private boolean useExternalBrowser;
    private String externalBrowserCommand;
    private String documentationBaseURL;
    private JComboBox browserSelect;
    private JTextField docsLocationInput;
    private JButton browseDocLocationButton;

    public DocPrefsDialog(Component parent) {
        super(parent, I18n.tr("3dxm.DocPrefsDialog.title"), true, false);
        String os;
        Box inputPanel = Box.createVerticalBox();
        Box browserPanel = Box.createVerticalBox();
        browserPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(I18n.tr("3dxm.DocPrefsDialog.SelectBrowser")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        Box locationPanel = Box.createVerticalBox();
        locationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(I18n.tr("3dxm.DocPrefsDialog.SelectDocsLocation")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        inputPanel.add(locationPanel);
        inputPanel.add(Box.createVerticalStrut(7));
        inputPanel.add(browserPanel);
        inputPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.browserSelect = new JComboBox();
        this.useExternalBrowser = Prefs.getBoolean("3dxm.docprefs.useExternalBrowser", false);
        this.externalBrowserCommand = Prefs.get("3dxm.docprefs.externalBrowserCommand", null);
        if (this.externalBrowserCommand == null || this.externalBrowserCommand.indexOf("%f") < 0) {
            this.useExternalBrowser = false;
        }
        this.documentationBaseURL = Prefs.get("3dxm.docprefs.documentationBaseURL", I18n.tr("3dxm.DocPrefsDialog.DefaultDocumentationLocation"));
        if (this.useExternalBrowser) {
            this.browserSelect.addItem(this.externalBrowserCommand);
        }
        this.browserSelect.addItem(I18n.tr("3dxm.DocPrefsDialog.BuiltInBrowser"));
        try {
            os = System.getProperty("os.name").toLowerCase();
        }
        catch (Exception e) {
            os = "";
        }
        if (Util.isMacOS()) {
            this.browserSelect.addItem("open %f");
            this.browserSelect.addItem("open -a safari %f");
            this.browserSelect.addItem("open -a firefox %f");
        } else if (os.indexOf("linux") >= 0) {
            this.browserSelect.addItem("gnome-open %f");
            this.browserSelect.addItem("kfmclient exec %f");
            this.browserSelect.addItem("firefox %f");
            this.browserSelect.addItem("konqueror %f");
        } else if (os.indexOf("wind") >= 0) {
            this.browserSelect.addItem("cmd.exe /c start %f");
            this.browserSelect.addItem("\"c:\\Program Files\\Internet Explorer\\iexplore\" %f");
            this.browserSelect.addItem("firefox %f");
        } else {
            this.browserSelect.addItem("firefox %f");
        }
        this.browserSelect.setSelectedItem(0);
        this.browserSelect.setEditable(true);
        JPanel temp = new JPanel();
        temp.add(new JLabel(I18n.tr("3dxm.DocPrefsDialog.selectBrowserInfo"), 2));
        browserPanel.add(temp);
        browserPanel.add(Box.createVerticalStrut(5));
        browserPanel.add(this.browserSelect);
        this.docsLocationInput = new JTextField(this.documentationBaseURL);
        this.browseDocLocationButton = new JButton(I18n.tr("3dxm.DocPrefsDialog.Browse"));
        this.browseDocLocationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocPrefsDialog.this.browseToSelectDocDirectory();
            }
        });
        temp = new JPanel();
        temp.add(new JLabel(I18n.tr("3dxm.DocPrefsDialog.selectDocsLocationInfo"), 2));
        locationPanel.add(temp);
        locationPanel.add(Box.createVerticalStrut(5));
        temp = new JPanel();
        temp.setLayout(new BorderLayout(5, 5));
        temp.add((Component)this.docsLocationInput, "Center");
        temp.add((Component)this.browseDocLocationButton, "East");
        locationPanel.add(temp);
        this.addInputPanel(inputPanel);
        this.pack();
    }

    private void browseToSelectDocDirectory() {
        JFileChooser dialog = new JFileChooser();
        dialog.setDialogTitle(I18n.tr("3dxm.DocPrefsDialog.SelectDocsDirectoryTitle"));
        dialog.setFileSelectionMode(1);
        if (0 == dialog.showOpenDialog(this)) {
            File docsDir = dialog.getSelectedFile();
            this.docsLocationInput.setText(docsDir.getAbsolutePath());
        }
    }

    @Override
    protected void doDefaults() {
        this.browserSelect.setSelectedItem(I18n.tr("3dxm.DocPrefsDialog.BuiltInBrowser"));
        this.docsLocationInput.setText(I18n.tr("3dxm.DocPrefsDialog.DefaultDocumentationLocation"));
    }

    @Override
    protected boolean doOK() {
        String docsLoc = this.docsLocationInput.getText();
        if (!docsLoc.startsWith("http://")) {
            File file = new File(docsLoc);
            if (!file.exists()) {
                JOptionPane.showMessageDialog(this, I18n.tr("3dxm.DocPrefsDialog.error.DocsDirDoesNotExist"));
                return false;
            }
            if (!file.isDirectory()) {
                JOptionPane.showMessageDialog(this, I18n.tr("3dxm.DocPrefsDialog.error.DocsDirIsNotDirectory"));
                return false;
            }
        }
        this.externalBrowserCommand = (String)this.browserSelect.getSelectedItem();
        boolean bl = this.useExternalBrowser = !this.externalBrowserCommand.equals(I18n.tr("3dxm.DocPrefsDialog.BuiltInBrowser"));
        if (this.useExternalBrowser && !this.externalBrowserCommand.contains("%f")) {
            JOptionPane.showMessageDialog(this, I18n.tr("3dxm.DocPrefsDialog.error.BadBrowserCommand"));
            return false;
        }
        Prefs.putBoolean("3dxm.docprefs.useExternalBrowser", this.useExternalBrowser);
        Prefs.save("3dxm.docprefs.useExternalBrowser");
        if (this.useExternalBrowser) {
            Prefs.putAndSave("3dxm.docprefs.externalBrowserCommand", this.externalBrowserCommand);
        } else {
            Prefs.putAndSave("3dxm.docprefs.externalBrowserCommand", "");
        }
        this.documentationBaseURL = docsLoc;
        Prefs.putAndSave("3dxm.docprefs.documentationBaseURL", this.documentationBaseURL);
        return true;
    }
}

