/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.actions.ActionRadioGroup;
import vmm3d.actions.ToggleAction;
import vmm3d.core.BasicAnimator;
import vmm3d.core.Complex;
import vmm3d.core.I18n;
import vmm3d.core.Parameter;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.VMMSave;
import vmm3d.core.View;
import vmm3d.core3D.ComplexVector3D;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.SurfaceView;
import vmm3d.surface.parametric.SurfaceParametric;

public abstract class WeierstrassMinimalSurface
extends SurfaceParametric {
    public static final Complex ZERO_C = new Complex(0.0, 0.0);
    public static final Complex ONE_C = new Complex(1.0, 0.0);
    public static final Complex ONE__C = new Complex(-1.0, 0.0);
    public static final Complex IP_C = new Complex(0.0, Math.PI);
    public static final Complex IP__C = new Complex(0.0, -Math.PI);
    public static final Complex I_C = new Complex(0.0, 1.0);
    public static final Complex I__C = new Complex(0.0, -1.0);
    public static final Complex I1_C = new Complex(Math.sqrt(0.5), Math.sqrt(0.5));
    public static final Complex I2_C = new Complex(-Math.sqrt(0.5), Math.sqrt(0.5));
    public static final Complex I3_C = new Complex(-Math.sqrt(0.5), -Math.sqrt(0.5));
    public static final Complex I4_C = new Complex(Math.sqrt(0.5), -Math.sqrt(0.5));
    protected static final Complex del = new Complex(1.0E-8, 0.0);
    public RealParamAnimateable afp = new RealParamAnimateable("vmm3d.surface.parametric.WeierstrassMinimalSurface.AssocFamParam", 0.0, 0.0, 0.0);
    protected boolean canShowConjugateSurface = false;
    @VMMSave
    private int numberOfPieces = 1;
    protected int[] multipleCopyOptions = null;
    protected int ucount;
    protected int vcount;
    protected boolean iFirstInHelper = true;
    protected boolean iBeginMiddleInHelper = false;
    protected double du;
    protected double dv;
    protected double distFrom0;
    protected double AFP = this.afp.getValue();
    protected double LRPclosed = 1.0;
    protected ComplexVector3D[][] helperArray;
    protected ComplexVector3D halfPeriod = new ComplexVector3D(ComplexVector3D.ORIGIN);
    protected boolean flag0;
    protected boolean flag05;
    protected boolean wantsToSeeDomain = false;
    protected boolean wantsToSeeGaussImage = false;
    protected boolean needsValueArray = true;
    protected boolean needsPeriodClosed = false;
    protected boolean inAssociateMorph = false;
    static final double weight1 = 0.35555555555555557;
    static final double weight2 = 0.05;
    static final double weight3 = 0.2722222222222222;
    static final double sqrtOf3Over28 = Math.sqrt(0.10714285714285714);
    static final double almost0 = 5.960464477539063E-8;
    private ToggleAction numberOfPiecesToggle;
    private ActionRadioGroup numberOfPiecesSelect;
    private ToggleAction showConjugateSurfaceToggle;

    public WeierstrassMinimalSurface() {
        this.setFramesForMorphing(20);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-1.5);
        this.umax.reset(1.5);
        this.vmin.reset(-1.5);
        this.vmax.reset(1.5);
        this.setDefaultViewpoint(new Vector3D(20.0, -20.0, 20.0));
        this.setDefaultWindow(-4.0, 4.0, -4.0, 4.0);
        this.addParameter(this.afp);
    }

    @Override
    protected void createData() {
        this.flag0 = Math.abs(this.afp.getValue()) < 0.001 || Math.abs(this.afp.getValue() - Math.PI) < 0.001 || Math.abs(this.afp.getValue() - Math.PI * 2) < 0.001;
        boolean bl = this.flag05 = Math.abs(this.afp.getValue() + 1.5707963267948966) < 0.001 || Math.abs(this.afp.getValue() - 1.5707963267948966) < 0.001;
        if (this.needsValueArray) {
            this.redoConstants();
            this.createHelperArray();
            System.out.println("created helperArray");
            if (this.needsPeriodClosed) {
                this.doClosingJob();
                this.needsPeriodClosed = false;
            }
            this.needsValueArray = false;
            this.computeHalfPeriod();
        }
        super.createData();
    }

    protected Complex domainGrid(double u, double v) {
        return new Complex(u, v);
    }

    protected abstract Complex gauss(Complex var1);

    protected abstract Complex hPrime(Complex var1);

    protected ComplexVector3D getCenter() {
        int um = (int)Math.floor((double)(this.ucount - 1) / 2.0);
        int vm = (int)Math.floor((double)(this.vcount - 1) / 2.0);
        return new ComplexVector3D(this.helperArray[um][vm]);
    }

    protected Complex intersectLines(Complex z1, Complex z2, Complex w1, Complex w2) {
        Complex wPerp = w2.minus(w1).times(I_C);
        Complex zDiff = z2.minus(z1);
        double s = w1.minus(z1).dot(wPerp) / zDiff.dot(wPerp);
        return z1.plus(zDiff.times(s));
    }

    protected static double monotonPow(double u, int e) {
        double w = 1.0;
        if (e > 0) {
            w = u;
        }
        if (e > 1) {
            for (int i = 2; i <= e; ++i) {
                w *= Math.abs(u);
            }
        }
        return w;
    }

    protected void doClosingJob() {
    }

    protected void redoConstants() {
        this.ucount = 1 + this.uPatchCount.getValue() * 6;
        this.vcount = 1 + this.vPatchCount.getValue() * 6;
        this.helperArray = new ComplexVector3D[this.ucount][this.vcount];
        this.du = (this.umax.getValue() - this.umin.getValue()) / (double)(this.ucount - 1);
        this.dv = (this.vmax.getValue() - this.vmin.getValue()) / (double)(this.vcount - 1);
    }

    protected Complex gaussTimesHPrime(Complex z) {
        Complex w = this.gauss(z);
        w.assignTimes(this.hPrime(z));
        return w;
    }

    protected Complex gaussInverseTimesHPrime(Complex z) {
        if (this.gauss((Complex)z).re == 0.0 && this.gauss((Complex)z).im == 0.0) {
            return this.gauss(z.plus(del)).inverse().times(this.hPrime(z.plus(del)));
        }
        Complex w = this.hPrime(z);
        w.assignDivide(this.gauss(z));
        return w;
    }

    protected Complex component3(Complex z) {
        Complex w = this.hPrime(z);
        w.assignTimes(2.0);
        return w;
    }

    @Override
    public Vector3D surfaceNormal(double u, double v) {
        Complex z = this.domainGrid(u, v);
        Complex g = this.gauss(z);
        Vector3D VV = new Vector3D(g.re * 2.0, g.im * 2.0, g.abs2() - 1.0);
        double norm = VV.norm();
        if (Double.isInfinite(norm) || Double.isNaN(norm) || norm == 0.0) {
            VV.x = 1.0;
            VV.y = 0.0;
            VV.z = 0.0;
        } else {
            VV.normalize();
        }
        return VV;
    }

    protected ComplexVector3D ComplexVectorFunction(Complex z) {
        Complex h;
        Complex g;
        if (this.wantsToSeeDomain) {
            g = new Complex(ONE_C);
            h = new Complex(ONE_C);
        } else {
            g = this.gauss(z);
            h = this.hPrime(z);
        }
        return new ComplexVector3D(h.times(g), h.dividedBy(g), h.times(2.0));
    }

    public ComplexVector3D ComplexVectorOneStepIntegrator(Complex zInitial, Complex zFinal) {
        ComplexVector3D w = new ComplexVector3D();
        Complex dz = zFinal.minus(zInitial);
        if (Math.abs(dz.re) + Math.abs(dz.im) > 5.960464477539063E-8) {
            Complex zMiddle = zInitial.plus(zFinal);
            zMiddle.assignTimes(0.5);
            Complex zGaussRight = dz.times(sqrtOf3Over28);
            Complex zGaussLeft = zMiddle.minus(zGaussRight);
            zGaussRight.assignPlus(zMiddle);
            w = this.ComplexVectorFunction(zMiddle);
            w.assignTimes(0.35555555555555557);
            ComplexVector3D aux = this.ComplexVectorFunction(zInitial);
            aux.assignPlus(this.ComplexVectorFunction(zFinal));
            aux.assignTimes(0.05);
            w.assignPlus(aux);
            aux = this.ComplexVectorFunction(zGaussLeft);
            aux.assignPlus(this.ComplexVectorFunction(zGaussRight));
            aux.assignTimes(0.2722222222222222);
            w.assignPlus(aux);
            w.assignTimes(dz);
        }
        return w;
    }

    public ComplexVector3D ComplexVectorIntegrator(Complex zInitial, Complex zFinal, int numSteps) {
        ComplexVector3D w = new ComplexVector3D();
        Complex dz = zFinal.minus(zInitial);
        if (Math.abs(dz.re) + Math.abs(dz.im) > 5.960464477539063E-8) {
            int newNumSteps = (int)Math.floor((1.0 + dz.r()) * (double)numSteps);
            dz = dz.times(1.0 / (double)newNumSteps);
            for (int j = 0; j < newNumSteps; ++j) {
                Complex z = new Complex(zInitial.times(1.0 * (double)(newNumSteps - j)).plus(zFinal.times(1.0 * (double)j)).times(1.0 / (double)newNumSteps));
                w = w.plus(this.ComplexVectorOneStepIntegrator(z, z.plus(dz)));
            }
        }
        return w;
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        int i = (int)Math.floor(0.25 + (u - this.umin.getValue()) / this.du);
        int j = (int)Math.floor(0.25 + (v - this.vmin.getValue()) / this.dv);
        ComplexVector3D auxW = new ComplexVector3D(this.helperArray[i][j].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)i * this.du, this.vmin.getValue() + (double)j * this.dv), this.domainGrid(u, v))));
        ComplexVector3D eW = this.helperToMinimal(auxW);
        if (this.wantsToSeeDomain) {
            return new Vector3D(eW.z.re, eW.z.im, 0.0);
        }
        if (this.AFP == 0.0) {
            return eW.re();
        }
        return eW.re().times(Math.cos(this.AFP)).plus(eW.im().times(Math.sin(this.AFP)));
    }

    public ComplexVector3D helperToMinimal(ComplexVector3D hp) {
        return new ComplexVector3D(hp.y.minus(hp.x), hp.y.plus(hp.x).times(I_C), hp.z);
    }

    public ComplexVector3D minimalToHelper(ComplexVector3D mn) {
        return new ComplexVector3D(mn.x.plus(mn.y.times(I_C)).times(-0.5), mn.x.minus(mn.y.times(I_C)).times(0.5), mn.z);
    }

    public void createHelperArray() {
        int i;
        Complex z;
        this.distFrom0 = 1.0;
        int nsteps = 4;
        double u = this.umin.getValue();
        double v = this.vmin.getValue();
        Complex zInitial = this.domainGrid(u, v);
        this.distFrom0 = Math.min(zInitial.r(), this.distFrom0);
        this.helperArray[0][0] = new ComplexVector3D(ZERO_C, ZERO_C, ZERO_C);
        if (this.iFirstInHelper) {
            int i2;
            for (i2 = 0; i2 < this.ucount - 1; ++i2) {
                z = this.domainGrid(u += this.du, v);
                this.helperArray[i2 + 1][0] = this.helperArray[i2][0].plus(this.ComplexVectorIntegrator(zInitial, z, nsteps));
                zInitial = z;
                this.distFrom0 = Math.min(zInitial.r(), this.distFrom0);
            }
            u = this.umin.getValue();
            for (i2 = 0; i2 < this.ucount; ++i2) {
                zInitial = this.domainGrid(u, v);
                for (int j = 1; j < this.vcount; ++j) {
                    z = this.domainGrid(u, v += this.dv);
                    this.helperArray[i2][j] = i2 == 0 || i2 == this.ucount - 1 ? this.helperArray[i2][j - 1].plus(this.ComplexVectorIntegrator(zInitial, z, nsteps)) : this.helperArray[i2][j - 1].plus(this.ComplexVectorOneStepIntegrator(zInitial, z));
                    zInitial = z;
                    this.distFrom0 = Math.min(zInitial.r(), this.distFrom0);
                }
                v = this.vmin.getValue();
                zInitial = this.domainGrid(u, v);
                u += this.du;
            }
        } else if (!this.iBeginMiddleInHelper) {
            int j;
            for (j = 0; j < this.vcount - 1; ++j) {
                z = this.domainGrid(u, v += this.dv);
                this.helperArray[0][j + 1] = this.helperArray[0][j].plus(this.ComplexVectorIntegrator(zInitial, z, nsteps));
                zInitial = z;
                this.distFrom0 = Math.min(zInitial.r(), this.distFrom0);
            }
            v = this.vmin.getValue();
            for (j = 0; j < this.vcount; ++j) {
                zInitial = this.domainGrid(u, v);
                for (i = 1; i < this.ucount; ++i) {
                    z = this.domainGrid(u += this.du, v);
                    this.helperArray[i][j] = j == 0 || j == this.vcount - 1 ? this.helperArray[i - 1][j].plus(this.ComplexVectorIntegrator(zInitial, z, nsteps)) : this.helperArray[i - 1][j].plus(this.ComplexVectorOneStepIntegrator(zInitial, z));
                    zInitial = z;
                    this.distFrom0 = Math.min(zInitial.r(), this.distFrom0);
                }
                u = this.umin.getValue();
                zInitial = this.domainGrid(u, v);
                v += this.dv;
            }
        } else {
            int i3;
            int um = (int)Math.floor(0.5 * (double)(this.ucount - 1));
            int vm = (int)Math.floor(0.5 * (double)(this.vcount - 1));
            this.helperArray[0][vm] = new ComplexVector3D(ZERO_C, ZERO_C, ZERO_C);
            u = this.umin.getValue();
            v = this.vmin.getValue() + this.dv * (double)vm;
            zInitial = this.domainGrid(u, v);
            for (i3 = 0; i3 < this.ucount - 1; ++i3) {
                z = this.domainGrid(u += this.du, v);
                this.helperArray[i3 + 1][vm] = this.helperArray[i3][vm].plus(this.ComplexVectorIntegrator(zInitial, z, 2 * nsteps));
                zInitial = z;
                this.distFrom0 = Math.min(zInitial.r(), this.distFrom0);
            }
            u = this.umin.getValue();
            for (i3 = 0; i3 < this.ucount; ++i3) {
                int j;
                v = this.vmin.getValue() + this.dv * (double)vm;
                zInitial = this.domainGrid(u, v);
                for (j = vm + 1; j < this.vcount; ++j) {
                    z = this.domainGrid(u, v += this.dv);
                    this.helperArray[i3][j] = z.r() < 0.125 || i3 == this.ucount - 1 ? this.helperArray[i3][j - 1].plus(this.ComplexVectorIntegrator(zInitial, z, nsteps)) : this.helperArray[i3][j - 1].plus(this.ComplexVectorOneStepIntegrator(zInitial, z));
                    zInitial = z;
                    this.distFrom0 = Math.min(zInitial.r(), this.distFrom0);
                }
                v = this.vmin.getValue() + this.dv * (double)vm;
                zInitial = this.domainGrid(u, v);
                for (j = vm - 1; j >= 0; --j) {
                    z = this.domainGrid(u, v -= this.dv);
                    this.helperArray[i3][j] = z.r() < 0.125 || i3 == this.ucount - 1 ? this.helperArray[i3][j + 1].plus(this.ComplexVectorIntegrator(zInitial, z, nsteps)) : this.helperArray[i3][j + 1].plus(this.ComplexVectorOneStepIntegrator(zInitial, z));
                    zInitial = z;
                    this.distFrom0 = Math.min(zInitial.r(), this.distFrom0);
                }
                u += this.du;
            }
        }
        ComplexVector3D hA00 = this.getCenter();
        for (i = 0; i < this.ucount; ++i) {
            for (int j = 0; j < this.vcount; ++j) {
                this.helperArray[i][j].assignMinus(hA00);
            }
        }
    }

    public void computeHalfPeriod() {
    }

    @Override
    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actions = super.getAdditionalAnimationsForView(view);
        actions.add(new AbstractActionVMM(I18n.tr("vmm3d.surface.parametric.WeierstrassMinimalSurface.AssociateMorph")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicAnimator animation = new BasicAnimator();
                animation.setLooping(1);
                WeierstrassMinimalSurface.this.needsValueArray = true;
                WeierstrassMinimalSurface.this.createHelperArray();
                animation.setUseFilmstrip(WeierstrassMinimalSurface.this.getUseFilmstripForMorphing());
                final int numFrames = WeierstrassMinimalSurface.this.getFramesForMorphing();
                WeierstrassMinimalSurface.this.setFramesForMorphing(24);
                animation.setFrames(WeierstrassMinimalSurface.this.getFramesForMorphing());
                animation.setMillisecondsPerFrame(200);
                animation.addWithCustomLimits(WeierstrassMinimalSurface.this.afp, 0.0, Math.PI * 2);
                view.setShowAxes(true);
                animation.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent evt) {
                        if (((BasicAnimator)evt.getSource()).isRunning()) {
                            WeierstrassMinimalSurface.this.inAssociateMorph = true;
                        } else {
                            WeierstrassMinimalSurface.this.inAssociateMorph = false;
                            WeierstrassMinimalSurface.this.needsValueArray = true;
                            WeierstrassMinimalSurface.this.createHelperArray();
                            WeierstrassMinimalSurface.this.setFramesForMorphing(numFrames);
                            view.setShowAxes(false);
                        }
                    }
                });
                view.getDisplay().installAnimation(animation);
            }
        });
        return actions;
    }

    public int getNumberOfPieces() {
        return this.numberOfPieces;
    }

    public void setNumberOfPieces(int numberOfPieces) {
        block9: {
            block8: {
                if (this.multipleCopyOptions == null || numberOfPieces == this.numberOfPieces) {
                    return;
                }
                boolean valueOK = false;
                if (numberOfPieces == 1) {
                    valueOK = true;
                }
                for (int n : this.multipleCopyOptions) {
                    if (numberOfPieces != n) continue;
                    valueOK = true;
                }
                if (!valueOK) {
                    return;
                }
                this.numberOfPieces = numberOfPieces;
                if (this.multipleCopyOptions.length != 1) break block8;
                if (this.numberOfPiecesToggle == null) break block9;
                this.numberOfPiecesToggle.setState(numberOfPieces > 1);
                break block9;
            }
            if (this.numberOfPiecesSelect != null) {
                if (numberOfPieces == 1) {
                    this.numberOfPiecesSelect.setSelectedIndex(0);
                } else {
                    for (int i = 0; i < this.multipleCopyOptions.length; ++i) {
                        if (numberOfPieces != this.multipleCopyOptions[i]) continue;
                        this.numberOfPiecesSelect.setSelectedIndex(i + 1);
                        break;
                    }
                }
            }
        }
        this.forceRedraw();
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        if (this.showConjugateSurfaceToggle != null && param == this.afp) {
            this.showConjugateSurfaceToggle.setState(Math.abs(1.5707963267948966 - this.afp.getValue()) < 0.001);
        }
        this.AFP = this.afp.getValue();
        if (param != this.afp) {
            this.needsValueArray = true;
        }
    }

    @Override
    public View getDefaultView() {
        return new WMSView();
    }

    public class WMSView
    extends SurfaceView {
        @Override
        public ActionList getActions() {
            ActionList actions = super.getActions();
            if (WeierstrassMinimalSurface.this.canShowConjugateSurface || WeierstrassMinimalSurface.this.multipleCopyOptions != null) {
                actions.add(null);
            }
            if (WeierstrassMinimalSurface.this.canShowConjugateSurface) {
                if (WeierstrassMinimalSurface.this.showConjugateSurfaceToggle == null) {
                    WeierstrassMinimalSurface.this.showConjugateSurfaceToggle = new ToggleAction(I18n.tr("vmm3d.surface.parametric.WeierstrassMinimalSurface.ShowConjugateSurface")){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            if (this.getState()) {
                                WeierstrassMinimalSurface.this.afp.reset("pi/2");
                            } else {
                                WeierstrassMinimalSurface.this.afp.reset(0.0);
                            }
                        }
                    };
                }
                actions.add(WeierstrassMinimalSurface.this.showConjugateSurfaceToggle);
            }
            if (WeierstrassMinimalSurface.this.multipleCopyOptions != null) {
                if (WeierstrassMinimalSurface.this.multipleCopyOptions.length == 1) {
                    if (WeierstrassMinimalSurface.this.numberOfPiecesToggle == null) {
                        WeierstrassMinimalSurface.this.numberOfPiecesToggle = new ToggleAction(I18n.tr("vmm3d.surface.parametric.WeierstrassMinimalSurface.ShowMoreCopies")){

                            @Override
                            public void actionPerformed(ActionEvent evt) {
                                if (this.getState()) {
                                    WeierstrassMinimalSurface.this.setNumberOfPieces(WeierstrassMinimalSurface.this.multipleCopyOptions[0]);
                                } else {
                                    WeierstrassMinimalSurface.this.setNumberOfPieces(1);
                                }
                            }
                        };
                        WeierstrassMinimalSurface.this.numberOfPiecesToggle.setState(WeierstrassMinimalSurface.this.numberOfPieces > 1);
                    }
                    actions.add(WeierstrassMinimalSurface.this.numberOfPiecesToggle);
                } else {
                    if (WeierstrassMinimalSurface.this.numberOfPiecesSelect == null) {
                        WeierstrassMinimalSurface.this.numberOfPiecesSelect = new ActionRadioGroup(){

                            @Override
                            public void optionSelected(int selectedIndex) {
                                if (selectedIndex == 0) {
                                    WeierstrassMinimalSurface.this.setNumberOfPieces(1);
                                } else {
                                    WeierstrassMinimalSurface.this.setNumberOfPieces(WeierstrassMinimalSurface.this.multipleCopyOptions[selectedIndex - 1]);
                                }
                            }
                        };
                        WeierstrassMinimalSurface.this.numberOfPiecesSelect.addItem(I18n.tr("vmm3d.surface.parametric.WeierstrassMinimalSurface.NumberOfCopies.Default"));
                        for (int n : WeierstrassMinimalSurface.this.multipleCopyOptions) {
                            WeierstrassMinimalSurface.this.numberOfPiecesSelect.addItem(I18n.tr("vmm3d.surface.parametric.WeierstrassMinimalSurface.NumberOfCopies.NTimesDefault", "" + n));
                        }
                        if (WeierstrassMinimalSurface.this.numberOfPieces == 1) {
                            WeierstrassMinimalSurface.this.numberOfPiecesSelect.setSelectedIndex(0);
                        }
                        for (int i = 0; i < WeierstrassMinimalSurface.this.multipleCopyOptions.length; ++i) {
                            if (WeierstrassMinimalSurface.this.numberOfPieces != WeierstrassMinimalSurface.this.multipleCopyOptions[i]) continue;
                            WeierstrassMinimalSurface.this.numberOfPiecesSelect.setSelectedIndex(i + 1);
                            break;
                        }
                    }
                    ActionList list = new ActionList(I18n.tr("vmm3d.surface.parametric.WeierstrassMinimalSurface.NumberOfCopies"));
                    list.add(WeierstrassMinimalSurface.this.numberOfPiecesSelect);
                    actions.add(list);
                }
            }
            return actions;
        }
    }
}

