/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import vmm3d.actions.ActionList;
import vmm3d.actions.ActionRadioGroup;
import vmm3d.core.I18n;
import vmm3d.core.ParameterInput;
import vmm3d.core.RealParam;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.SaveAndRestore;
import vmm3d.core.SettingsDialog;
import vmm3d.core.TaskManager;
import vmm3d.core.View;
import vmm3d.core3D.Grid3D;
import vmm3d.core3D.LightSettings;
import vmm3d.core3D.Vector3D;
import vmm3d.core3D.View3DLit;
import vmm3d.functions.Function2;
import vmm3d.functions.ParseError;
import vmm3d.functions.Parser;
import vmm3d.functions.Variable;
import vmm3d.surface.Surface;

public abstract class SurfaceParametric
extends Surface {
    public static final int COLOR_WHITE = 0;
    public static final int COLOR_USER = 1;
    public static final int COLOR_TWO_SIDED_DEFAULT = 2;
    public static final int COLOR_TWO_SIDED_USER = 3;
    public static final int COLOR_GAUSS_CURVATURE = 5;
    public static final int COLOR_MEAN_CURVATURE = 6;
    public static final int COLOR_USER_FUNCTION_HSB = 7;
    public static final int COLOR_USER_FUNCTION_RGB = 8;
    private static final Color DEFAULT_FRONT_FACE_COLOR = new Color(229, 229, 178);
    private static final Color DEFAULT_BACK_FACE_COLOR = new Color(173, 166, 255);
    private int colorationType = 0;
    private Color twoSidedColor;
    private Color frontColor = DEFAULT_FRONT_FACE_COLOR;
    private Color backColor = DEFAULT_BACK_FACE_COLOR;
    private Variable uminVar = new Variable("umin");
    private Variable umaxVar = new Variable("umax");
    private Variable vminVar = new Variable("vmin");
    private Variable vmaxVar = new Variable("vmax");
    private Function2[] userColorExpressionHSB;
    private Function2[] userColorExpressionRGB;
    private String[] userColorExpressionHSBDefinitions;
    private String[] userColorExpressionRGBDefinitions;
    private TaskManager taskManager;
    private ActionRadioGroup surfaceColorationSelect = new ActionRadioGroup(new String[]{I18n.tr("vmm3d.surface.parametric.SurfaceParametric.color.WhitePaint"), I18n.tr("vmm3d.surface.parametric.SurfaceParametric.color.UserPaint"), I18n.tr("vmm3d.surface.parametric.SurfaceParametric.color.TwoSidedDefault"), I18n.tr("vmm3d.surface.parametric.SurfaceParametric.color.TwoSidedUser"), null, I18n.tr("vmm3d.surface.parametric.SurfaceParametric.color.GaussCurvature"), I18n.tr("vmm3d.surface.parametric.SurfaceParametric.color.MeanCurvature"), I18n.tr("vmm3d.surface.parametric.SurfaceParametric.color.UserHSB"), I18n.tr("vmm3d.surface.parametric.SurfaceParametric.color.UserRGB")}, 0){

        @Override
        public void optionSelected(int selectedIndex) {
            SurfaceParametric.this.doSurfaceColorationCommand(selectedIndex);
        }
    };
    protected RealParamAnimateable umin = new RealParamAnimateable("vmm3d.surface.parametric.SurfaceParametric.Umin", -5.0);
    protected RealParamAnimateable umax = new RealParamAnimateable("vmm3d.surface.parametric.SurfaceParametric.Umax", 5.0);
    protected RealParamAnimateable vmin = new RealParamAnimateable("vmm3d.surface.parametric.SurfaceParametric.Vmin", -5.0);
    protected RealParamAnimateable vmax = new RealParamAnimateable("vmm3d.surface.parametric.SurfaceParametric.Vmax", 5.0);
    private double epsilon = 5.0E-5;

    public abstract Vector3D surfacePoint(double var1, double var3);

    public SurfaceParametric() {
        this.addParameter(this.vmax);
        this.addParameter(this.vmin);
        this.addParameter(this.umax);
        this.addParameter(this.umin);
        this.setFramesForMorphing(20);
    }

    public void setPatchCount(int unumber, int vnumber) {
        this.uPatchCount.setValueAndDefault(unumber);
        this.vPatchCount.setValueAndDefault(vnumber);
    }

    public int getPatchCountU() {
        return this.uPatchCount.getValue();
    }

    public int getPatchCountV() {
        return this.vPatchCount.getValue();
    }

    public void setViewpoint(double x, double y, double z) {
        this.setDefaultViewpoint(new Vector3D(x, y, z));
    }

    public void setU(double min, double max) {
        this.umin.setValueAndDefault(min);
        this.umax.setValueAndDefault(max);
    }

    public void setV(double min, double max) {
        this.vmin.setValueAndDefault(min);
        this.vmax.setValueAndDefault(max);
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public Vector3D deriv_u(double u, double v) {
        return this.surfacePoint(u + this.epsilon, v).minus(this.surfacePoint(u - this.epsilon, v)).times(1.0 / (2.0 * this.epsilon));
    }

    public Vector3D deriv_v(double u, double v) {
        return this.surfacePoint(u, v + this.epsilon).minus(this.surfacePoint(u, v - this.epsilon)).times(1.0 / (2.0 * this.epsilon));
    }

    public Vector3D surfaceNormal(double u, double v) {
        Vector3D d1 = this.deriv_u(u, v);
        Vector3D d2 = this.deriv_v(u, v);
        return d1.cross(d2);
    }

    @Override
    public void removeView(View view) {
        super.removeView(view);
        if (this.taskManager != null && (this.getViews() == null || this.getViews().size() == 0)) {
            this.taskManager.shutDown();
            this.taskManager = null;
        }
    }

    @Override
    protected void createData() {
        if (this.data == null || this.data.getUPatchCount() != this.uPatchCount.getValue() || this.data.getVPatchCount() != this.vPatchCount.getValue()) {
            this.data = new Grid3D(this.uPatchCount.getValue(), this.vPatchCount.getValue());
        }
        int uCount = this.data.getUCount();
        int vCount = this.data.getVCount();
        double u1 = this.umin.getValue();
        double u2 = this.umax.getValue();
        double v1 = this.vmin.getValue();
        double v2 = this.vmax.getValue();
        double du = (u2 - u1) / (double)(uCount - 1);
        double dv = (v2 - v1) / (double)(vCount - 1);
        this.uminVar.setVal(this.umin.getValue());
        this.umaxVar.setVal(this.umax.getValue());
        this.vminVar.setVal(this.vmin.getValue());
        this.vmaxVar.setVal(this.vmax.getValue());
        if (this.taskManager == null) {
            this.taskManager = new TaskManager();
        }
        ArrayList<ComputeOneRowOfGrid> tasks = new ArrayList<ComputeOneRowOfGrid>(uCount);
        for (int i = 0; i < uCount; ++i) {
            tasks.add(new ComputeOneRowOfGrid(this.data, i, u1 + (double)i * du, v1, dv, vCount));
        }
        this.taskManager.executeAndWait(tasks);
        if (this.colorationType <= 3) {
            this.data.clearPatchColors();
            switch (this.colorationType) {
                case 0: {
                    this.data.setDefaultPatchColor(Color.WHITE);
                    this.data.setDefaultBackColor(null);
                    break;
                }
                case 1: {
                    this.data.setDefaultPatchColor(this.twoSidedColor);
                    this.data.setDefaultBackColor(null);
                    break;
                }
                case 2: 
                case 3: {
                    this.data.setDefaultPatchColor(this.frontColor);
                    this.data.setDefaultBackColor(this.backColor);
                }
            }
        }
    }

    private Color computePatchColor(double u, double v) {
        switch (this.colorationType) {
            case 5: {
                double gc = this.findGaussAndMeanCurvatureAt(u, v)[1];
                double gc_mod1 = gc - (double)((int)Math.floor(gc));
                return Color.getHSBColor((float)gc_mod1, 1.0f, 1.0f);
            }
            case 6: {
                double mc = this.findGaussAndMeanCurvatureAt(u, v)[0];
                double mc_mod1 = mc - (double)((int)Math.floor(mc));
                return Color.getHSBColor((float)mc_mod1, 1.0f, 1.0f);
            }
        }
        try {
            if (this.colorationType == 7) {
                float a = (float)Math.max(0.0, Math.min(1.0, this.userColorExpressionHSB[0].value(u, v)));
                float b = (float)Math.max(0.0, Math.min(1.0, this.userColorExpressionHSB[1].value(u, v)));
                float c = (float)Math.max(0.0, Math.min(1.0, this.userColorExpressionHSB[2].value(u, v)));
                return Color.getHSBColor(a, b, c);
            }
            float a = (float)Math.max(0.0, Math.min(1.0, this.userColorExpressionRGB[0].value(u, v)));
            float b = (float)Math.max(0.0, Math.min(1.0, this.userColorExpressionRGB[1].value(u, v)));
            float c = (float)Math.max(0.0, Math.min(1.0, this.userColorExpressionRGB[2].value(u, v)));
            return new Color(a, b, c);
        }
        catch (NullPointerException e) {
            return Color.WHITE;
        }
    }

    @Override
    public ActionList getActionsForView(View view) {
        ActionList commands = super.getActionsForView(view);
        if (!(view instanceof View3DLit)) {
            return commands;
        }
        ActionList submenu = new ActionList(I18n.tr("vmm3d.surface.parametric.SurfaceParametric.SurfaceColoration"));
        submenu.add(this.surfaceColorationSelect);
        commands.add(null);
        commands.add(submenu);
        return commands;
    }

    @Override
    public void addExtraXML(Document containingDocument, Element viewElement) {
        super.addExtraXML(containingDocument, viewElement);
        if (this.colorationType != 0) {
            Element colorElement = containingDocument.createElement("surface_coloration");
            colorElement.setAttribute("type", "" + this.colorationType);
            switch (this.colorationType) {
                case 1: {
                    SaveAndRestore.addElement(containingDocument, colorElement, "user_color", this.twoSidedColor);
                    break;
                }
                case 3: {
                    SaveAndRestore.addElement(containingDocument, colorElement, "front_color", this.frontColor);
                    SaveAndRestore.addElement(containingDocument, colorElement, "back_color", this.backColor);
                    break;
                }
                case 7: {
                    SaveAndRestore.addElement(containingDocument, colorElement, "user_color_1", this.userColorExpressionHSBDefinitions[0]);
                    SaveAndRestore.addElement(containingDocument, colorElement, "user_color_2", this.userColorExpressionHSBDefinitions[1]);
                    SaveAndRestore.addElement(containingDocument, colorElement, "user_color_3", this.userColorExpressionHSBDefinitions[2]);
                    break;
                }
                case 8: {
                    SaveAndRestore.addElement(containingDocument, colorElement, "user_color_1", this.userColorExpressionRGBDefinitions[0]);
                    SaveAndRestore.addElement(containingDocument, colorElement, "user_color_2", this.userColorExpressionRGBDefinitions[1]);
                    SaveAndRestore.addElement(containingDocument, colorElement, "user_color_3", this.userColorExpressionRGBDefinitions[2]);
                }
            }
            viewElement.appendChild(colorElement);
        }
    }

    @Override
    public void readExtraXML(Element viewInfo) throws IOException {
        super.readExtraXML(viewInfo);
        try {
            NodeList nodes = viewInfo.getElementsByTagName("surface_coloration");
            if (nodes.getLength() == 0) {
                return;
            }
            Element colorElement = (Element)nodes.item(0);
            int colorType = Integer.parseInt(colorElement.getAttribute("type"));
            switch (colorType) {
                case 1: {
                    this.twoSidedColor = (Color)SaveAndRestore.getChildElementValue(colorElement, "user_color", Color.class);
                    if (this.twoSidedColor != null) break;
                    return;
                }
                case 3: {
                    this.frontColor = (Color)SaveAndRestore.getChildElementValue(colorElement, "front_color", Color.class);
                    this.backColor = (Color)SaveAndRestore.getChildElementValue(colorElement, "back_color", Color.class);
                    if (this.frontColor != null && this.backColor != null) break;
                    return;
                }
                case 7: 
                case 8: {
                    Parser parser = new Parser();
                    parser.add(this.uminVar);
                    parser.add(this.umaxVar);
                    parser.add(this.vminVar);
                    parser.add(this.vmaxVar);
                    Function2[] exp = new Function2[3];
                    String[] defs = new String[]{(String)SaveAndRestore.getChildElementValue(colorElement, "user_color_1", String.class), (String)SaveAndRestore.getChildElementValue(colorElement, "user_color_2", String.class), (String)SaveAndRestore.getChildElementValue(colorElement, "user_color_3", String.class)};
                    exp[0] = parser.parseFunction2(null, defs[0], "u", "v");
                    exp[1] = parser.parseFunction2(null, defs[1], "u", "v");
                    exp[2] = parser.parseFunction2(null, defs[2], "u", "v");
                    if (colorType == 7) {
                        this.userColorExpressionHSB = exp;
                        this.userColorExpressionHSBDefinitions = defs;
                        break;
                    }
                    this.userColorExpressionRGB = exp;
                    this.userColorExpressionRGBDefinitions = defs;
                }
            }
            this.colorationType = colorType;
            this.surfaceColorationSelect.setSelectedIndex(this.colorationType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector3D gaussMap(double u, double v) {
        Vector3D VV = this.deriv_u(u, v).cross(this.deriv_v(u, v));
        double norm = VV.norm();
        if (Double.isInfinite(norm) || Double.isNaN(norm) || norm == 0.0) {
            VV.x = 1.0;
            VV.y = 0.0;
            VV.z = 0.0;
        } else {
            VV.normalize();
        }
        return VV;
    }

    private Vector3D gaussMap_u(double u, double v) {
        return this.gaussMap(u + this.epsilon, v).minus(this.gaussMap(u - this.epsilon, v)).times(1.0 / (2.0 * this.epsilon));
    }

    private Vector3D gaussMap_v(double u, double v) {
        return this.gaussMap(u, v + this.epsilon).minus(this.gaussMap(u, v - this.epsilon)).times(1.0 / (2.0 * this.epsilon));
    }

    private double[] findGaussAndMeanCurvatureAt(double u, double v) {
        Vector3D X_u = this.deriv_u(u, v);
        Vector3D X_v = this.deriv_v(u, v);
        Vector3D N_u = this.gaussMap_u(u, v);
        Vector3D N_v = this.gaussMap_v(u, v);
        Vector3D e1 = X_u.normalized();
        double compX_vAlong_e1 = X_v.dot(e1);
        Vector3D w = e1.times(compX_vAlong_e1);
        Vector3D w1 = X_v.minus(w);
        Vector3D e2 = w1.normalized();
        Vector3D e3 = e1.plus(e2);
        Vector3D N_e1 = N_u.times(1.0 / X_u.norm());
        Vector3D N_w = N_e1.times(compX_vAlong_e1);
        Vector3D N_w1 = N_v.minus(N_w);
        Vector3D N_e2 = N_w1.times(1.0 / w1.norm());
        Vector3D N_e3 = N_e1.plus(N_e2);
        double A11 = -N_e1.dot(e1);
        double A22 = -N_e2.dot(e2);
        double A12 = 0.5 * (-N_e3.dot(e3) - A11 - A22);
        double meanCurvature = A11 + A22;
        double gaussianCurvature = A11 * A22 - A12 * A12;
        return new double[]{meanCurvature, gaussianCurvature};
    }

    private void doSurfaceColorationCommand(int command) {
        ArrayList<View> views = this.getViews();
        switch (command) {
            case 0: {
                this.twoSidedColor = null;
                for (int i = 0; i < views.size(); ++i) {
                    if (!(views.get(i) instanceof View3DLit)) continue;
                    ((View3DLit)views.get(i)).setLightSettings(new LightSettings());
                }
                break;
            }
            case 2: {
                this.frontColor = DEFAULT_FRONT_FACE_COLOR;
                this.backColor = DEFAULT_BACK_FACE_COLOR;
                for (int i = 0; i < views.size(); ++i) {
                    if (!(views.get(i) instanceof View3DLit)) continue;
                    ((View3DLit)views.get(i)).setLightSettings(new LightSettings(1));
                }
                break;
            }
            case 1: 
            case 3: {
                ColorDialog dialog = new ColorDialog(command == 3);
                dialog.setVisible(true);
                if (!dialog.canceled()) break;
                this.surfaceColorationSelect.setSelectedIndex(this.colorationType);
                return;
            }
            case 7: 
            case 8: {
                UserFunctionDialog dia = new UserFunctionDialog(command == 8);
                dia.setVisible(true);
                if (!dia.canceled()) break;
                this.surfaceColorationSelect.setSelectedIndex(this.colorationType);
                return;
            }
        }
        for (int i = 0; i < views.size(); ++i) {
            if (!(views.get(i) instanceof View3DLit)) continue;
            ((View3DLit)views.get(i)).setLightingEnabled(command <= 3);
        }
        this.surfaceColorationSelect.setSelectedIndex(command);
        this.colorationType = command;
        this.forceRedraw();
    }

    static /* synthetic */ Function2[] access$902(SurfaceParametric x0, Function2[] x1) {
        x0.userColorExpressionRGB = x1;
        return x1;
    }

    static /* synthetic */ String[] access$402(SurfaceParametric x0, String[] x1) {
        x0.userColorExpressionRGBDefinitions = x1;
        return x1;
    }

    static /* synthetic */ Function2[] access$1002(SurfaceParametric x0, Function2[] x1) {
        x0.userColorExpressionHSB = x1;
        return x1;
    }

    static /* synthetic */ String[] access$302(SurfaceParametric x0, String[] x1) {
        x0.userColorExpressionHSBDefinitions = x1;
        return x1;
    }

    private class ColorDialog
    extends SettingsDialog {
        private boolean twoSided;
        private RealParam[] params;
        private ParameterInput[] inputs;
        private JButton setButton;
        private JButton setButton2;
        private ActionListener setListener;

        ColorDialog(boolean twoSided) {
            super((Component)null, I18n.tr("vmm3d.surface.parametric.SurfaceParametric.dialog.UserColor"));
            this.setListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() == ColorDialog.this.setButton || evt.getSource() == ColorDialog.this.setButton2) {
                        Color c = Color.GRAY;
                        try {
                            c = evt.getSource() == ColorDialog.this.setButton ? new Color((float)ColorDialog.this.params[0].getValue(), (float)ColorDialog.this.params[1].getValue(), (float)ColorDialog.this.params[2].getValue()) : new Color((float)ColorDialog.this.params[3].getValue(), (float)ColorDialog.this.params[4].getValue(), (float)ColorDialog.this.params[5].getValue());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        c = JColorChooser.showDialog(ColorDialog.this, "", c);
                        if (c == null) {
                            return;
                        }
                        double r = (double)c.getRed() / 255.0;
                        double g = (double)c.getGreen() / 255.0;
                        double b = (double)c.getBlue() / 255.0;
                        r = (double)((int)(r * 100000.0 + 0.499)) / 100000.0;
                        g = (double)((int)(g * 100000.0 + 0.499)) / 100000.0;
                        b = (double)((int)(b * 100000.0 + 0.499)) / 100000.0;
                        if (evt.getSource() == ColorDialog.this.setButton) {
                            ColorDialog.this.inputs[0].setText("" + r);
                            ColorDialog.this.inputs[1].setText("" + g);
                            ColorDialog.this.inputs[2].setText("" + b);
                        } else {
                            ColorDialog.this.inputs[3].setText("" + r);
                            ColorDialog.this.inputs[4].setText("" + g);
                            ColorDialog.this.inputs[5].setText("" + b);
                        }
                    }
                }
            };
            this.twoSided = twoSided;
            if (twoSided) {
                this.params = new RealParam[6];
                this.inputs = new ParameterInput[6];
                this.params[0] = new RealParam(I18n.tr("common.Front") + I18n.tr("common.Red"), (double)SurfaceParametric.this.frontColor.getRed() / 255.0);
                this.params[1] = new RealParam(I18n.tr("common.Front") + I18n.tr("common.Green"), (double)SurfaceParametric.this.frontColor.getGreen() / 255.0);
                this.params[2] = new RealParam(I18n.tr("common.Front") + I18n.tr("common.Blue"), (double)SurfaceParametric.this.frontColor.getBlue() / 255.0);
                this.params[3] = new RealParam(I18n.tr("common.Back") + I18n.tr("common.Red"), (double)SurfaceParametric.this.backColor.getRed() / 255.0);
                this.params[4] = new RealParam(I18n.tr("common.Back") + I18n.tr("common.Green"), (double)SurfaceParametric.this.backColor.getGreen() / 255.0);
                this.params[5] = new RealParam(I18n.tr("common.Back") + I18n.tr("common.Blue"), (double)SurfaceParametric.this.backColor.getBlue() / 255.0);
                this.params[0].setDefaultValue(0.898);
                this.params[1].setDefaultValue(0.898);
                this.params[2].setDefaultValue(0.698);
                this.params[3].setDefaultValue(0.6784);
                this.params[4].setDefaultValue(0.651);
                this.params[5].setDefaultValue(1.0);
            } else {
                this.params = new RealParam[3];
                this.inputs = new ParameterInput[3];
                Color c = SurfaceParametric.this.twoSidedColor;
                if (c == null) {
                    c = Color.WHITE;
                }
                this.params[0] = new RealParam(I18n.tr("common.Red"), (double)c.getRed() / 255.0);
                this.params[1] = new RealParam(I18n.tr("common.Green"), (double)c.getGreen() / 255.0);
                this.params[2] = new RealParam(I18n.tr("common.Blue"), (double)c.getBlue() / 255.0);
                this.params[0].setDefaultValue(1.0);
                this.params[1].setDefaultValue(1.0);
                this.params[2].setDefaultValue(1.0);
            }
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i].setMinimumValueForInput(0.0);
                this.params[i].setMaximumValueForInput(1.0);
                this.inputs[i] = new ParameterInput(this.params[i]);
                this.inputs[i].setColumns(6);
            }
            JPanel inputPanel = new JPanel();
            inputPanel.setLayout(new GridLayout(0, twoSided ? 5 : 4, 5, 5));
            if (twoSided) {
                inputPanel.add(new JLabel());
            }
            inputPanel.add(new JLabel(I18n.tr("common.Red"), 0));
            inputPanel.add(new JLabel(I18n.tr("common.Green"), 0));
            inputPanel.add(new JLabel(I18n.tr("common.Blue"), 0));
            inputPanel.add(new JLabel());
            if (twoSided) {
                inputPanel.add(new JLabel(I18n.tr("common.Front") + ": ", 4));
            }
            inputPanel.add(this.inputs[0]);
            inputPanel.add(this.inputs[1]);
            inputPanel.add(this.inputs[2]);
            this.setButton = new JButton(I18n.tr("vmm3d.core3D.LightSettingsDialog.SetColorButton"));
            this.setButton.addActionListener(this.setListener);
            inputPanel.add(this.setButton);
            if (twoSided) {
                inputPanel.add(new JLabel(I18n.tr("common.Back") + ": ", 4));
                inputPanel.add(this.inputs[3]);
                inputPanel.add(this.inputs[4]);
                inputPanel.add(this.inputs[5]);
                this.setButton2 = new JButton(I18n.tr("vmm3d.core3D.LightSettingsDialog.SetColorButton"));
                this.setButton2.addActionListener(this.setListener);
                inputPanel.add(this.setButton2);
            }
            this.addInputPanel(inputPanel);
        }

        @Override
        protected void doApply() {
            if (this.doOK()) {
                int i;
                ArrayList<View> views = SurfaceParametric.this.getViews();
                SurfaceParametric.this.colorationType = this.twoSided ? 3 : 1;
                for (i = 0; i < views.size(); ++i) {
                    if (!(views.get(i) instanceof View3DLit)) continue;
                    ((View3DLit)views.get(i)).setLightingEnabled(true);
                }
                if (this.twoSided) {
                    for (i = 0; i < views.size(); ++i) {
                        if (!(views.get(i) instanceof View3DLit)) continue;
                        ((View3DLit)views.get(i)).setLightSettings(new LightSettings(1));
                    }
                } else {
                    for (i = 0; i < views.size(); ++i) {
                        if (!(views.get(i) instanceof View3DLit)) continue;
                        ((View3DLit)views.get(i)).setLightSettings(new LightSettings());
                    }
                }
                SurfaceParametric.this.forceRedraw();
            }
        }

        @Override
        protected boolean doOK() {
            for (int i = 0; i < this.inputs.length; ++i) {
                String error = this.inputs[i].checkContents();
                if (error != null) {
                    JOptionPane.showMessageDialog(this, error, I18n.tr("vmm3d.core.SettingsDialog.errorTitle"), 0);
                    return false;
                }
                this.inputs[i].setValueFromContents();
            }
            if (this.twoSided) {
                SurfaceParametric.this.frontColor = new Color((float)this.params[0].getValue(), (float)this.params[1].getValue(), (float)this.params[2].getValue());
                SurfaceParametric.this.backColor = new Color((float)this.params[3].getValue(), (float)this.params[4].getValue(), (float)this.params[5].getValue());
            } else {
                SurfaceParametric.this.twoSidedColor = new Color((float)this.params[0].getValue(), (float)this.params[1].getValue(), (float)this.params[2].getValue());
            }
            return true;
        }

        @Override
        protected void doDefaults() {
            for (int i = 0; i < this.inputs.length; ++i) {
                this.inputs[i].defaultVal();
            }
        }

        boolean canceled() {
            return this.canceled;
        }
    }

    private class UserFunctionDialog
    extends SettingsDialog {
        private boolean useRGB;
        private JTextField[] inputs;

        UserFunctionDialog(boolean useRGB) {
            super((Component)null, I18n.tr("vmm3d.surface.parametric.SurfaceParametric.dialog.UserColorFunctions"));
            this.inputs = new JTextField[3];
            this.useRGB = useRGB;
            JPanel inputPanel = new JPanel();
            inputPanel.setLayout(new BorderLayout(5, 5));
            JPanel left = new JPanel();
            left.setLayout(new GridLayout(0, 1, 5, 5));
            left.add(new JLabel(I18n.tr(useRGB ? "common.Red" : "common.Hue") + "(u,v) = ", 4));
            left.add(new JLabel(I18n.tr(useRGB ? "common.Green" : "common.Saturation") + "(u,v) = ", 4));
            left.add(new JLabel(I18n.tr(useRGB ? "common.Blue" : "common.Brightness") + "(u,v) = ", 4));
            inputPanel.add((Component)left, "West");
            this.inputs[0] = new JTextField(30);
            this.inputs[1] = new JTextField(30);
            this.inputs[2] = new JTextField(30);
            JPanel right = new JPanel();
            right.setLayout(new GridLayout(0, 1, 5, 5));
            right.add(this.inputs[0]);
            right.add(this.inputs[1]);
            right.add(this.inputs[2]);
            inputPanel.add((Component)right, "Center");
            if (!useRGB) {
                if (SurfaceParametric.this.userColorExpressionHSBDefinitions == null) {
                    this.doDefaults();
                } else {
                    this.inputs[0].setText(SurfaceParametric.this.userColorExpressionHSBDefinitions[0]);
                    this.inputs[1].setText(SurfaceParametric.this.userColorExpressionHSBDefinitions[1]);
                    this.inputs[2].setText(SurfaceParametric.this.userColorExpressionHSBDefinitions[2]);
                }
            } else if (SurfaceParametric.this.userColorExpressionRGBDefinitions == null) {
                this.doDefaults();
            } else {
                this.inputs[0].setText(SurfaceParametric.this.userColorExpressionRGBDefinitions[0]);
                this.inputs[1].setText(SurfaceParametric.this.userColorExpressionRGBDefinitions[1]);
                this.inputs[2].setText(SurfaceParametric.this.userColorExpressionRGBDefinitions[2]);
            }
            this.addInputPanel(inputPanel);
        }

        @Override
        protected boolean doOK() {
            Parser parser = new Parser();
            parser.add(SurfaceParametric.this.uminVar);
            parser.add(SurfaceParametric.this.umaxVar);
            parser.add(SurfaceParametric.this.vminVar);
            parser.add(SurfaceParametric.this.vmaxVar);
            Function2[] exp = new Function2[3];
            String[] defs = new String[3];
            for (int i = 0; i < 3; ++i) {
                defs[i] = this.inputs[i].getText();
                try {
                    exp[i] = parser.parseFunction2(null, defs[i], "u", "v");
                    continue;
                }
                catch (ParseError e) {
                    String error = I18n.tr("vmm3d.surface.parametric.SurfaceParametric.error.BadExpression", e.getMessage());
                    JOptionPane.showMessageDialog(this, error, I18n.tr("vmm3d.core.SettingsDialog.errorTitle"), 0);
                    this.inputs[i].selectAll();
                    this.inputs[i].requestFocus();
                    return false;
                }
            }
            if (this.useRGB) {
                SurfaceParametric.access$902(SurfaceParametric.this, exp);
                SurfaceParametric.access$402(SurfaceParametric.this, defs);
            } else {
                SurfaceParametric.access$1002(SurfaceParametric.this, exp);
                SurfaceParametric.access$302(SurfaceParametric.this, defs);
            }
            return true;
        }

        @Override
        protected void doApply() {
            if (this.doOK()) {
                SurfaceParametric.this.colorationType = this.useRGB ? 8 : 7;
                ArrayList<View> views = SurfaceParametric.this.getViews();
                for (int i = 0; i < views.size(); ++i) {
                    if (!(views.get(i) instanceof View3DLit)) continue;
                    ((View3DLit)views.get(i)).setLightingEnabled(false);
                }
                SurfaceParametric.this.forceRedraw();
            }
        }

        @Override
        protected void doDefaults() {
            if (this.useRGB) {
                this.inputs[0].setText("0.5");
                this.inputs[1].setText("(u - umin) / (umax - umin)");
                this.inputs[2].setText("(v - vmin) / (vmax - vmin)");
            } else {
                this.inputs[0].setText("(v - vmin) / (vmax - vmin)");
                this.inputs[1].setText("1");
                this.inputs[2].setText("1");
            }
        }

        boolean canceled() {
            return this.canceled;
        }
    }

    private class ComputeOneRowOfGrid
    implements Runnable {
        Grid3D data;
        int row;
        double u;
        double v1;
        double dv;
        int vCount;

        ComputeOneRowOfGrid(Grid3D data, int row, double u, double v1, double dv, int vCount) {
            this.row = row;
            this.u = u;
            this.data = data;
            this.v1 = v1;
            this.dv = dv;
            this.vCount = vCount;
        }

        @Override
        public void run() {
            for (int j = 0; j < this.vCount; ++j) {
                double v = this.v1 + (double)j * this.dv;
                this.data.setVertex(this.row, j, SurfaceParametric.this.surfacePoint(this.u, v));
                if (SurfaceParametric.this.colorationType > 3) {
                    this.data.setPatchColor(this.row, j, SurfaceParametric.this.computePatchColor(this.u, v));
                }
                Vector3D normal = SurfaceParametric.this.surfaceNormal(this.u, v);
                this.data.setNormal(this.row, j, normal);
            }
        }
    }
}

