/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import java.awt.Color;
import vmm3d.core.Complex;
import vmm3d.core.Parameter;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.View;
import vmm3d.core3D.ComplexVector3D;
import vmm3d.core3D.GridTransformMatrix;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.WeierstrassMinimalSurface;

public class SchwarzHsurface
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm3d.surface.parametric.SchwarzHsurface.aa", 0.538, 0.05, 0.95);
    private double gbranch;
    private double a3;
    private double scale;
    private Vector3D trans;
    private Vector3D transY;
    private Vector3D transZ;
    private Vector3D surf_1;
    private Vector3D surf_2;
    private Vector3D surf_3;
    private Vector3D norm_3;
    private GridTransformMatrix Msym;
    protected double AFPold = 0.0;

    public SchwarzHsurface() {
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.99);
        this.aa.setMinimumValueForInput(0.01);
        this.setDefaultOrientation(0);
        this.setDefaultViewUp(new Vector3D(-0.03, 0.87, 0.49));
        this.setDefaultViewpoint(new Vector3D(11.0, -24.0, 42.0));
        this.setDefaultWindow(-4.0, 4.0, -3.5, 3.1);
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(0.005);
        this.umax.reset(0.9995);
        this.vmin.reset(0.0);
        this.vmax.reset(2.0);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.removeParameter(this.umin);
        this.removeParameter(this.umax);
        this.iFirstInHelper = false;
        this.iBeginMiddleInHelper = true;
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.multipleCopyOptions = new int[]{2};
        this.canShowConjugateSurface = true;
    }

    @Override
    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView view = new WeierstrassMinimalSurface.WMSView(this);
        view.setGridSpacing(12);
        float c0 = 0.2f;
        view.getLightSettings().setAmbientLight(new Color(c0, c0, c0));
        view.getLightSettings().setSpecularExponent(100);
        view.getLightSettings().setSpecularRatio(0.8f);
        return view;
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        boolean AFPflag;
        super.parameterChanged(param, oldValue, newValue);
        this.AFP = this.afp.getValue();
        boolean bl = AFPflag = param == this.afp && (this.AFP == 0.0 || this.AFPold == 0.0);
        if (param != this.afp || AFPflag) {
            this.needsValueArray = true;
        }
        this.AFPold = this.AFP;
    }

    @Override
    protected void createData() {
        block12: {
            GridTransformMatrix Z120;
            GridTransformMatrix b;
            GridTransformMatrix a;
            GridTransformMatrix[] trList;
            block13: {
                int e;
                super.createData();
                this.computePeriodData();
                this.data.discardGridTransforms();
                trList = new GridTransformMatrix[64];
                trList[0] = new GridTransformMatrix();
                a = new GridTransformMatrix().scale(1.0, 1.0, -1.0);
                b = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).reverse();
                Z120 = new GridTransformMatrix().rotateZ(120.0);
                if (this.wantsToSeeDomain) break block12;
                if (this.flag0 && !this.inAssociateMorph) break block13;
                for (e = 0; e < 2; ++e) {
                    trList[1 + e] = new GridTransformMatrix(trList[e]).leftMultiplyBy(Z120);
                    this.data.addGridTransform(trList[1 + e]);
                }
                for (e = 0; e < 3; ++e) {
                    trList[3 + e] = new GridTransformMatrix(trList[e]).scale(-1.0, -1.0, -1.0).reverse();
                    this.data.addGridTransform(trList[3 + e]);
                }
                trList[6] = new GridTransformMatrix(trList[0]).scale(-1.0, -1.0, -1.0).reverse().translate(this.surf_1);
                this.data.addGridTransform(trList[6]);
                trList[7] = new GridTransformMatrix(trList[4]).scale(-1.0, -1.0, -1.0).reverse().translate(this.surf_1);
                this.data.addGridTransform(trList[7]);
                for (e = 0; e < 4; ++e) {
                    trList[8 + e] = new GridTransformMatrix(trList[6 + e]).leftMultiplyBy(Z120);
                    this.data.addGridTransform(trList[8 + e]);
                }
                for (e = 0; e < 6; ++e) {
                    trList[12 + e] = new GridTransformMatrix(trList[6 + e]).scale(-1.0, -1.0, -1.0).reverse();
                    this.data.addGridTransform(trList[12 + e]);
                }
                if (this.getNumberOfPieces() != 2) break block12;
                trList[18] = new GridTransformMatrix(trList[0]).leftMultiplyBy(this.Msym);
                this.data.addGridTransform(trList[18]);
                trList[19] = new GridTransformMatrix(trList[7]).leftMultiplyBy(this.Msym);
                this.data.addGridTransform(trList[19]);
                for (e = 0; e < 4; ++e) {
                    trList[20 + e] = new GridTransformMatrix(trList[18 + e]).leftMultiplyBy(Z120);
                    this.data.addGridTransform(trList[20 + e]);
                }
                for (e = 0; e < 6; ++e) {
                    trList[24 + e] = new GridTransformMatrix(trList[18 + e]).scale(-1.0, -1.0, -1.0).reverse();
                    this.data.addGridTransform(trList[24 + e]);
                }
                break block12;
            }
            if (this.flag0) {
                int e;
                trList[1] = new GridTransformMatrix(trList[0]).leftMultiplyBy(Z120);
                this.data.addGridTransform(trList[1]);
                trList[2] = new GridTransformMatrix(trList[1]).leftMultiplyBy(Z120);
                this.data.addGridTransform(trList[2]);
                for (e = 0; e < 3; ++e) {
                    trList[3 + e] = new GridTransformMatrix(trList[e]).leftMultiplyBy(a).translate(this.transZ);
                    this.data.addGridTransform(trList[3 + e]);
                }
                for (e = 0; e < 6; ++e) {
                    trList[6 + e] = new GridTransformMatrix(trList[e]).leftMultiplyBy(b).translate(this.transY);
                    this.data.addGridTransform(trList[6 + e]);
                }
                for (e = 0; e < 6; ++e) {
                    trList[12 + e] = new GridTransformMatrix(trList[6 + e]).leftMultiplyBy(Z120);
                    this.data.addGridTransform(trList[12 + e]);
                }
                if (this.getNumberOfPieces() == 2) {
                    for (e = 0; e < 6; ++e) {
                        trList[18 + e] = new GridTransformMatrix(trList[12 + e]).leftMultiplyBy(Z120);
                        this.data.addGridTransform(trList[18 + e]);
                    }
                }
            }
        }
    }

    public static double paramRescaleEnd(double x) {
        double y = Math.sin(1.5707963267948966 * x);
        return y;
    }

    public static double paramRescaleStart(double x) {
        double y = 1.0 - Math.cos(1.5707963267948966 * x);
        return y;
    }

    public static double paramRescaleBoth(double x) {
        double y = (1.0 - Math.cos(1.5707963267948966 * x)) / 2.0;
        return y;
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double deps = 4.8828125E-4;
        double ph = 0.0;
        double r = 0.0;
        if (u <= 0.6666666666666666) {
            r = this.gbranch * SchwarzHsurface.paramRescaleBoth(3.0 * u);
        } else if (u <= 1.0) {
            r = this.gbranch + (1.0 - this.gbranch) * SchwarzHsurface.paramRescaleStart(3.0 * u - 2.0);
        }
        ph = 2.0943951023931953 * SchwarzHsurface.paramRescaleBoth(v);
        if (Math.abs(u - 0.6666666666666666) < deps) {
            if (v <= 2.0 * deps) {
                ph = 2.0943951023931953 * SchwarzHsurface.paramRescaleBoth(deps - 0.5 * (deps - v));
            } else if (2.0 - v <= 2.0 * deps) {
                ph = 2.0943951023931953 * SchwarzHsurface.paramRescaleBoth(2.0 - deps + 0.5 * (deps - (2.0 - v)));
            }
        }
        Complex z = new Complex(r * Math.cos(ph), r * Math.sin(ph));
        if (this.wantsToSeeGaussImage) {
            z = this.mu(z);
        }
        return z;
    }

    @Override
    protected Complex gauss(Complex z) {
        return new Complex(z);
    }

    protected Complex mu(Complex z) {
        Complex z3 = new Complex(z.integerPower(3));
        Complex w3 = z3.inverse();
        Complex m2 = z3.plus(w3);
        m2.re = -m2.re + this.a3;
        m2.im = -m2.im;
        m2.assignInvert();
        Complex m = m2.squareRootNearer(ONE_C);
        return m;
    }

    @Override
    protected Complex hPrime(Complex z) {
        Complex w = this.mu(z);
        w.assignDivide(z);
        w.assignTimes(this.scale);
        return w;
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.gbranch = this.aa.getValue();
        this.a3 = this.gbranch * this.gbranch * this.gbranch;
        this.a3 += 1.0 / this.a3;
        this.scale = Math.sqrt(0.5 / this.gbranch);
    }

    @Override
    protected ComplexVector3D getCenter() {
        double fac = 0.5 / Math.sin(0.2617993877991494);
        Complex rot = new Complex(fac * Math.cos(1.3089969389957472), fac * Math.sin(1.3089969389957472));
        ComplexVector3D MS0 = new ComplexVector3D(this.helperToMinimal(this.helperArray[0][0]));
        ComplexVector3D MSE = new ComplexVector3D(this.helperToMinimal(this.helperArray[0][(int)Math.floor(this.vcount / 2)]));
        ComplexVector3D base30 = MSE.minus(MS0);
        base30.assignTimes(rot);
        base30.assignPlus(MS0);
        base30.z.re = 0.0;
        ComplexVector3D gC = new ComplexVector3D(this.minimalToHelper(base30));
        if (this.flag0 && !this.inAssociateMorph) {
            double savedAFP = this.AFP;
            MS0 = new ComplexVector3D(this.helperToMinimal(this.helperArray[(int)Math.floor((double)this.ucount * 2.0 / 3.0)][0]));
            MSE = new ComplexVector3D(this.helperToMinimal(this.helperArray[(int)Math.floor((double)this.ucount * 2.0 / 3.0)][this.vcount - 1]));
            this.AFP = 0.0;
            this.surf_1 = this.surfacePoint(0.5, 0.0);
            Vector3D aux = this.surfacePoint(0.75, 0.0);
            this.surf_1.y = aux.y;
            this.AFP = 1.5707963267948966;
            aux = this.surfacePoint(0.75, 0.0);
            MS0.x.re = this.surf_1.x;
            MS0.y.re = this.surf_1.y;
            MS0.z.re = this.surf_1.z;
            MS0.z.im = aux.z;
            this.helperArray[(int)Math.floor((double)((double)this.ucount * 2.0 / 3.0))][0] = this.minimalToHelper(MS0);
            this.surf_1.assignMinus(base30.re());
            this.surf_1.z = 0.0;
            this.surf_2 = new Vector3D(0.5 * Math.sqrt(3.0) * this.surf_1.y, 0.5 * this.surf_1.y, 0.0);
            MSE.x.re = this.surf_2.x + base30.x.re;
            MSE.y.re = this.surf_2.y + base30.y.re;
            MSE.z.re = this.surf_2.z;
            MSE.z.im = -aux.z;
            this.helperArray[(int)Math.floor((double)((double)this.ucount * 2.0 / 3.0))][this.vcount - 1] = this.minimalToHelper(MSE);
            this.trans = this.surf_1.plus(this.surf_2).times(0.6666666666666666);
            base30.x.re += this.trans.x;
            base30.y.re += this.trans.y;
            base30.z.re += this.trans.z;
            gC = this.minimalToHelper(base30);
            this.AFP = savedAFP;
        }
        return gC;
    }

    public void computePeriodData() {
        ComplexVector3D MC = this.helperToMinimal(this.getCenter());
        this.surf_1 = this.surfacePoint(0.5, 0.0);
        this.surf_1.assignMinus(MC.re());
        this.transY = new Vector3D(2.0 * this.surf_1.x, 0.0, 0.0);
        this.surf_3 = this.surfacePoint(1.0, 1.0);
        this.surf_3.assignMinus(MC.re());
        this.transZ = new Vector3D(0.0, 0.0, 2.0 * this.surf_3.z);
        this.surf_1 = this.surfacePoint(0.6666666666666666, 0.0);
        this.surf_1.assignTimes(2.0);
        this.norm_3 = this.surfaceNormal(1.0, 1.0);
        double sc = this.norm_3.dot(this.surf_3);
        this.trans = new Vector3D(this.surf_3.x - sc * this.norm_3.x, this.surf_3.y - sc * this.norm_3.y, this.surf_3.z - sc * this.norm_3.z);
        this.trans.assignTimes(2.0);
        double c120 = Math.cos(2.0943951023931953);
        double s120 = Math.sin(2.0943951023931953);
        this.Msym = GridTransformMatrix.SetGridTransformMatrix(c120, s120, 0.0, this.trans.x, s120, -c120, 0.0, this.trans.y, 0.0, 0.0, -1.0, this.trans.z, true);
    }
}

