/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import java.awt.Color;
import vmm3d.core.Complex;
import vmm3d.core.Parameter;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.View;
import vmm3d.core3D.ComplexVector3D;
import vmm3d.core3D.GridTransformMatrix;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.WeierstrassMinimalSurface;

public class Riemann
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm3d.surface.parametric.Riemann.aa", 1.0, -2.0, 2.0);
    private int jP;
    private int um;
    private int vm;
    private double P;
    private double PL;
    private double r1;

    public Riemann() {
        this.addParameter(this.aa);
        this.setDefaultOrientation(0);
        this.setDefaultViewpoint(new Vector3D(50.0, -20.0, 1.0));
        this.setDefaultViewUp(new Vector3D(0.3, 0.85, 0.5));
        this.setDefaultWindow(-7.0, 7.7, -5.8, 6.3);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(24);
        this.umin.reset(0.0);
        this.umax.reset(Math.PI);
        this.vmax.reset(3.0);
        this.vmin.reset(-this.vmax.getValue());
        this.removeParameter(this.vmin);
        this.removeParameter(this.umax);
        this.removeParameter(this.umin);
        this.multipleCopyOptions = new int[]{2, 3};
        this.canShowConjugateSurface = true;
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
    }

    @Override
    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView view = new WeierstrassMinimalSurface.WMSView(this);
        view.setGridSpacing(12);
        float c0 = 0.34f;
        view.getLightSettings().setLight0(new Color(c0, c0, c0));
        view.getLightSettings().getDirectionalLight2().setItsColor(new Color(0.5f, 1.0f, 0.0f));
        view.getLightSettings().getDirectionalLight2().setItsDirection(new Vector3D(0.66, -0.34, -0.66));
        view.getLightSettings().getDirectionalLight3().setItsDirection(new Vector3D(0.57, 0.2, -0.8));
        view.getLightSettings().setSpecularExponent(55);
        view.getLightSettings().setSpecularRatio(0.5f);
        return view;
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        if (param == this.vmax) {
            this.vmin.reset(-this.vmax.getValue());
        }
    }

    @Override
    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] trList = new GridTransformMatrix[12];
        trList[0] = new GridTransformMatrix();
        if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
            int e;
            trList[1] = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).setReverseSurfaceOrientation(true);
            this.data.addGridTransform(trList[1]);
            trList[2] = new GridTransformMatrix().scale(1.0, -1.0, 1.0);
            this.data.addGridTransform(trList[2]);
            trList[3] = new GridTransformMatrix().scale(-1.0, -1.0, -1.0).setReverseSurfaceOrientation(true);
            this.data.addGridTransform(trList[3]);
            if (this.getNumberOfPieces() == 2 || this.getNumberOfPieces() == 3) {
                for (e = 0; e < 4; ++e) {
                    if (this.flag0) {
                        trList[e + 4] = new GridTransformMatrix(trList[e]).translate(2.0 * this.halfPeriod.x.re, 0.0, 2.0 * this.halfPeriod.z.re);
                    } else if (this.flag05) {
                        trList[e + 4] = new GridTransformMatrix(trList[e]).translate(2.0 * this.halfPeriod.x.im, 0.0, 2.0 * this.halfPeriod.z.im);
                    }
                    this.data.addGridTransform(trList[e + 4]);
                }
            }
            if (this.getNumberOfPieces() == 3) {
                for (e = 0; e < 4; ++e) {
                    if (this.flag0) {
                        trList[e + 8] = new GridTransformMatrix(trList[e]).translate(-2.0 * this.halfPeriod.x.re, 0.0, -2.0 * this.halfPeriod.z.re);
                    } else if (this.flag05) {
                        trList[e + 8] = new GridTransformMatrix(trList[e]).translate(-2.0 * this.halfPeriod.x.im, 0.0, -2.0 * this.halfPeriod.z.im);
                    }
                    this.data.addGridTransform(trList[e + 8]);
                }
            }
        }
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double deps = 0.03125;
        double r = Math.exp(v);
        double ph = u;
        if (u < this.umin.getValue() + deps && Math.abs(v - this.PL) < deps) {
            ph = u + (deps - Math.abs(v - this.PL)) * ((-u + deps + this.umin.getValue()) / deps);
        } else if (u > this.umax.getValue() - deps && Math.abs(v + this.PL) < deps) {
            ph = u - (deps - Math.abs(v + this.PL)) * ((u + deps - this.umax.getValue()) / deps);
        }
        Complex z = new Complex(r * Math.cos(ph), r * Math.sin(ph));
        if (this.wantsToSeeGaussImage) {
            z = this.hPrime(z);
        }
        return z;
    }

    protected void p_Index() {
        this.jP = (int)Math.floor((this.PL - this.vmin.getValue()) / (this.vmax.getValue() - this.vmin.getValue()) * (double)(this.vcount - 1));
    }

    @Override
    protected Complex gauss(Complex z) {
        return new Complex(z);
    }

    @Override
    protected Complex hPrime(Complex z) {
        double denom = z.re * z.re + z.im * z.im;
        Complex w1 = new Complex(z.re / denom - z.re + this.P - 1.0 / this.P, -z.im * (1.0 / denom + 1.0));
        Complex w = w1.squareRootNearer(I2_C);
        w.assignTimes(z);
        w.assignInvert();
        w.assignTimes(this.r1);
        return w;
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.PL = this.aa.getValue();
        this.P = Math.exp(this.PL);
        this.r1 = 0.5;
        this.p_Index();
        this.um = (int)Math.floor((double)(this.ucount - 1) / 2.0);
        this.vm = (int)Math.floor((double)(this.vcount - 1) / 2.0);
    }

    @Override
    protected ComplexVector3D getCenter() {
        if (this.inAssociateMorph) {
            return new ComplexVector3D(this.helperArray[this.um][this.vm]);
        }
        if (this.wantsToSeeDomain) {
            return new ComplexVector3D(this.helperArray[0][0].plus(this.helperArray[this.ucount - 1][0]).times(0.5));
        }
        ComplexVector3D Mearly = new ComplexVector3D(this.helperToMinimal(this.helperArray[0][this.jP + 19]));
        ComplexVector3D Mlate = new ComplexVector3D(this.helperToMinimal(this.helperArray[0][this.jP - 19]));
        Vector3D MinEarlyRE = new Vector3D(Mearly.re());
        Vector3D MinEarlyIM = new Vector3D(Mearly.im());
        Vector3D MinLateRE = new Vector3D(Mlate.re());
        Vector3D MinLateIM = new Vector3D(Mlate.im());
        Vector3D MinBranchRE = new Vector3D(MinEarlyRE.x, MinLateRE.y, MinEarlyRE.z);
        Vector3D MinBranchIM = new Vector3D(MinLateIM.x, MinEarlyIM.y, MinLateIM.z);
        ComplexVector3D gC = new ComplexVector3D(MinBranchRE, MinBranchIM);
        gC = this.minimalToHelper(gC);
        return gC;
    }

    @Override
    public void computeHalfPeriod() {
        this.halfPeriod = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.um][this.vm].times(2.0)));
        this.halfPeriod.y = ZERO_C;
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        ComplexVector3D eW;
        int i = (int)Math.floor(0.25 + (u - this.umin.getValue()) / this.du);
        int j = (int)Math.floor(0.25 + (v - this.vmin.getValue()) / this.dv);
        if (!this.inAssociateMorph && !this.wantsToSeeDomain && i == 0 && j == this.jP) {
            eW = new ComplexVector3D(ComplexVector3D.ORIGIN);
        } else if (!this.inAssociateMorph && !this.wantsToSeeDomain && i == this.ucount - 1 && j == this.vcount - 1 - this.jP) {
            eW = new ComplexVector3D(this.halfPeriod);
        } else {
            ComplexVector3D auxW = new ComplexVector3D(this.helperArray[i][j].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)i * this.du, this.vmin.getValue() + (double)j * this.dv), this.domainGrid(u, v))));
            eW = this.helperToMinimal(auxW);
            if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
                if (this.flag0) {
                    if (i == 0 && j <= this.jP || i == this.ucount - 1 && j >= this.vcount - 1 - this.jP) {
                        eW.y.assign(ZERO_C);
                    }
                    if (i == 0 && j > this.jP) {
                        eW.assign(ZERO_C, eW.y, ZERO_C);
                    }
                    if (i == this.ucount - 1 && j < this.vcount - 1 - this.jP) {
                        eW.assign(this.halfPeriod.x, eW.y, this.halfPeriod.z);
                    }
                }
                if (this.flag05) {
                    if (i == 0 && j > this.jP || i == this.ucount - 1 && j < this.vcount - 1 - this.jP) {
                        eW.y.assign(ZERO_C);
                    }
                    if (i == 0 && j < this.jP) {
                        eW.assign(ZERO_C, eW.y, ZERO_C);
                    }
                }
            }
        }
        if (this.AFP == 0.0) {
            if (this.wantsToSeeDomain) {
                return new Vector3D(eW.z.re, eW.z.im, 0.0);
            }
            return eW.re();
        }
        return eW.re().times(Math.cos(this.AFP)).plus(eW.im().times(Math.sin(this.AFP)));
    }
}

