/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.core.BasicAnimator;
import vmm3d.core.Complex;
import vmm3d.core.I18n;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.View;
import vmm3d.core3D.ComplexVector3D;
import vmm3d.core3D.GridTransformMatrix;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.WeierstrassMinimalSurface;

public class LopezRosNoGo
extends WeierstrassMinimalSurface {
    private RealParamAnimateable pos = new RealParamAnimateable("vmm3d.surface.parametric.LopezRosNoGo.pos", 3.0, 7.0, 1.01);
    private RealParamAnimateable lrp = new RealParamAnimateable("vmm3d.surface.parametric.LopezRosNoGo.lrp", 1.06, 1.0, 1.0);
    boolean in2ndMorph = false;
    private double LRP;
    private double POS;
    private double r1;
    private Complex q1;

    public LopezRosNoGo() {
        this.setFramesForMorphing(20);
        this.afp.reset(0.0, 0.0, 0.0);
        this.addParameter(this.pos);
        this.pos.setMinimumValueForInput(0.1);
        this.pos.setMaximumValueForInput(10.0);
        this.addParameter(this.lrp);
        this.setDefaultViewpoint(new Vector3D(25.0, 50.0, 50.0));
        this.setDefaultViewpoint(new Vector3D(-62.0, -40.0, 10.0));
        this.setDefaultWindow(-4.0, 4.0, -3.0, 3.0);
        this.uPatchCount.setValueAndDefault(24);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-1.7, -1.7, -1.7);
        this.umax.reset(2.0, 2.6, 1.6);
        this.vmin.reset(-0.9999);
        this.vmax.reset(0.9999);
        this.removeParameter(this.vmax);
        this.removeParameter(this.vmin);
        this.wantsToSeeDomain = false;
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.canShowConjugateSurface = false;
    }

    @Override
    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        GridTransformMatrix tr = new GridTransformMatrix();
        if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
            if (this.flag0) {
                tr = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).reverse();
            } else if (this.flag05) {
                // empty if block
            }
            this.data.addGridTransform(tr);
        }
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double r = Math.exp(u * Math.abs(u));
        double a = Math.PI * Math.sin(v * Math.PI / 2.0);
        Complex z = new Complex(r * Math.cos(a) + 1.0, r * Math.sin(a));
        Complex w = z.squareRootNearer(ONE_C);
        return w.times(this.POS);
    }

    protected double closingLRP(double p) {
        return 1.0 / Math.sqrt((3.0 * p * p - 2.0) * p * p - 1.0);
    }

    @Override
    protected Complex gauss(Complex z) {
        Complex w = z.times(z);
        w.re = this.LRP * (w.re - 1.0);
        w.im = this.LRP * w.im;
        return w;
    }

    @Override
    protected Complex hPrime(Complex z) {
        Complex w = z.times(z);
        w.re = this.r1 * (w.re - this.POS * this.POS);
        w.im = this.r1 * w.im;
        w.assignTimes(w);
        return this.gauss(z).dividedBy(w);
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.POS = this.pos.getValue() / 10.0;
        this.POS = Math.exp(this.POS * this.POS);
        this.r1 = Math.sqrt(8.0 / this.pos.getValue());
        double lrploc = this.closingLRP(this.POS);
        this.LRP = this.lrp.getValue();
        if (!this.in2ndMorph) {
            this.LRP = lrploc;
        } else {
            this.r1 = this.r1 * Math.sqrt(this.pos.getValue() / 3.5) * 1.1;
        }
    }

    @Override
    protected ComplexVector3D getCenter() {
        if (this.inAssociateMorph || this.wantsToSeeDomain) {
            int um = (int)Math.floor((double)(this.ucount - 1) / 2.0);
            int vm = (int)Math.floor((double)(this.vcount - 1) / 2.0);
            return new ComplexVector3D(this.helperArray[um][vm]);
        }
        ComplexVector3D gC = new ComplexVector3D(this.helperArray[this.ucount - 1][this.vcount - 1]);
        return gC.plus(this.helperArray[this.ucount - 1][0]).times(0.5);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        int i = (int)Math.floor(0.25 + (u - this.umin.getValue()) / this.du);
        int j = (int)Math.floor(0.25 + (v - this.vmin.getValue()) / this.dv);
        Complex z = this.domainGrid(u, v);
        ComplexVector3D auxW = new ComplexVector3D(this.helperArray[i][j].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)i * this.du, this.vmin.getValue() + (double)j * this.dv), z)));
        ComplexVector3D eW = this.helperToMinimal(auxW);
        if (z.r() < 1.01 * this.distFrom0 && !this.inAssociateMorph && !this.wantsToSeeDomain) {
            eW.x = new Complex(ZERO_C);
            eW.z = new Complex(ZERO_C);
            eW.y = new Complex(this.helperArray[0][j].y.plus(this.helperArray[0][j].x).times(I_C));
        }
        if (this.wantsToSeeDomain) {
            return new Vector3D(eW.z.re, eW.z.im, 0.0);
        }
        if (this.AFP == 0.0) {
            return eW.re();
        }
        return eW.re().times(Math.cos(this.AFP)).plus(eW.im().times(Math.sin(this.AFP)));
    }

    @Override
    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actions = super.getAdditionalAnimationsForView(view);
        actions.add(new AbstractActionVMM(I18n.tr("vmm3d.surface.parametric.LopezRosNoGo.PeriodOpenMorph")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicAnimator animation = new BasicAnimator();
                animation.setLooping(2);
                animation.setUseFilmstrip(LopezRosNoGo.this.getUseFilmstripForMorphing());
                animation.setFrames(LopezRosNoGo.this.getFramesForMorphing());
                animation.setMillisecondsPerFrame(200);
                animation.addWithCustomLimits(LopezRosNoGo.this.pos, 3.5, 1.0);
                animation.addWithCustomValue(LopezRosNoGo.this.lrp, 1.05);
                animation.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent evt) {
                        LopezRosNoGo.this.in2ndMorph = ((BasicAnimator)evt.getSource()).isRunning();
                    }
                });
                view.getDisplay().installAnimation(animation);
            }
        });
        return actions;
    }
}

