/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.core.BasicAnimator;
import vmm3d.core.I18n;
import vmm3d.core.Parameter;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.View;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.SurfaceParametric;

public class Hyperboloid1
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "1.0", "1.0", "0.5");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", "1.0", "1.0", "1.8");
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", "1.0", "1.0", "1.0");
    private RealParamAnimateable dd = new RealParamAnimateable("genericParam.dd", "1.0", "0.5", "2.0");
    private boolean in2ndMorph = false;
    private double AA = this.aa.getValue();
    private double BB = this.bb.getValue();
    private double CC = this.cc.getValue();
    private double DD = this.dd.getValue();

    public Hyperboloid1() {
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset("-2");
        this.umax.reset("2");
        this.vmin.reset("0");
        this.vmax.reset("2 pi");
        this.setDefaultViewpoint(new Vector3D(30.0, 20.0, 10.0));
        this.setDefaultWindow(-5.5, 5.5, -5.5, 5.5);
        this.addParameter(this.dd);
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        this.AA = this.aa.getValue();
        this.BB = this.bb.getValue();
        this.CC = this.cc.getValue();
        this.DD = this.dd.getValue();
    }

    @Override
    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actions = super.getAdditionalAnimationsForView(view);
        actions.add(new AbstractActionVMM(I18n.tr("vmm3d.surface.parametric.Hyperboloid1.Ruling")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicAnimator animation = new BasicAnimator();
                animation.setLooping(2);
                animation.setUseFilmstrip(Hyperboloid1.this.getUseFilmstripForMorphing());
                animation.setFrames(Hyperboloid1.this.getFramesForMorphing());
                animation.setMillisecondsPerFrame(200);
                animation.addWithCustomLimits(Hyperboloid1.this.dd, 0.5, 2.0);
                animation.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent evt) {
                        if (((BasicAnimator)evt.getSource()).isRunning()) {
                            Hyperboloid1.this.in2ndMorph = true;
                        } else {
                            Hyperboloid1.this.in2ndMorph = false;
                        }
                    }
                });
                view.getDisplay().installAnimation(animation);
            }
        });
        return actions;
    }

    private static double sinh(double t) {
        return 0.5 * (Math.exp(t) - Math.exp(-t));
    }

    private static double cosh(double t) {
        return 0.5 * (Math.exp(t) + Math.exp(-t));
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (!this.in2ndMorph) {
            x = this.AA * Hyperboloid1.cosh(u) * Math.cos(v);
            y = this.BB * Hyperboloid1.cosh(u) * Math.sin(v);
            z = this.CC * Hyperboloid1.sinh(u);
        } else {
            double uu = u * Math.PI / 2.0;
            double vv = v - (this.vmax.getValue() + this.vmin.getValue()) / 2.0;
            z = this.AA * (Math.cos(uu) - vv * Math.sin(uu));
            y = this.BB * (Math.sin(uu) + vv * Math.cos(uu));
            x = this.DD * this.CC * vv;
        }
        return new Vector3D(x, y, z);
    }
}

