/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.SurfaceParametric;

public class HyperbolicParaboloid
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "1.0", "1.0", "0.5");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", "2.0", "1.0", "1.8");
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", "1.0", "1.0", "1.0");

    public HyperbolicParaboloid() {
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset("-2.5");
        this.umax.reset("2.5");
        this.vmin.reset("-2.5");
        this.vmax.reset("2.5");
        this.setDefaultViewpoint(new Vector3D(29.0, 16.0, 20.0));
        this.setDefaultWindow(-8.0, 8.0, -8.0, 8.0);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.addParameter(this.cc);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double BB = this.bb.getValue();
        double CC = this.cc.getValue();
        double x = AA * u;
        double y = BB * v;
        double z = CC * u * v;
        return new Vector3D(x, y, z);
    }
}

