/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import vmm3d.core.Animation;
import vmm3d.core.BasicAnimator;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.View;
import vmm3d.core3D.Vector3D;
import vmm3d.core3D.View3DLit;
import vmm3d.surface.parametric.SurfaceParametric;

public class DiracBelt
extends SurfaceParametric {
    private RealParamAnimateable t = new RealParamAnimateable("vmm3d.surface.parametric.DiracBelt.t", 0.0, 0.0, 3.14159);

    @Override
    public View getDefaultView() {
        View3DLit view = new View3DLit();
        view.setRenderingStyle(0);
        view.setViewStyle(1);
        return view;
    }

    @Override
    public Animation getCreateAnimation(View view) {
        BasicAnimator theAnimation = this.getMorphingAnimation(view, 1);
        theAnimation.setMillisecondsPerFrame(200);
        return theAnimation;
    }

    public DiracBelt() {
        this.uPatchCount.setValueAndDefault(6);
        this.vPatchCount.setValueAndDefault(36);
        this.umin.reset(-0.5);
        this.umax.reset(0.5);
        this.vmin.reset(0.0);
        this.vmax.reset(6.0);
        this.addParameter(this.t);
        this.setDefaultWindow(-4.25, 4.25, -4.25, 4.25);
        this.setDefaultViewpoint(new Vector3D(-1.0, -7.8, 1.6));
        this.setFramesForMorphing(36);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double tt = this.t.getValue();
        double sinhalfv = Math.sin(v / 2.0);
        double sinv = Math.sin(v);
        double sin2v = Math.sin(2.0 * v);
        double cosv = Math.cos(v);
        double cos2v = Math.cos(2.0 * v);
        double cost = Math.cos(tt);
        double sint = Math.sin(tt);
        double sin2t = Math.sin(2.0 * tt);
        double sin4t = Math.sin(4.0 * tt);
        double cos2t = Math.cos(2.0 * tt);
        double cos4t = Math.cos(4.0 * tt);
        double x = 0.5 * (v - 8.0 * u * cost * (1.0 + 2.0 * cost * cost * cosv) * sint * sinhalfv * sinhalfv + cos4t * (v - sinv) + sinv) - 2.0;
        double y = -cosv * sin2t + u * cost * cost * sin2v;
        double z = u * (-cos2t * sint * sint + cost * cost * (cos2t * cos2v + 4.0 * cosv * sint * sint)) + 0.5 * sin4t * (-v + sinv);
        return new Vector3D(x, y, z);
    }
}

