/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.SurfaceParametric;

public class DiniSurface
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 0.35, 0.2, 0.5);

    public DiniSurface() {
        this.uPatchCount.setValueAndDefault(20);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-4.0);
        this.umax.reset(4.0);
        this.vmin.reset("-pi");
        this.vmax.reset("pi");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-1.75, 1.75, -1.75, 1.75);
        this.addParameter(this.aa);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double psi = Math.PI * Math.min(0.999, Math.max(AA, 0.001));
        double sinpsi = Math.sin(psi);
        double cospsi = Math.cos(psi);
        double g = (u - cospsi * v) / sinpsi;
        double s = Math.exp(g);
        double r = 2.0 * sinpsi / (s + 1.0 / s);
        double t = r * (s - 1.0 / s) * 0.5;
        double x = u - t;
        double y = r * Math.cos(v);
        double z = r * Math.sin(v);
        return new Vector3D(x, y, z);
    }
}

