/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.core.BasicAnimator;
import vmm3d.core.I18n;
import vmm3d.core.Parameter;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.View;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.SurfaceParametric;

public class ConstCurvOneHelicoids
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm3d.surface.parametric.ConstCurvOneHelicoids.aa", "1.2", "1.2", "1.2");
    private RealParamAnimateable hh = new RealParamAnimateable("vmm3d.surface.parametric.ConstCurvOneHelicoids.hh", "0.2", "0", "0.7");
    double AA = this.aa.getValue();
    double HH = this.hh.getValue() / Math.max(1.0, Math.abs(this.hh.getValue() / this.AA));
    boolean needsNewArray = true;
    boolean in2ndMorph = false;
    double r0 = this.helRad(0.0);
    double DU;
    int tr;
    Vector3D startPoint = new Vector3D(this.r0, 0.0, 0.0);
    Vector3D[] TransversCurve;

    public ConstCurvOneHelicoids() {
        this.addParameter(this.hh);
        this.addParameter(this.aa);
        this.uPatchCount.setValueAndDefault(10);
        this.vPatchCount.setValueAndDefault(30);
        this.tr = 1 + this.uPatchCount.getValue() * 6;
        this.umax.reset(this.findUmax());
        this.umin.reset(-this.umax.getValue());
        this.DU = (this.umax.getValue() - this.umin.getValue()) / (double)(this.tr - 1);
        this.vmin.reset("0");
        this.vmax.reset(Math.PI * 2);
        this.setDefaultViewpoint(new Vector3D(10.0, -20.0, 10.0));
        this.setDefaultWindow(-0.8, 4.0, -1.8, 1.5);
        this.setDefaultOrientation(0);
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        this.needsNewArray = true;
    }

    @Override
    protected void createData() {
        if (this.needsNewArray) {
            this.redoConstantsAndArray();
        }
        super.createData();
    }

    public void redoConstantsAndArray() {
        this.AA = this.aa.getValue();
        this.HH = this.hh.getValue() / Math.max(1.0, Math.abs(this.hh.getValue() / this.AA));
        this.umax.reset(this.findUmax());
        this.umin.reset(-this.umax.getValue());
        this.r0 = this.helRad(0.0);
        if (this.in2ndMorph) {
            this.vmax.reset(Math.PI * 2 / this.r0);
        } else {
            this.vmax.reset(Math.PI * 2);
        }
        this.tr = 1 + this.uPatchCount.getValue() * 6;
        this.DU = (this.umax.getValue() - this.umin.getValue()) / (double)(this.tr - 1);
        this.startPoint = new Vector3D(this.r0, 0.0, 0.0);
        this.TransversCurve = new Vector3D[this.tr];
        this.createCurveArray();
    }

    private double findUmax() {
        double a2 = this.AA * this.AA;
        double aux = (a2 - 1.0) / (2.0 * a2);
        double w = Math.sqrt(Math.abs(Math.sqrt(this.HH * this.HH / a2 / a2 + aux * aux) + aux));
        double result = this.in2ndMorph ? Math.min(0.5, Math.acos(w)) : Math.acos(w);
        return result;
    }

    private double helRad(double u) {
        double result = 0.0;
        double aux = this.AA * this.AA * Math.cos(u) * Math.cos(u) - this.HH * this.HH;
        if (aux > 0.0) {
            result = Math.sqrt(aux);
        }
        return result;
    }

    private double dHelRad(double u) {
        double result = 0.0;
        double aux = 2.0 * this.helRad(u);
        if (aux > 0.0) {
            result = -this.AA * this.AA * Math.sin(2.0 * u) / aux;
        }
        return result;
    }

    private Vector3D nRadial(double x, double y) {
        double r = Math.sqrt(x * x + y * y);
        Vector3D result = new Vector3D(0.0, 0.0, 0.0);
        if (r > 0.0) {
            result = new Vector3D(x / r, y / r, 0.0);
        }
        return result;
    }

    private Vector3D nZylinder(double x, double y) {
        double r = x * x + y * y;
        double RR = Math.sqrt(r + this.HH * this.HH);
        Vector3D result = new Vector3D(0.0, 0.0, 0.0);
        if (RR > 0.0) {
            r = Math.sqrt(r);
            double f = this.HH / (r * RR);
            result = new Vector3D(y * f, -x * f, r / RR);
        }
        return result;
    }

    @Override
    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actions = super.getAdditionalAnimationsForView(view);
        actions.add(new AbstractActionVMM(I18n.tr("vmm3d.surface.parametric.ConstCurvOneHelicoids.IsometricMorph")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicAnimator animation = new BasicAnimator();
                animation.setLooping(2);
                animation.setUseFilmstrip(ConstCurvOneHelicoids.this.getUseFilmstripForMorphing());
                animation.setFrames(ConstCurvOneHelicoids.this.getFramesForMorphing());
                animation.setMillisecondsPerFrame(200);
                double ra = 0.4;
                double re = 1.5;
                ConstCurvOneHelicoids.this.HH = 0.2;
                ConstCurvOneHelicoids.this.AA = re;
                double rr = ConstCurvOneHelicoids.this.findUmax();
                animation.addWithCustomValue(ConstCurvOneHelicoids.this.hh, ConstCurvOneHelicoids.this.HH);
                animation.addWithCustomLimits(ConstCurvOneHelicoids.this.aa, ra, re);
                animation.addWithCustomValue(ConstCurvOneHelicoids.this.uPatchCount, 6);
                animation.addWithCustomValue(ConstCurvOneHelicoids.this.vPatchCount, 36);
                animation.addWithCustomValue(ConstCurvOneHelicoids.this.umin, -rr);
                animation.addWithCustomValue(ConstCurvOneHelicoids.this.umax, rr);
                animation.addWithCustomValue(ConstCurvOneHelicoids.this.vmin, 0.0);
                animation.addWithCustomValue(ConstCurvOneHelicoids.this.vmax, Math.PI);
                animation.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent evt) {
                        ConstCurvOneHelicoids.this.in2ndMorph = ((BasicAnimator)evt.getSource()).isRunning();
                    }
                });
                view.getDisplay().installAnimation(animation);
            }
        });
        return actions;
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        Vector3D Q = new Vector3D();
        int iu = (int)Math.round((u - this.umin.getValue()) / this.DU);
        double uATi = this.umin.getValue() + this.DU * (double)iu;
        Q = u == uATi ? this.TransversCurve[iu] : this.midpointODEstep(uATi, u, this.TransversCurve[iu], 8);
        double x = Q.x * Math.cos(v) - Q.y * Math.sin(v);
        double y = Q.x * Math.sin(v) + Q.y * Math.cos(v);
        double z = Q.z + this.HH * v;
        return new Vector3D(z, -y, x);
    }

    protected Vector3D midpointODEstep(double tInitial, double tFinal, Vector3D initialVal, int numSubdivision) {
        double t = tInitial;
        int newSub = (int)Math.round(1.0 + Math.abs(tFinal - tInitial)) * numSubdivision;
        double dt = (tFinal - tInitial) / (double)newSub;
        Vector3D P = new Vector3D(initialVal);
        for (int j = 0; j < newSub; ++j) {
            double aux = this.dHelRad(t);
            Vector3D T = this.nRadial(P.x, P.y);
            T = T.linComb(aux, Math.sqrt(1.0 - aux * aux), this.nZylinder(P.x, P.y));
            Vector3D midP = P.plus(T.times(dt / 2.0));
            aux = this.dHelRad(t += dt / 2.0);
            Vector3D midT = this.nRadial(midP.x, midP.y);
            midT = midT.linComb(aux, Math.sqrt(1.0 - aux * aux), this.nZylinder(midP.x, midP.y));
            P = P.plus(midT.times(dt));
            t += dt / 2.0;
        }
        return new Vector3D(P);
    }

    private void createCurveArray() {
        double t0 = this.umin.getValue();
        this.TransversCurve[0] = this.midpointODEstep(0.0, t0, this.startPoint, 32);
        for (int i = 1; i < this.tr; ++i) {
            double t = t0 + (double)(i - 1) * this.DU;
            this.TransversCurve[i] = this.midpointODEstep(t, t + this.DU, this.TransversCurve[i - 1], 8);
        }
        this.needsNewArray = false;
    }
}

