/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.core.BasicAnimator;
import vmm3d.core.I18n;
import vmm3d.core.Parameter;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.View;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.SurfaceParametric;

public class ConstCurvFamilyOfRevolution
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm3d.surface.parametric.ConstCurvFamilyOfRevolution.aa", "0.7", "0.5", "1.5");
    boolean needsNewRange = true;
    boolean in2ndMorph = false;
    double AA = this.aa.getValue();

    public ConstCurvFamilyOfRevolution() {
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.vmin.reset("0");
        this.vmax.reset(Math.PI * 2);
        this.umin.reset("-1.57");
        this.umax.reset("1.57");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-1.5, 1.5, -1.5, 1.5);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        this.needsNewRange = true;
    }

    @Override
    protected void createData() {
        this.AA = this.aa.getValue();
        if (this.needsNewRange && !this.in2ndMorph) {
            this.redoConstants();
        }
        super.createData();
    }

    public void redoConstants() {
        double r1 = Math.asin(Math.min(1.0, 1.0 / this.AA));
        this.umax.reset(Math.min(r1 - 1.0E-5, 1.5707963267948966));
        this.umin.reset(-this.umax.getValue());
        this.needsNewRange = false;
    }

    @Override
    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actions = super.getAdditionalAnimationsForView(view);
        actions.add(new AbstractActionVMM(I18n.tr("vmm3d.surface.parametric.ConstCurvFamilyOfRevolution.IsometricMorph")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicAnimator animation = new BasicAnimator();
                animation.setLooping(2);
                animation.setUseFilmstrip(ConstCurvFamilyOfRevolution.this.getUseFilmstripForMorphing());
                animation.setFrames(ConstCurvFamilyOfRevolution.this.getFramesForMorphing());
                animation.setMillisecondsPerFrame(200);
                double ra = 0.5;
                double re = 1.5;
                double rr = Math.min(Math.asin(Math.min(1.0, 1.0 / re)) - 1.0E-6, 1.5707963267948966);
                animation.addWithCustomLimits(ConstCurvFamilyOfRevolution.this.aa, ra, re);
                animation.addWithCustomValue(ConstCurvFamilyOfRevolution.this.uPatchCount, 10);
                animation.addWithCustomValue(ConstCurvFamilyOfRevolution.this.vPatchCount, 20);
                animation.addWithCustomValue(ConstCurvFamilyOfRevolution.this.umin, -rr);
                animation.addWithCustomValue(ConstCurvFamilyOfRevolution.this.umax, rr);
                animation.addWithCustomLimits(ConstCurvFamilyOfRevolution.this.vmin, 0.0, 0.0);
                animation.addWithCustomLimits(ConstCurvFamilyOfRevolution.this.vmax, Math.PI, Math.PI);
                animation.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent evt) {
                        ConstCurvFamilyOfRevolution.this.in2ndMorph = ((BasicAnimator)evt.getSource()).isRunning();
                    }
                });
                view.getDisplay().installAnimation(animation);
            }
        });
        return actions;
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double y;
        double x;
        if (this.in2ndMorph) {
            x = this.AA * Math.cos(u) * Math.cos(v / this.AA);
            y = this.AA * Math.cos(u) * Math.sin(v / this.AA);
        } else {
            x = this.AA * Math.cos(u) * Math.cos(v);
            y = this.AA * Math.cos(u) * Math.sin(v);
        }
        double z = this.height(u);
        return new Vector3D(x, y, z);
    }

    private double integrand(double s) {
        return Math.sqrt(1.0 - this.AA * this.AA * Math.sin(s) * Math.sin(s));
    }

    private double height(double v) {
        long num = 2L * Math.round(2.0 + 8.0 * Math.abs(v));
        double w = 0.0;
        double y = this.integrand(0.0);
        if (v != 0.0) {
            double dv = v / (double)num;
            int i = 1;
            while ((long)i < num) {
                y = this.integrand((double)i * dv);
                w += 4.0 * y;
                y = this.integrand((double)(i + 1) * dv);
                w += 2.0 * y;
                i += 2;
            }
            w = (w - y) * dv / 3.0;
        }
        return w;
    }
}

