/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.SurfaceParametric;

public class Catalan
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "0", "0", "pi / 2");

    public Catalan() {
        this.uPatchCount.setValueAndDefault(20);
        this.vPatchCount.setValueAndDefault(20);
        this.umin.reset(0.0);
        this.umax.reset("4 * pi");
        this.vmin.reset(-2.0);
        this.vmax.reset(2.0);
        this.setDefaultViewpoint(new Vector3D(3.0, -12.0, 12.0));
        this.setDefaultWindow(-10.0, 10.0, -10.0, 10.0);
        this.addParameter(this.aa);
    }

    private static double sinh(double t) {
        return 0.5 * (Math.exp(t) - Math.exp(-t));
    }

    private static double cosh(double t) {
        return 0.5 * (Math.exp(t) + Math.exp(-t));
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double PI = Math.PI;
        double x = Math.cos(AA * PI) * (u - Math.sin(u) * Catalan.cosh(v)) + Math.sin(AA * PI) * (v - Math.cos(u) * Catalan.sinh(v)) - 4.0;
        double y = Math.cos(AA * PI) * (1.0 - Math.cos(u) * Catalan.cosh(v)) + Math.sin(AA * PI) * Math.sin(u) * Catalan.sinh(v);
        double z = Math.cos(AA * PI) * 4.0 * Math.sin(u / 2.0) * Catalan.sinh(v / 2.0) + Math.sin(AA * PI) * 4.0 * (Math.cos(u / 2.0) * Catalan.cosh(v / 2.0) - 1.0);
        return new Vector3D(x, y, z);
    }
}

