/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.implicit;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.implicit.SurfaceImplicit;

public class Pretzel
extends SurfaceImplicit {
    private RealParamAnimateable a = new RealParamAnimateable("vmm3d.surface.implicit.Pretzel.a", 0.475, 0.475, 0.475);
    private RealParamAnimateable b = new RealParamAnimateable("vmm3d.surface.implicit.Pretzel.b", 3.0, 3.0, 3.0);
    private RealParamAnimateable c = new RealParamAnimateable("vmm3d.surface.implicit.Pretzel.c", 1.5, 1.5, 1.5);
    private RealParamAnimateable d = new RealParamAnimateable("vmm3d.surface.implicit.Pretzel.d", 0.2, 0.1, 0.5);

    public static double sqr(double x) {
        return x * x;
    }

    @Override
    public double heightFunction(double x, double y, double z) {
        double dd = this.d.getValue();
        double cc = this.c.getValue();
        double bb = this.b.getValue();
        double aa = this.a.getValue();
        double xsqr = Pretzel.sqr(x);
        double ysqr = Pretzel.sqr(y);
        double zsqr = Pretzel.sqr(z);
        double height = Pretzel.sqr((Pretzel.sqr(x - aa) + ysqr - 1.0) * (Pretzel.sqr(x + aa) + ysqr - 1.0)) + (cc * zsqr - Pretzel.sqr(dd)) * (1.0 + bb * Pretzel.sqr(xsqr + ysqr));
        return height;
    }

    public Pretzel() {
        this.addParameter(this.d);
        this.addParameter(this.c);
        this.addParameter(this.b);
        this.addParameter(this.a);
        this.setDefaultWindow(-1.25, 1.25, -1.25, 1.25);
        this.setDefaultViewpoint(new Vector3D(2.0, 18.0, 10.0));
        this.searchRadius.reset(3.0);
        this.randomLineCount.reset(60000);
        this.pointCloudCount.reset(12000);
        this.level.reset(0.0, 0.0, 0.0);
        this.setFramesForMorphing(11);
    }
}

