/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.implicit;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.implicit.SurfaceImplicit;

public class KummerQuartic
extends SurfaceImplicit {
    private RealParamAnimateable a = new RealParamAnimateable("vmm3d.surface.implicit.KummerQuartic.a", 1.3, 1.0, 1.5);

    public static double sqr(double x) {
        return x * x;
    }

    @Override
    public double heightFunction(double x, double y, double z) {
        double aa = this.a.getValue();
        double xsqr = KummerQuartic.sqr(x);
        double ysqr = KummerQuartic.sqr(y);
        double zsqr = KummerQuartic.sqr(z);
        double lambda = (3.0 * KummerQuartic.sqr(aa) - 1.0) / (3.0 - KummerQuartic.sqr(aa));
        double w2 = Math.sqrt(2.0);
        double pp = 1.0 - z - w2 * x;
        double qq = 1.0 - z + w2 * x;
        double rr = 1.0 + z + w2 * y;
        double ss = 1.0 + z - w2 * y;
        double height = KummerQuartic.sqr(xsqr + ysqr + zsqr - KummerQuartic.sqr(aa)) - lambda * pp * qq * rr * ss;
        return height;
    }

    public KummerQuartic() {
        this.addParameter(this.a);
        this.setDefaultWindow(-3.25, 3.25, -3.25, 3.25);
        this.setDefaultViewpoint(new Vector3D(-9.92, 9.1, -11.65));
        this.setDefaultViewUp(new Vector3D(-0.52, 0.39, 0.75));
        this.searchRadius.reset(3.0);
        this.randomLineCount.reset(60000);
        this.pointCloudCount.reset(24000);
        this.level.reset(0.0, 0.05, 0.1);
        this.setFramesForMorphing(12);
        this.heightFunctionType = SurfaceImplicit.equationType.QUARTIC;
    }
}

