/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.implicit;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.implicit.SurfaceImplicit;

public class ImplicitEllipsoid
extends SurfaceImplicit {
    private RealParamAnimateable xSemiAxis = new RealParamAnimateable("vmm3d.surface.implicit.Ellipsoid.xSemiaxis", 1.0, 1.0, 1.5);
    private RealParamAnimateable ySemiAxis = new RealParamAnimateable("vmm3d.surface.implicit.Ellipsoid.ySemiaxis", 1.75, 1.75, 1.0);
    private RealParamAnimateable zSemiAxis = new RealParamAnimateable("vmm3d.surface.implicit.Ellipsoid.zSemiaxis", 1.25, 1.25, 1.75);

    public static double sqr(double x) {
        return x * x;
    }

    @Override
    public double heightFunction(double x, double y, double z) {
        double a = this.xSemiAxis.getValue();
        double b = this.ySemiAxis.getValue();
        double c = this.zSemiAxis.getValue();
        double height = ImplicitEllipsoid.sqr(x / a) + ImplicitEllipsoid.sqr(y / b) + ImplicitEllipsoid.sqr(z / c);
        return height;
    }

    public ImplicitEllipsoid() {
        this.addParameter(this.zSemiAxis);
        this.addParameter(this.ySemiAxis);
        this.addParameter(this.xSemiAxis);
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.searchRadius.reset(3.0);
        this.level.reset(1.0);
        this.pointCloudCount.reset(12000);
        this.heightFunctionType = SurfaceImplicit.equationType.QUADRATIC;
    }
}

