/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.implicit;

import vmm3d.core3D.Vector3D;
import vmm3d.surface.implicit.SurfaceImplicit;

public class BarthSextic
extends SurfaceImplicit {
    public static double sqr(double x) {
        return x * x;
    }

    @Override
    public double heightFunction(double x, double y, double z) {
        double xsqr = BarthSextic.sqr(x);
        double ysqr = BarthSextic.sqr(y);
        double zsqr = BarthSextic.sqr(z);
        double height = -(4.0 * (2.618 * xsqr - ysqr) * (2.618 * ysqr - zsqr) * (2.618 * zsqr - xsqr) - 4.236 * BarthSextic.sqr(xsqr + ysqr + zsqr - 1.0));
        return height;
    }

    public BarthSextic() {
        this.setDefaultWindow(-3.0, 3.0, -3.0, 3.0);
        this.setDefaultViewpoint(new Vector3D(3.4, -13.0, 9.8));
        this.searchRadius.reset(3.0);
        this.randomLineCount.reset(80000);
        this.rayTraceResolution.reset(0.005);
        this.resolution = this.rayTraceResolution.getValue();
        this.pointCloudCount.reset(18000);
        this.level.reset(0.0, 0.05, 0.1);
        this.setFramesForMorphing(12);
    }
}

