/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.spacecurve.parametric;

import vmm3d.core.UserExhibit;
import vmm3d.core.VariableParamAnimateable;
import vmm3d.core3D.UserExhibit3D;
import vmm3d.core3D.Vector3D;
import vmm3d.spacecurve.parametric.SpaceCurveParametric;

public class UserSpaceCurveParametric
extends SpaceCurveParametric
implements UserExhibit3D {
    private UserExhibit3D.Support userExhibitSupport;
    private UserExhibit.FunctionInfo xOfT;
    private UserExhibit.FunctionInfo yOfT;
    private UserExhibit.FunctionInfo zOfT;

    public UserSpaceCurveParametric() {
        this.tmin.reset(-1.0);
        this.tmax.reset(1.0);
        this.tResolution.reset(300);
        this.tubeSize.reset(0.2);
        this.userExhibitSupport = new UserExhibit3D.Support(this);
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("a", 2.0, 1.3, 2.2));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("b", 3.0, 2.3, 3.2));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("c", 0.1, 0.0, 0.3));
        this.xOfT = this.userExhibitSupport.addRealFunction("x", "(a + c*cos(7*t)) * sin(5*pi*t)", "t");
        this.yOfT = this.userExhibitSupport.addRealFunction("y", "(a + c*cos(7*t)) * cos(5*pi*t)", "t");
        this.zOfT = this.userExhibitSupport.addRealFunction("z", "b*sin(7*pi*t)", "t");
    }

    @Override
    protected Vector3D value(double t) {
        double[] arg = new double[]{t};
        double x = this.xOfT.realFunctionValue(arg);
        double y = this.yOfT.realFunctionValue(arg);
        double z = this.zOfT.realFunctionValue(arg);
        if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z)) {
            return null;
        }
        return new Vector3D(x, y, z);
    }

    @Override
    public UserExhibit.Support getUserExhibitSupport() {
        return this.userExhibitSupport;
    }
}

