/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.spacecurve.parametric;

import java.awt.Color;
import java.awt.event.ActionEvent;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.actions.ToggleAction;
import vmm3d.core.Animation;
import vmm3d.core.Decoration;
import vmm3d.core.Display;
import vmm3d.core.I18n;
import vmm3d.core.IntegerParam;
import vmm3d.core.RealParam;
import vmm3d.core.TimerAnimation;
import vmm3d.core.Transform;
import vmm3d.core.VMMSave;
import vmm3d.core.View;
import vmm3d.core3D.Grid3D;
import vmm3d.core3D.Transform3D;
import vmm3d.core3D.Vector3D;
import vmm3d.core3D.View3D;
import vmm3d.core3D.View3DLit;
import vmm3d.spacecurve.SpaceCurve;
import vmm3d.spacecurve.SpaceCurveView;
import vmm3d.spacecurve.parametric.RepereMobileDecoration;

public abstract class SpaceCurveParametric
extends SpaceCurve {
    protected IntegerParam tResolution;
    protected RealParam tmin = new RealParam("vmm.spacecurve.parametric.SpaceCurveParameteric.tmin", -5.0);
    protected RealParam tmax = new RealParam("vmm.spacecurve.parametric.SpaceCurveParameteric.tmax", 5.0);
    protected double[] tVals;
    protected Grid3D tube;
    protected RealParam tubeSize;
    protected IntegerParam tubeSides;

    public SpaceCurveParametric() {
        this.tResolution = new IntegerParam("vmm.spacecurve.parametric.SpaceCurveParameteric.tResolution", 200);
        this.tResolution.setMinimumValueForInput(4);
        this.tResolution.setMaximumValueForInput(2000);
        this.tubeSize = new RealParam("vmm.spacecurve.parametric.SpaceCurveParameteric.TubeSize", 0.25);
        this.tubeSize.setMinimumValueForInput(0.01);
        this.tubeSides = new IntegerParam("vmm.spacecurve.parametric.SpaceCurveParametric.TubeSides", 4);
        this.tubeSides.setMinimumValueForInput(3);
        this.tubeSides.setMaximumValueForInput(20);
        this.addParameter(this.tubeSides);
        this.addParameter(this.tubeSize);
        this.addParameter(this.tResolution);
        this.addParameter(this.tmax);
        this.addParameter(this.tmin);
        this.setFramesForMorphing(25);
        this.setUseFilmstripForMorphing(true);
    }

    @Override
    protected void makePoints() {
        int subintervals = this.tResolution.getValue();
        this.tVals = new double[subintervals + 1];
        this.points = new Vector3D[subintervals + 1];
        double t = this.tmin.getValue();
        double dt = (this.tmax.getValue() - t) / (double)subintervals;
        for (int i = 0; i <= subintervals; ++i) {
            this.tVals[i] = t + dt * (double)i;
            this.points[i] = this.value(this.tVals[i]);
            if (!Double.isNaN(this.points[i].x) && !Double.isInfinite(this.points[i].x) && !Double.isNaN(this.points[i].y) && !Double.isInfinite(this.points[i].y) && !Double.isNaN(this.points[i].z) && !Double.isInfinite(this.points[i].z)) continue;
            this.points[i] = null;
        }
    }

    protected Vector3D getCenterOfPoints(Vector3D[] pointSet, int numPoints) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (int i = 0; i < numPoints; ++i) {
            x += pointSet[i].x;
            y += pointSet[i].y;
            z += pointSet[i].z;
        }
        return new Vector3D(x / (double)numPoints, y / (double)numPoints, z / (double)numPoints);
    }

    protected abstract Vector3D value(double var1);

    protected Vector3D deriv1(double t) {
        double dx = 5.0E-5;
        Vector3D f1 = this.value(t + dx);
        Vector3D f2 = this.value(t + 2.0 * dx);
        Vector3D g1 = this.value(t - dx);
        Vector3D g2 = this.value(t - 2.0 * dx);
        f1.x = (8.0 * f1.x + g2.x - (f2.x + 8.0 * g1.x)) / (12.0 * dx);
        f1.y = (8.0 * f1.y + g2.y - (f2.y + 8.0 * g1.y)) / (12.0 * dx);
        f1.z = (8.0 * f1.z + g2.z - (f2.z + 8.0 * g1.z)) / (12.0 * dx);
        if (f1 == null || f2 == null || g1 == null || g2 == null) {
            return null;
        }
        return f1;
    }

    protected Vector3D deriv2(double t) {
        double dx = 5.0E-5;
        Vector3D f0 = this.value(t);
        Vector3D f1 = this.value(t + dx);
        Vector3D f2 = this.value(t + 2.0 * dx);
        Vector3D g1 = this.value(t - dx);
        Vector3D g2 = this.value(t - 2.0 * dx);
        if (f0 == null || f1 == null || f2 == null || g1 == null || g2 == null) {
            return null;
        }
        f0.x = (16.0 * f1.x + 16.0 * g1.x - 30.0 * f0.x - f2.x - g2.x) / (12.0 * dx * dx);
        f0.y = (16.0 * f1.y + 16.0 * g1.y - 30.0 * f0.y - f2.y - g2.y) / (12.0 * dx * dx);
        f0.z = (16.0 * f1.z + 16.0 * g1.z - 30.0 * f0.z - f2.z - g2.z) / (12.0 * dx * dx);
        return f0;
    }

    public Vector3D geographicCoordinates(double theta, double phi) {
        double x = Math.sin(theta) * Math.cos(phi);
        double y = Math.sin(theta) * Math.sin(phi);
        double z = Math.cos(theta);
        return new Vector3D(x, y, z);
    }

    public double getT(int index) {
        return this.tVals[index];
    }

    public int getTResolution() {
        return this.tResolution.getValue();
    }

    public Vector3D[] makeRepereMobile(double t) {
        Vector3D point = this.value(t);
        Vector3D deriv = this.deriv1(t);
        Vector3D deriv2 = this.deriv2(t);
        if (point == null || deriv == null || deriv2 == null) {
            return null;
        }
        Vector3D B = deriv.cross(deriv2);
        deriv.normalize();
        B.normalize();
        Vector3D N = B.cross(deriv);
        if (Double.isNaN(N.x) || Double.isInfinite(N.y) || Double.isNaN(N.y) || Double.isInfinite(N.y) || Double.isNaN(N.z) || Double.isInfinite(N.z)) {
            return null;
        }
        return new Vector3D[]{point, deriv, N, B};
    }

    @Override
    public View getDefaultView() {
        SpaceCurveParametricView view = new SpaceCurveParametricView();
        view.setName("vmm.spacecurve.parametric.SpaceCurveParametric.view.ViewAsCurve");
        return view;
    }

    @Override
    public View[] getAlternativeViews() {
        SpaceCurveParametricViewAsTube view = new SpaceCurveParametricViewAsTube();
        view.setAntialiased(true);
        view.setName("vmm.spacecurve.parametric.SpaceCurveParametric.view.ViewAsTube");
        return new View[]{view};
    }

    @Override
    public ActionList getActionsForView(final View view) {
        ActionList commands = super.getActionsForView(view);
        if (view instanceof SpaceCurveParametricView) {
            commands.add(null);
            commands.add(new AbstractActionVMM(I18n.tr("vmm.spacecurve.parametric.SpaceCurveParameteric.showRepereMobile")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Display display = view.getDisplay();
                    display.installAnimation(new TimerAnimation(SpaceCurveParametric.this.getTResolution(), 40){
                        RepereMobileDecoration dec;
                        {
                            this.dec = new RepereMobileDecoration();
                        }

                        @Override
                        protected void animationEnding() {
                            view.removeDecoration(this.dec);
                        }

                        @Override
                        protected void animationStarting() {
                            this.dec.setCurve(SpaceCurveParametric.this);
                            view.addDecoration(this.dec);
                        }

                        @Override
                        protected void drawFrame() {
                            this.dec.setIndex(this.getFrameNumber());
                        }
                    });
                }
            });
            commands.add(((SpaceCurveParametricView)view).showOsculatingCirclesAction);
            commands.add(((SpaceCurveParametricView)view).showEvoluteToggle);
        } else if (view instanceof SpaceCurveParametricViewAsTube) {
            commands.add(null);
            commands.add(((SpaceCurveParametricViewAsTube)view).showGridToggle);
        }
        return commands;
    }

    @Override
    public Animation getCreateAnimation(final View view) {
        if (view == null || !(view instanceof SpaceCurveParametricView)) {
            return null;
        }
        return new TimerAnimation(75, 20){

            @Override
            protected void drawFrame() {
                ((SpaceCurveParametricView)view).fractionToDraw = (double)this.frameNumber / 75.0;
                view.forceRedraw();
            }

            @Override
            public void animationStarting() {
                ((SpaceCurveParametricView)view).fractionToDraw = 0.0;
            }

            @Override
            public void animationEnding() {
                ((SpaceCurveParametricView)view).fractionToDraw = 1.0;
                view.forceRedraw();
            }
        };
    }

    @Override
    public Animation getBuildAnimation(View view) {
        if (!(view instanceof View3DLit)) {
            return null;
        }
        if (((View3DLit)view).getRenderingStyle() == 0) {
            return null;
        }
        final View3DLit view3D = (View3DLit)view;
        return new TimerAnimation(0, 20){
            private double percentDrawn;
            private double batchSize;
            {
                super(frames, millisecondsPerFrame);
                this.batchSize = 0.0201;
            }

            @Override
            protected void drawFrame() {
                if (this.percentDrawn > 1.0) {
                    this.cancel();
                    return;
                }
                if (!view3D.beginDrawToOffscreenImage()) {
                    return;
                }
                view3D.drawSurface(SpaceCurveParametric.this.tube, this.percentDrawn, this.percentDrawn + this.batchSize);
                view3D.endDrawToOffscreenImage();
                view3D.getDisplay().repaint();
                this.percentDrawn += this.batchSize;
            }
        };
    }

    @Override
    protected void computeDrawData3D(View3D view, boolean exhibitNeedsRedraw, Transform3D previousTransform, Transform3D newTransform) {
        super.computeDrawData3D(view, exhibitNeedsRedraw, previousTransform, newTransform);
        if (this.tube == null || exhibitNeedsRedraw) {
            int uPatches = this.tResolution.getValue();
            int vPatches = this.tubeSides.getValue();
            if (this.tube == null || this.tube.getUPatchCount() != uPatches || this.tube.getVPatchCount() != vPatches) {
                this.tube = new Grid3D(uPatches, vPatches, 1);
            }
            for (int i = 0; i <= uPatches; ++i) {
                Vector3D[] rm = this.makeRepereMobile(this.tVals[i]);
                if (rm == null) {
                    for (int j = 0; j <= vPatches; ++j) {
                        this.tube.setVertex(i, j, null);
                    }
                    continue;
                }
                Vector3D N = rm[2];
                Vector3D B = rm[3];
                N = N.times(this.tubeSize.getValue() / 2.0);
                B = B.times(this.tubeSize.getValue() / 2.0);
                for (int j = 0; j <= vPatches; ++j) {
                    double angle = (double)(j * 2) * Math.PI / (double)vPatches;
                    Vector3D v = rm[0].plus(N.times(Math.cos(angle))).plus(B.times(Math.sin(angle)));
                    this.tube.setVertex(i, j, v);
                }
            }
        }
        boolean showGrid = true;
        if (view instanceof SpaceCurveParametricViewAsTube) {
            showGrid = ((SpaceCurveParametricViewAsTube)view).getShowGrid();
        }
        this.tube.setUCurveIncrement(showGrid ? 1 : 0);
        this.tube.setVCurveIncrement(showGrid ? 1 : 0);
    }

    @Override
    protected void doDraw3D(VectorGraphics g, View3D view, Transform3D transform) {
        if (view instanceof View3DLit) {
            ((View3DLit)view).drawSurface(this.tube);
        } else {
            if (this.points.length == 0) {
                return;
            }
            int pointCt = this.points.length;
            if (view instanceof SpaceCurveParametricView) {
                double fraction = ((SpaceCurveParametricView)view).fractionToDraw;
                if (fraction >= 0.0 && fraction < 1.0) {
                    pointCt = (int)(fraction * (double)pointCt);
                }
                if (pointCt == 0) {
                    pointCt = 1;
                }
            }
            boolean useReverseCollar = false;
            if (view instanceof SpaceCurveView) {
                useReverseCollar = ((SpaceCurveView)view).getUseReverseCollar();
            }
            view.drawCollaredCurve(this.points, pointCt, useReverseCollar);
        }
    }

    private class EvoluteDecoration
    extends Decoration {
        private final int POINTS_ON_CIRCLE = 180;
        private Vector3D[] evolutePoints;
        private boolean showCompleteEvolute = true;
        private int circleIndex;
        private final Color COLOR = Color.BLUE;

        private EvoluteDecoration() {
        }

        @Override
        public void computeDrawData(View view, boolean exhibitNeedsRedraw, Transform previousTransform, Transform newTransform) {
            if (exhibitNeedsRedraw || this.decorationNeedsRedraw) {
                int pts;
                int curvePointCount = SpaceCurveParametric.this.getPointCount();
                if (curvePointCount == 0) {
                    this.evolutePoints = null;
                    return;
                }
                this.evolutePoints = new Vector3D[curvePointCount];
                if (this.showCompleteEvolute) {
                    pts = curvePointCount;
                } else {
                    pts = this.circleIndex;
                    if (pts > curvePointCount) {
                        pts = curvePointCount;
                    }
                }
                for (int i = 0; i < pts; ++i) {
                    this.evolutePoints[i] = this.centerOfOsculatingCircle(i);
                }
            }
        }

        @Override
        public void doDraw(VectorGraphics g, View view, Transform transform) {
            if (this.evolutePoints == null) {
                return;
            }
            View3D v3 = (View3D)view;
            Color saveColor = view.getColor();
            view.setColor(v3.getViewStyle() == 1 ? Color.LIGHT_GRAY : this.COLOR);
            if (this.showCompleteEvolute) {
                view.setStrokeSizeMultiplier(2);
                v3.drawCurve(this.evolutePoints);
                view.setStrokeSizeMultiplier(1);
            } else {
                if (this.circleIndex >= 0 && this.circleIndex < this.evolutePoints.length) {
                    this.evolutePoints[this.circleIndex] = this.drawOsculatingCircle(v3);
                }
                if (this.circleIndex > 0) {
                    view.setStrokeSizeMultiplier(2);
                    v3.drawCurve(this.evolutePoints, this.circleIndex + 1);
                    view.setStrokeSizeMultiplier(1);
                }
            }
            view.setColor(saveColor);
        }

        private Vector3D drawOsculatingCircle(View3D view) {
            double t = SpaceCurveParametric.this.getT(this.circleIndex);
            Vector3D pt = SpaceCurveParametric.this.value(t);
            Vector3D deriv = SpaceCurveParametric.this.deriv1(t);
            Vector3D deriv2 = SpaceCurveParametric.this.deriv2(t);
            if (pt == null || deriv == null || deriv2 == null) {
                return null;
            }
            double kappa = deriv.cross(deriv2).norm() / Math.pow(deriv.norm(), 3.0);
            double radius = 1.0 / kappa;
            if (Double.isNaN(radius) || radius > 10000.0) {
                return null;
            }
            Vector3D B = deriv.cross(deriv2);
            deriv.normalize();
            B.normalize();
            Vector3D N = B.cross(deriv);
            if (Double.isNaN(N.x) || Double.isInfinite(N.y) || Double.isNaN(N.y) || Double.isInfinite(N.y) || Double.isNaN(N.z) || Double.isInfinite(N.z)) {
                return null;
            }
            N.normalize();
            Vector3D v1 = N.times(radius);
            Vector3D v2 = deriv.times(radius);
            Vector3D center = pt.plus(v1);
            v1.negate();
            Vector3D pt1 = center.plus(v1);
            for (int i = 1; i <= 180; ++i) {
                double angle = Math.PI * 2 * (double)i / 180.0;
                Vector3D pt2 = center.plus(v1.times(Math.cos(angle))).plus(v2.times(Math.sin(angle)));
                view.drawLine(pt1, pt2);
                pt1 = pt2;
            }
            view.drawLine(center, pt);
            return center;
        }

        private Vector3D centerOfOsculatingCircle(int index) {
            double t = SpaceCurveParametric.this.getT(index);
            Vector3D pt = SpaceCurveParametric.this.value(t);
            Vector3D deriv = SpaceCurveParametric.this.deriv1(t);
            Vector3D deriv2 = SpaceCurveParametric.this.deriv2(t);
            if (pt == null || deriv == null || deriv2 == null) {
                return null;
            }
            double kappa = deriv.cross(deriv2).norm() / Math.pow(deriv.norm(), 3.0);
            double radius = 1.0 / kappa;
            if (Double.isNaN(radius) || radius > 10000.0) {
                return null;
            }
            Vector3D B = deriv.cross(deriv2);
            deriv.normalize();
            B.normalize();
            Vector3D N = B.cross(deriv);
            N.normalize();
            if (Double.isNaN(N.x) || Double.isInfinite(N.y) || Double.isNaN(N.y) || Double.isInfinite(N.y) || Double.isNaN(N.z) || Double.isInfinite(N.z)) {
                return null;
            }
            Vector3D center = pt.plus(N.times(radius));
            return center;
        }
    }

    public static class SpaceCurveParametricViewAsTube
    extends View3DLit {
        private ToggleAction showGridToggle = new ToggleAction(I18n.tr("vmm.spacecurve.parametric.SpaceCurveParametric.ShowTubeGrid"), true){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpaceCurveParametricViewAsTube.this.setShowGrid(this.getState());
            }
        };
        @VMMSave
        private boolean showGrid = true;

        public boolean getShowGrid() {
            return this.showGrid;
        }

        public void setShowGrid(boolean showGrid) {
            if (showGrid == this.showGrid) {
                return;
            }
            this.showGrid = showGrid;
            this.showGridToggle.setState(showGrid);
            this.forceRedraw();
        }
    }

    public class SpaceCurveParametricView
    extends SpaceCurveView {
        double fractionToDraw = -1.0;
        @VMMSave
        private boolean showEvolute;
        EvoluteDecoration evolute;
        ToggleAction showEvoluteToggle = new ToggleAction(I18n.tr("vmm.spacecurve.parametric.SpaceCurveParametric.ShowEvolute")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpaceCurveParametricView.this.setShowEvolute(this.getState());
            }
        };
        AbstractActionVMM showOsculatingCirclesAction = new AbstractActionVMM(I18n.tr("vmm.spacecurve.parametric.SpaceCurveParametric.ShowOsculatingCircles")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpaceCurveParametricView.this.getDisplay().installAnimation(new TimerAnimation(){

                    @Override
                    protected void drawFrame() {
                        if (SpaceCurveParametricView.this.evolute == null) {
                            this.cancel();
                        } else {
                            SpaceCurveParametricView.this.evolute.circleIndex++;
                            if (SpaceCurveParametricView.this.evolute.circleIndex >= SpaceCurveParametric.this.getPointCount()) {
                                this.cancel();
                            } else {
                                SpaceCurveParametricView.this.forceRedraw();
                            }
                        }
                    }

                    @Override
                    protected void animationEnding() {
                        SpaceCurveParametricView.this.evolute.showCompleteEvolute = true;
                        SpaceCurveParametricView.this.forceRedraw();
                    }

                    @Override
                    protected void animationStarting() {
                        if (!SpaceCurveParametricView.this.showEvolute) {
                            SpaceCurveParametricView.this.evolute = new EvoluteDecoration();
                        }
                        SpaceCurveParametricView.this.evolute.showCompleteEvolute = false;
                        SpaceCurveParametricView.this.evolute.showCompleteEvolute = false;
                        SpaceCurveParametricView.this.evolute.circleIndex = 0;
                        SpaceCurveParametricView.this.setShowEvolute(true);
                        SpaceCurveParametricView.this.forceRedraw();
                    }
                });
            }
        };

        public SpaceCurveParametricView() {
            this.setAntialiased(true);
        }

        public boolean getShowEvolute() {
            return this.showEvolute;
        }

        public void setShowEvolute(boolean showEvolute) {
            if (this.showEvolute == showEvolute) {
                return;
            }
            this.showEvolute = showEvolute;
            this.showEvoluteToggle.setState(showEvolute);
            if (showEvolute) {
                if (this.evolute == null) {
                    this.evolute = new EvoluteDecoration();
                }
                this.addDecoration(this.evolute);
            } else {
                this.removeDecoration(this.evolute);
                this.evolute = null;
            }
        }
    }
}

