/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.polyhedron;

import java.awt.event.ActionEvent;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.core.I18n;
import vmm3d.core.TimerAnimation;
import vmm3d.core.View;
import vmm3d.core3D.Vector3D;
import vmm3d.polyhedron.RegularPolyhedron;

public class Icosahedron
extends RegularPolyhedron {
    public Icosahedron() {
        double t = (Math.sqrt(5.0) - 1.0) / 2.0;
        this.polyhedronVertices = new Vector3D[]{new Vector3D(-1.0, -t, 0.0), new Vector3D(0.0, 1.0, t), new Vector3D(0.0, 1.0, -t), new Vector3D(1.0, t, 0.0), new Vector3D(1.0, -t, 0.0), new Vector3D(0.0, -1.0, -t), new Vector3D(0.0, -1.0, t), new Vector3D(t, 0.0, 1.0), new Vector3D(-t, 0.0, 1.0), new Vector3D(t, 0.0, -1.0), new Vector3D(-t, 0.0, -1.0), new Vector3D(-1.0, t, 0.0)};
        this.polyhedronFaces = new int[][]{{3, 7, 1}, {4, 7, 3}, {6, 7, 4}, {8, 7, 6}, {7, 8, 1}, {9, 4, 3}, {2, 9, 3}, {2, 3, 1}, {11, 2, 1}, {10, 2, 11}, {10, 9, 2}, {9, 5, 4}, {6, 4, 5}, {0, 6, 5}, {0, 11, 8}, {11, 1, 8}, {10, 0, 5}, {10, 5, 9}, {0, 8, 6}, {0, 10, 11}};
        this.setDefaultWindow(-1.3, 1.3, -1.3, 1.3);
        this.stellationScale = 0.45;
        this.stellationHeight = 1.8683447179254318;
    }

    @Override
    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actions = super.getAdditionalAnimationsForView(view);
        AbstractActionVMM showEdgeLengthMorph = new AbstractActionVMM(I18n.tr("vmm.polyhedron.Icosahedron.EdgeLengthMorphCommand")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                view.getDisplay().installAnimation(new EdgeLengthMorph());
            }
        };
        actions.add(showEdgeLengthMorph);
        return actions;
    }

    private class EdgeLengthMorph
    extends TimerAnimation {
        double saveTruncation;

        EdgeLengthMorph() {
            super(Icosahedron.this.getFramesForMorphing(), 50);
            this.setLooping(2);
        }

        @Override
        protected void animationStarting() {
            this.saveTruncation = Icosahedron.this.truncation.getValue();
            Icosahedron.this.truncation.setValue(1.0);
            Icosahedron.this.setStellationWanted(false);
            Icosahedron.this.useBackFaceFudge = true;
        }

        @Override
        protected void animationEnding() {
            this.setEdgeLength((Math.sqrt(5.0) - 1.0) / 2.0);
            Icosahedron.this.truncation.setValue(this.saveTruncation);
            Icosahedron.this.useBackFaceFudge = false;
        }

        @Override
        protected void drawFrame() {
            this.setEdgeLength((double)this.getFrameNumber() * ((Math.sqrt(5.0) - 1.0) / 2.0) / (double)this.getFrames());
        }

        void setEdgeLength(double EL) {
            Icosahedron.this.polyhedronVertices[1].z = EL;
            Icosahedron.this.polyhedronVertices[2].z = -EL;
            Icosahedron.this.polyhedronVertices[3].y = EL;
            Icosahedron.this.polyhedronVertices[4].y = -EL;
            Icosahedron.this.polyhedronVertices[5].z = -EL;
            Icosahedron.this.polyhedronVertices[6].z = EL;
            Icosahedron.this.polyhedronVertices[7].x = EL;
            Icosahedron.this.polyhedronVertices[8].x = -EL;
            Icosahedron.this.polyhedronVertices[9].x = EL;
            Icosahedron.this.polyhedronVertices[10].x = -EL;
            Icosahedron.this.polyhedronVertices[0].y = -EL;
            Icosahedron.this.polyhedronVertices[11].y = EL;
            Icosahedron.this.setIFSData(Icosahedron.this.polyhedronVertices, Icosahedron.this.polyhedronFaces);
            Icosahedron.this.forceRedraw();
        }
    }
}

