/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.polyhedron;

import java.awt.event.ActionEvent;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.core.I18n;
import vmm3d.core.TimerAnimation;
import vmm3d.core.View;
import vmm3d.core3D.Vector3D;
import vmm3d.polyhedron.RegularPolyhedron;

public class Dodecahedron
extends RegularPolyhedron {
    public Dodecahedron() {
        double t = (Math.sqrt(5.0) - 1.0) / 2.0;
        double t2 = 2.0 - 1.0 / t;
        this.polyhedronVertices = new Vector3D[]{new Vector3D(-1.0, 0.0, -t2), new Vector3D(t, t, t), new Vector3D(1.0, 0.0, t2), new Vector3D(t, -t, t), new Vector3D(0.0, -t2, 1.0), new Vector3D(0.0, t2, 1.0), new Vector3D(1.0, 0.0, -t2), new Vector3D(t, t, -t), new Vector3D(t2, 1.0, 0.0), new Vector3D(-t2, 1.0, 0.0), new Vector3D(-t, t, -t), new Vector3D(0.0, t2, -1.0), new Vector3D(t, -t, -t), new Vector3D(t2, -1.0, 0.0), new Vector3D(-t2, -1.0, 0.0), new Vector3D(-1.0, 0.0, t2), new Vector3D(-t, t, t), new Vector3D(-t, -t, -t), new Vector3D(0.0, -t2, -1.0), new Vector3D(-t, -t, t)};
        this.polyhedronFaces = new int[][]{{16, 9, 8, 1, 5}, {9, 10, 11, 7, 8}, {8, 7, 6, 2, 1}, {6, 12, 13, 3, 2}, {18, 17, 14, 13, 12}, {14, 19, 4, 3, 13}, {4, 5, 1, 2, 3}, {15, 16, 5, 4, 19}, {7, 11, 18, 12, 6}, {10, 0, 17, 18, 11}, {0, 10, 9, 16, 15}, {17, 0, 15, 19, 14}};
        this.setDefaultWindow(-1.3, 1.3, -1.3, 1.3);
        this.stellationScale = 0.65;
        this.stellationHeight = 1.0514622242382667;
    }

    @Override
    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actions = super.getAdditionalAnimationsForView(view);
        AbstractActionVMM showEdgeLengthMorph = new AbstractActionVMM(I18n.tr("vmm.polyhedron.Dodecahedron.EdgeLengthMorphCommand")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                view.getDisplay().installAnimation(new EdgeLengthMorph());
            }
        };
        actions.add(showEdgeLengthMorph);
        return actions;
    }

    private class EdgeLengthMorph
    extends TimerAnimation {
        double saveTruncation;

        EdgeLengthMorph() {
            super(Dodecahedron.this.getFramesForMorphing(), 50);
            this.setLooping(2);
        }

        @Override
        protected void animationStarting() {
            this.saveTruncation = Dodecahedron.this.truncation.getValue();
            Dodecahedron.this.truncation.setValue(1.0);
            Dodecahedron.this.setStellationWanted(false);
            Dodecahedron.this.useBackFaceFudge = true;
        }

        @Override
        protected void animationEnding() {
            this.setEdgeLength((Math.sqrt(5.0) - 1.0) / 2.0);
            Dodecahedron.this.truncation.setValue(this.saveTruncation);
            Dodecahedron.this.useBackFaceFudge = false;
        }

        @Override
        protected void drawFrame() {
            double g = (Math.sqrt(5.0) - 1.0) / 2.0;
            this.setEdgeLength(g + (double)this.getFrameNumber() * ((1.0 - g) / (double)this.getFrames()));
        }

        void setEdgeLength(double t) {
            double g = (Math.sqrt(5.0) - 1.0) / 2.0;
            double t2 = (2.0 - 1.0 / t) * g / t;
            double s = g / t;
            t = g;
            Dodecahedron.this.polyhedronVertices[0] = new Vector3D(-s, 0.0, -t2);
            Dodecahedron.this.polyhedronVertices[1] = new Vector3D(t, t, t);
            Dodecahedron.this.polyhedronVertices[2] = new Vector3D(s, 0.0, t2);
            Dodecahedron.this.polyhedronVertices[3] = new Vector3D(t, -t, t);
            Dodecahedron.this.polyhedronVertices[4] = new Vector3D(0.0, -t2, s);
            Dodecahedron.this.polyhedronVertices[5] = new Vector3D(0.0, t2, s);
            Dodecahedron.this.polyhedronVertices[6] = new Vector3D(s, 0.0, -t2);
            Dodecahedron.this.polyhedronVertices[7] = new Vector3D(t, t, -t);
            Dodecahedron.this.polyhedronVertices[8] = new Vector3D(t2, s, 0.0);
            Dodecahedron.this.polyhedronVertices[9] = new Vector3D(-t2, s, 0.0);
            Dodecahedron.this.polyhedronVertices[10] = new Vector3D(-t, t, -t);
            Dodecahedron.this.polyhedronVertices[11] = new Vector3D(0.0, t2, -s);
            Dodecahedron.this.polyhedronVertices[12] = new Vector3D(t, -t, -t);
            Dodecahedron.this.polyhedronVertices[13] = new Vector3D(t2, -s, 0.0);
            Dodecahedron.this.polyhedronVertices[14] = new Vector3D(-t2, -s, 0.0);
            Dodecahedron.this.polyhedronVertices[15] = new Vector3D(-s, 0.0, t2);
            Dodecahedron.this.polyhedronVertices[16] = new Vector3D(-t, t, t);
            Dodecahedron.this.polyhedronVertices[17] = new Vector3D(-t, -t, -t);
            Dodecahedron.this.polyhedronVertices[18] = new Vector3D(0.0, -t2, -s);
            Dodecahedron.this.polyhedronVertices[19] = new Vector3D(-t, -t, t);
            Dodecahedron.this.setIFSData(Dodecahedron.this.polyhedronVertices, Dodecahedron.this.polyhedronFaces);
            Dodecahedron.this.forceRedraw();
        }
    }
}

