/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve.parametric;

import vmm3d.core.UserExhibit;
import vmm3d.core.VariableParamAnimateable;
import vmm3d.planecurve.parametric.PlaneCurveParametric;

public class UserPlaneCurveParametricPolar
extends PlaneCurveParametric
implements UserExhibit {
    private UserExhibit.Support userExhibitSupport;
    private UserExhibit.FunctionInfo rho;
    private UserExhibit.FunctionInfo theta;

    public UserPlaneCurveParametricPolar() {
        this.tmin.reset(0.0);
        this.tmax.reset("2 * pi");
        this.tResolution.reset(250);
        this.userExhibitSupport = new UserExhibit.Support(this);
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("a", 1.5, 1.0, 2.0));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("b", 3.0, 1.0, 2.0));
        this.rho = this.userExhibitSupport.addRealFunction("rho", "a * cos(t)", "t");
        this.theta = this.userExhibitSupport.addRealFunction("theta", "b * t", "t");
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
    }

    @Override
    public double xValue(double t) {
        return this.rho.realFunctionValue(t) * Math.cos(this.theta.realFunctionValue(t));
    }

    @Override
    public double yValue(double t) {
        return this.rho.realFunctionValue(t) * Math.sin(this.theta.realFunctionValue(t));
    }

    @Override
    public UserExhibit.Support getUserExhibitSupport() {
        return this.userExhibitSupport;
    }
}

