/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve.parametric;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.Transform;
import vmm3d.core.View;
import vmm3d.planecurve.parametric.DecoratedCurve;

public class SineCurve
extends DecoratedCurve {
    private RealParamAnimateable amplitude = new RealParamAnimateable("vmm3d.planecurve.parametric.SineCurve.amplitude", 1.0, 0.5, 2.0);
    private RealParamAnimateable frequency = new RealParamAnimateable("vmm3d.planecurve.parametric.SineCurve.frequency", 2.0, 1.0, 1.0);
    private RealParamAnimateable phase = new RealParamAnimateable("vmm3d.planecurve.parametric.SineCurve.phase", 0.0, 0.0, 0.0);

    public SineCurve() {
        this.phase.setMinimumValueForInput(0.0);
        this.phase.setMaximumValueForInput(Math.PI * 2);
        this.frequency.setMinimumValueForInput(Double.MIN_VALUE);
        this.addParameter(this.phase);
        this.addParameter(this.frequency);
        this.addParameter(this.amplitude);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("3*pi");
        this.tResolution.setValueAndDefaultFromString("300");
        this.setDefaultWindow(-2.5, 10.0, -2.0, 2.0);
    }

    @Override
    public double xValue(double t) {
        return t;
    }

    @Override
    public double yValue(double t) {
        double a = this.amplitude.getValue();
        double f = this.frequency.getValue();
        double p = this.phase.getValue();
        return a * Math.sin(f * (t - p));
    }

    @Override
    protected void drawNeededStuff(VectorGraphics g, View view, Transform limits, double t) {
        double a = this.amplitude.getValue();
        double f = this.frequency.getValue();
        double p = this.phase.getValue();
        Color saveColor = g.getColor();
        g.setColor(Color.blue);
        double angle = f * t - Math.PI * 2 * Math.floor(t * f / 2.0 / Math.PI);
        Point2D[] circPts = this.myCircle(-a, 0.0, a, 120);
        view.drawCurve(circPts, 0, 120);
        double x = this.xValue(t);
        double y = this.yValue(t);
        view.setStrokeSizeMultiplier(2);
        g.setColor(Color.red);
        g.draw((Shape)new Line2D.Double(-a, 0.0, a * Math.cos(f * (t - p)) - a, a * Math.sin(f * (t - p))));
        if (a == 1.0) {
            view.drawCurve(circPts, 0, (int)Math.floor(120.0 * angle / 2.0 / Math.PI));
            g.draw((Shape)new Line2D.Double(Math.PI * 2 * Math.floor(t * f / 2.0 / Math.PI) / f, 0.0, t, 0.0));
        }
        g.setColor(Color.gray);
        g.draw((Shape)new Line2D.Double(a * Math.cos(f * (t - p)) - a, a * Math.sin(f * (t - p)), x, y));
        g.draw((Shape)new Line2D.Double(t, 0.0, t, a * Math.sin(f * (t - p))));
        view.setStrokeSizeMultiplier(1);
        g.setColor(saveColor);
    }
}

