/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve.parametric;

import vmm3d.core.RealParamAnimateable;
import vmm3d.planecurve.parametric.PlaneCurveParametric;

public class NephroidOfFreeth
extends PlaneCurveParametric {
    private RealParamAnimateable aa;

    public NephroidOfFreeth() {
        this.tResolution.setValueAndDefault(300);
        this.aa = new RealParamAnimateable("aa", 2.0, 0.0, 3.0);
        this.addParameter(this.aa);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("4*pi");
        this.setDefaultWindow(-4.0, 4.0, -4.0, 4.0);
    }

    private double Multiplier(double t) {
        double AA = this.aa.getValue();
        return 1.0 - AA * Math.sin(t / 2.0);
    }

    @Override
    public double xValue(double t) {
        return this.Multiplier(t) * Math.cos(t);
    }

    @Override
    public double yValue(double t) {
        return this.Multiplier(t) * Math.sin(t);
    }
}

