/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve.parametric;

import vmm3d.core.RealParamAnimateable;
import vmm3d.planecurve.parametric.PlaneCurveParametric;

public class Lissajous
extends PlaneCurveParametric {
    private RealParamAnimateable amplitude1;
    private RealParamAnimateable amplitude2;
    private RealParamAnimateable frequency1;
    private RealParamAnimateable frequency2;
    private RealParamAnimateable phase;

    public Lissajous() {
        this.tResolution.setValueAndDefault(500);
        this.amplitude1 = new RealParamAnimateable("vmm3d.planecurve.parametric.SineCurve.amplitude", 2.0, 2.0, 2.0);
        this.amplitude2 = new RealParamAnimateable("vmm3d.planecurve.parametric.SineCurve.amplitude", 2.0, 2.0, 2.0);
        this.frequency1 = new RealParamAnimateable("vmm3d.planecurve.parametric.SineCurve.frequency", 3.0, 1.0, 5.0);
        this.frequency2 = new RealParamAnimateable("vmm3d.planecurve.parametric.SineCurve.frequency", 5.0, 1.0, 7.0);
        this.phase = new RealParamAnimateable("vmm3d.planecurve.parametric.SineCurve.phase", 0.0, 0.0, 0.0);
        this.phase.setMinimumValueForInput(0.0);
        this.phase.setMaximumValueForInput(Math.PI * 2);
        this.frequency1.setMinimumValueForInput(Double.MIN_VALUE);
        this.frequency2.setMinimumValueForInput(Double.MIN_VALUE);
        this.addParameter(this.phase);
        this.addParameter(this.frequency1);
        this.addParameter(this.frequency2);
        this.addParameter(this.amplitude1);
        this.addParameter(this.amplitude2);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("2*pi");
        this.setDefaultWindow(-4.0, 4.0, -4.0, 4.0);
    }

    @Override
    public double xValue(double t) {
        double aa = this.amplitude1.getValue();
        long n = Math.round(this.frequency2.getValue());
        double p = this.phase.getValue();
        return aa * Math.sin((double)n * t + p);
    }

    @Override
    public double yValue(double t) {
        double bb = this.amplitude2.getValue();
        long m = Math.round(this.frequency1.getValue());
        return bb * Math.cos((double)m * t);
    }
}

