/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve.parametric;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.Transform;
import vmm3d.core.View;
import vmm3d.planecurve.parametric.ConicSection;
import vmm3d.planecurve.parametric.PlaneCurveParametric;

public class Hyperbola
extends ConicSection {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm3d.planecurve.parametric.Hyperbola.a", 1.0, 1.0, 1.0);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm3d.planecurve.parametric.Hyperbola.b", 1.0, 1.0, 1.5);

    public Hyperbola() {
        this.setDefaultWindow(-4.0, 4.0, -4.0, 4.0);
        this.tmin.setValueAndDefault(-2.3);
        this.tmax.setValueAndDefault(2.3);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
    }

    @Override
    public void doDraw(VectorGraphics g, View view, Transform limits) {
        if (this.points.length == 0) {
            return;
        }
        super.doDraw(g, view, limits);
        if (view instanceof PlaneCurveParametric.PlaneCurveParametricView && ((PlaneCurveParametric.PlaneCurveParametricView)view).fractionToDraw < 1.0) {
            return;
        }
        GeneralPath curve = new GeneralPath();
        curve.moveTo(-((float)this.points[0].getX()), -((float)this.points[0].getY()));
        for (int i = 1; i < this.points.length; ++i) {
            curve.lineTo(-((float)this.points[i].getX()), -((float)this.points[i].getY()));
        }
        g.draw((Shape)curve);
    }

    @Override
    public double xValue(double t) {
        double exp = Math.exp(t);
        double cosh = (exp + 1.0 / exp) / 2.0;
        return this.bb.getValue() * cosh;
    }

    @Override
    public double yValue(double t) {
        double exp = Math.exp(t);
        double sinh = (exp - 1.0 / exp) / 2.0;
        return this.aa.getValue() * sinh;
    }

    @Override
    public double xDerivativeValue(double t) {
        double exp = Math.exp(t);
        double sinh = (exp - 1.0 / exp) / 2.0;
        return this.bb.getValue() * sinh;
    }

    @Override
    public double yDerivativeValue(double t) {
        double exp = Math.exp(t);
        double cosh = (exp + 1.0 / exp) / 2.0;
        return this.aa.getValue() * cosh;
    }

    @Override
    public double x2ndDerivativeValue(double t) {
        return this.xValue(t);
    }

    @Override
    public double y2ndDerivativeValue(double t) {
        return this.yValue(t);
    }

    @Override
    protected void drawFociAndDirectrix(VectorGraphics g, View view, Transform limits, double t) {
        double c;
        double a = this.bb.getValue();
        double b = this.aa.getValue();
        double f1_x = c = Math.sqrt(Math.abs(a * a + b * b));
        double f2_x = -c;
        double f2_y = 0.0;
        double f1_y = 0.0;
        double radius = 2.0 * Math.abs(a);
        Color saveColor = g.getColor();
        double width = Math.abs(limits.getXmax() - limits.getXmin());
        double crossSize = 4.0 * limits.getPixelWidth();
        g.setColor(Color.red);
        g.draw((Shape)new Line2D.Double(f1_x - crossSize, f1_y - crossSize, f1_x + crossSize, f1_y + crossSize));
        g.draw((Shape)new Line2D.Double(f1_x - crossSize, f1_y + crossSize, f1_x + crossSize, f1_y - crossSize));
        g.draw((Shape)new Line2D.Double(f2_x - crossSize, f2_y - crossSize, f2_x + crossSize, f2_y + crossSize));
        g.draw((Shape)new Line2D.Double(f2_x - crossSize, f2_y + crossSize, f2_x + crossSize, f2_y - crossSize));
        g.setColor(Color.blue);
        g.draw((Shape)new Ellipse2D.Double(f2_x - radius, f2_y - radius, 2.0 * radius, 2.0 * radius));
        if (Double.isNaN(t)) {
            g.setColor(saveColor);
            return;
        }
        double x = this.xValue(t);
        double y = this.yValue(t);
        g.setColor(new Color(0, 150, 0));
        double dx = this.xDerivativeValue(t);
        double dy = this.yDerivativeValue(t);
        g.draw((Shape)new Line2D.Double(x - width * dx, y - width * dy, x + width * dx, y + width * dy));
        g.setColor(Color.red);
        g.draw((Shape)new Line2D.Double(x, y, f2_x, f2_y));
        g.setColor(Color.magenta);
        g.draw((Shape)new Line2D.Double(x, y, f1_x, f1_y));
        dx = x - f2_x;
        dy = y - f2_y;
        double length = Math.sqrt(dx * dx + dy * dy);
        double s_x = f2_x + dx / length * radius;
        double s_y = f2_y + dy / length * radius;
        g.draw((Shape)new Line2D.Double(x, y, s_x, s_y));
        g.draw((Shape)new Line2D.Double(f1_x, f1_y, s_x, s_y));
        view.drawString("F", f1_x + 4.0 * limits.getPixelWidth(), f1_y + 4.0 * limits.getPixelHeight());
        view.drawString("S", s_x - 10.0 * limits.getPixelWidth(), s_y + 3.0 * limits.getPixelHeight());
        g.setColor(saveColor);
    }
}

