/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.planecurve.parametric;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.Transform;
import vmm3d.core.View;
import vmm3d.planecurve.parametric.DecoratedCurve;

public class Deltoid
extends DecoratedCurve {
    public Deltoid() {
        this.tResolution.setValueAndDefault(250);
        this.tmin.setValueAndDefaultFromString("0");
        this.tmax.setValueAndDefaultFromString("2*pi");
        this.setDefaultWindow(-4.5, 4.5, -4.5, 4.5);
    }

    private static double sin(double t) {
        return Math.sin(t);
    }

    private static double cos(double t) {
        return Math.cos(t);
    }

    @Override
    public double xValue(double t) {
        return 2.0 * Deltoid.cos(t) + Deltoid.cos(2.0 * t);
    }

    @Override
    public double yValue(double t) {
        return 2.0 * Deltoid.sin(t) - Deltoid.sin(2.0 * t);
    }

    @Override
    public double xDerivativeValue(double t) {
        return -2.0 * Deltoid.sin(t) - 2.0 * Deltoid.sin(2.0 * t);
    }

    @Override
    public double yDerivativeValue(double t) {
        return 2.0 * Deltoid.cos(t) - 2.0 * Deltoid.cos(2.0 * t);
    }

    @Override
    protected void drawNeededStuff(VectorGraphics g, View view, Transform limits, double t) {
        DecoratedCurve.MMOView myView = (DecoratedCurve.MMOView)view;
        Color saveColor = g.getColor();
        this.setStrokeSize(3);
        double xa = this.xValue(t);
        double ya = this.yValue(t);
        double tx = this.xDerivativeValue(t);
        double ty = this.yDerivativeValue(t);
        double etx = tx / Math.sqrt(tx * tx + ty * ty);
        double ety = ty / Math.sqrt(tx * tx + ty * ty);
        g.setColor(Color.blue);
        myView.setStrokeSizeMultiplier(1);
        g.draw((Shape)new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        g.setColor(Color.red);
        myView.setStrokeSizeMultiplier(3);
        g.draw((Shape)new Ellipse2D.Double(2.0 * Deltoid.cos(t) - 1.0, 2.0 * Deltoid.sin(t) - 1.0, 2.0, 2.0));
        myView.setStrokeSizeMultiplier(1);
        g.setColor(Color.lightGray);
        g.draw((Shape)new Ellipse2D.Double(Deltoid.cos(t) - 2.0, Deltoid.sin(t) - 2.0, 4.0, 4.0));
        g.draw((Shape)new Ellipse2D.Double(Deltoid.cos(t) - 0.07, Deltoid.sin(t) - 0.07, 0.14, 0.14));
        myView.setStrokeSizeMultiplier(3);
        g.setColor(Color.green);
        g.draw((Shape)new Line2D.Double(2.0 * Deltoid.cos(t), 2.0 * Deltoid.sin(t), xa, ya));
        g.setColor(new Color(0, 0, 0));
        g.draw((Shape)new Line2D.Double(2.0 * Deltoid.cos(t) + 0.9 * Deltoid.cos(2.0 * t), 2.0 * Deltoid.sin(t) - 0.9 * Deltoid.sin(2.0 * t), xa, ya));
        myView.setStrokeSizeMultiplier(1);
        g.setColor(new Color(0, 128, 0));
        g.draw((Shape)new Line2D.Double(Deltoid.cos(t) - 2.0 * etx, Deltoid.sin(t) - 2.0 * ety, Deltoid.cos(t) + 2.0 * etx, Deltoid.sin(t) + 2.0 * ety));
        g.draw((Shape)new Line2D.Double(3.0 * Deltoid.cos(t), 3.0 * Deltoid.sin(t), xa, ya));
        myView.setStrokeSizeMultiplier(3);
        g.setColor(saveColor);
    }
}

