/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.functions;

import vmm3d.functions.EvalStack;
import vmm3d.functions.ProgFunction;
import vmm3d.functions.Type;

public class Function {
    protected ProgFunction func;
    private String name;

    Function(String name, ProgFunction func) {
        assert (func.getArgType() == Type.REAL && func.getType() == Type.REAL);
        this.func = func;
        this.name = name;
    }

    ProgFunction getProgFunction() {
        return this.func;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getArity() {
        return this.func.getArgCount();
    }

    public synchronized double value(double[] argumentValues) {
        return this.value(argumentValues, EvalStack.perThread());
    }

    public double value(double[] argumentValues, EvalStack stack) {
        int argCt = this.func.getArgCount();
        if (argCt == 0) {
            if (argumentValues != null && argumentValues.length > 0) {
                throw new IllegalArgumentException("internal error: incorrect number of arguments provided to function");
            }
            this.func.apply(stack);
            return stack.pop();
        }
        if (argumentValues == null || argumentValues.length != argCt) {
            throw new IllegalArgumentException("internal error: incorrect number of arguments provided to function");
        }
        for (double x : argumentValues) {
            stack.push(x);
        }
        this.func.apply(stack);
        return stack.pop();
    }
}

