/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.functions;

import vmm3d.core.Complex;
import vmm3d.functions.EvalStack;
import vmm3d.functions.ProgFunction;
import vmm3d.functions.Type;

public class ComplexFunction {
    protected ProgFunction func;
    private String name;

    ComplexFunction(String name, ProgFunction func) {
        assert (func.getArgType() == Type.COMPLEX && func.getType() == Type.COMPLEX);
        this.func = func;
        this.name = name;
    }

    ProgFunction getProgFunction() {
        return this.func;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getArity() {
        return this.func.getArgCount();
    }

    public synchronized Complex value(Complex[] argumentValues) {
        return this.value(argumentValues, EvalStack.perThread());
    }

    public synchronized Complex value(double ... arg) {
        return this.value(arg, EvalStack.perThread());
    }

    public Complex value(Complex[] argumentValues, EvalStack stack) {
        Complex answer = new Complex();
        this.value(argumentValues, stack, answer);
        return answer;
    }

    public Complex value(double[] argumentValues, EvalStack stack) {
        Complex answer = new Complex();
        this.value(argumentValues, stack, answer);
        return answer;
    }

    public void value(Complex[] argumentValues, EvalStack stack, Complex answer) {
        if (answer == null) {
            throw new IllegalArgumentException("internal error: answer object cannot be null");
        }
        int argCt = this.func.getArgCount();
        if (argCt == 0) {
            if (argumentValues != null && argumentValues.length > 0) {
                throw new IllegalArgumentException("internal error: incorrect number of arguments provided to function");
            }
            this.func.apply(stack);
            stack.popComplex(answer);
        } else {
            if (argumentValues == null || argumentValues.length != argCt) {
                throw new IllegalArgumentException("internal error: incorrect number of arguments provided to function");
            }
            for (Complex z : argumentValues) {
                stack.push(z);
            }
            this.func.apply(stack);
            stack.popComplex(answer);
        }
    }

    public void value(double[] argumentValues, EvalStack stack, Complex answer) {
        if (answer == null) {
            throw new IllegalArgumentException("internal error: answer object cannot be null");
        }
        int argCt = this.func.getArgCount();
        if (argCt == 0) {
            if (argumentValues != null && argumentValues.length > 0) {
                throw new IllegalArgumentException("internal error: incorrect number of arguments provided to function");
            }
            this.func.apply(stack);
            stack.popComplex(answer);
        } else {
            if (argumentValues == null || argumentValues.length != 2 * argCt) {
                throw new IllegalArgumentException("internal error: incorrect number of arguments provided to function");
            }
            for (double d : argumentValues) {
                stack.push(d);
            }
            this.func.apply(stack);
            stack.popComplex(answer);
        }
    }
}

