/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JColorChooser;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freehep.graphics2d.VectorGraphics;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.actions.ActionRadioGroup;
import vmm3d.core.Animation;
import vmm3d.core.Axes2D;
import vmm3d.core.BasicMouseTask2D;
import vmm3d.core.Decorateable;
import vmm3d.core.Decoration;
import vmm3d.core.Display;
import vmm3d.core.Exhibit;
import vmm3d.core.I18n;
import vmm3d.core.MouseTask;
import vmm3d.core.Parameter;
import vmm3d.core.Parameterizable;
import vmm3d.core.Transform;
import vmm3d.core.UserExhibit;
import vmm3d.core.VMMSave;

public class View
implements Parameterizable,
Decorateable,
ChangeListener {
    private Display display;
    private Exhibit exhibit;
    private String name;
    @VMMSave
    private boolean applyGraphics2DTransform = true;
    @VMMSave
    private boolean preserveAspect = true;
    @VMMSave
    private boolean antialiased;
    @VMMSave
    private boolean showAxes;
    @VMMSave
    private Color background = Color.white;
    @VMMSave
    private Color foreground = Color.black;
    private Point2D tempPoint = new Point2D.Double();
    private int previousWidth;
    private int previousHeight;
    private Transform transform;
    protected Animation buildAnimation;
    protected boolean needsRedraw;
    protected BufferedImage fullOSI;
    protected int linewidth = 2;
    protected boolean recalculate = true;
    protected VectorGraphics currentGraphics;
    protected ArrayList<Parameter> parameters;
    protected ArrayList<Decoration> decorations;
    protected volatile boolean buildingImageForFilmstrip;
    protected AbstractActionVMM showAxesAction = new AbstractActionVMM(I18n.tr("vmm3d.core.commands.ShowAxes")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            View.this.setShowAxes(!View.this.getShowAxes());
        }
    };
    protected ActionRadioGroup backgroundCommands = new ActionRadioGroup(new String[]{I18n.tr("vmm3d.core.commands.BlackBackground"), I18n.tr("vmm3d.core.commands.WhiteBackground"), I18n.tr("vmm3d.core.commands.CustomBackground")}, 1){

        @Override
        public void optionSelected(int selectedIndex) {
            if (selectedIndex == 0) {
                View.this.setBackground(Color.black);
                this.setSelectedIndex(0);
            } else if (selectedIndex == 1) {
                View.this.setBackground(Color.white);
                this.setSelectedIndex(1);
            } else if (View.this.getDisplay() != null) {
                Color c = JColorChooser.showDialog(View.this.getDisplay(), I18n.tr("vmm3d.core.dialogtitle.ChooseBackground"), View.this.getBackground());
                if (c != null) {
                    View.this.setBackground(c);
                    this.setSelectedIndex(2);
                } else {
                    if (View.this.getBackground().equals(Color.black)) {
                        this.setSelectedIndex(0);
                    } else if (View.this.getBackground().equals(Color.white)) {
                        this.setSelectedIndex(1);
                    } else {
                        this.setSelectedIndex(2);
                    }
                    return;
                }
            }
            View.this.forceRedraw();
        }
    };
    protected boolean directOffscreenDrawing;
    protected int offscreenImageType = 1;

    protected void setLineWidth(int width) {
        this.linewidth = width;
    }

    protected int getLineWidth() {
        return this.linewidth;
    }

    public String getName() {
        if (this.name == null) {
            return this.getClass().getName();
        }
        return this.name;
    }

    public void setNeedRecalculate(boolean recalculate) {
        this.recalculate = recalculate;
    }

    public boolean getNeedRecalculate() {
        return this.recalculate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return I18n.tr(this.getName());
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public Exhibit getExhibit() {
        return this.exhibit;
    }

    public void setExhibit(Exhibit exhibit) {
        if (exhibit == this.exhibit) {
            return;
        }
        if (this.exhibit != null) {
            this.exhibit.removeChangeListener(this);
            this.exhibit.removeView(this);
        }
        this.exhibit = exhibit;
        if (exhibit == null) {
            this.setTransform(null);
            this.setBackground(null);
            this.setForeground(null);
        } else {
            exhibit.addChangeListener(this);
            exhibit.addView(this);
            this.setTransform(exhibit.getDefaultTransform(this));
            this.setBackground(exhibit.getDefaultBackground());
            this.setForeground(exhibit.getDefaultForeground());
        }
        this.forceRedraw();
    }

    public void finish() {
    }

    public void takeExhibit(View view, boolean shareTransform) {
        Exhibit exhibit;
        Exhibit exhibit2 = exhibit = view == null ? null : view.getExhibit();
        if (exhibit == null) {
            this.setExhibit(null);
        } else {
            this.setExhibit(exhibit);
            this.setBackground(exhibit.getDefaultBackground());
            this.setForeground(exhibit.getDefaultForeground());
            if (shareTransform) {
                this.setTransform(view.getTransform());
            } else {
                this.setTransform((Transform)view.getTransform().clone());
            }
        }
    }

    public String getStatusText() {
        return null;
    }

    public boolean getShowAxes() {
        return this.showAxes;
    }

    public void setShowAxes(boolean show) {
        if (show != this.showAxes) {
            if (show) {
                Axes2D axes = this.createAxes();
                this.addDecoration(axes);
            } else {
                for (int i = this.decorations.size() - 1; i >= 0; --i) {
                    if (!(this.decorations.get(i) instanceof Axes2D)) continue;
                    this.decorations.remove(i);
                }
                this.forceRedraw();
            }
            if (show) {
                this.showAxesAction.putValue("Name", I18n.tr("vmm3d.core.commands.HideAxes"));
            } else {
                this.showAxesAction.putValue("Name", I18n.tr("vmm3d.core.commands.ShowAxes"));
            }
            this.showAxes = show;
        }
    }

    protected Axes2D createAxes() {
        return new Axes2D();
    }

    public MouseTask getDefaultMouseTask() {
        return new BasicMouseTask2D();
    }

    public boolean getApplyGraphics2DTransform() {
        return this.applyGraphics2DTransform;
    }

    public void setApplyGraphics2DTransform(boolean applyGraphics2DTransform) {
        if (applyGraphics2DTransform != this.applyGraphics2DTransform) {
            this.forceRedraw();
            this.applyGraphics2DTransform = applyGraphics2DTransform;
        }
    }

    public boolean getPreserveAspect() {
        return this.preserveAspect;
    }

    public void setPreserveAspect(boolean preserveAspect) {
        if (preserveAspect != this.preserveAspect) {
            this.forceRedraw();
            this.preserveAspect = preserveAspect;
        }
    }

    public boolean getAntialiased() {
        return this.antialiased;
    }

    public void setAntialiased(boolean antialiased) {
        if (antialiased != this.antialiased) {
            this.forceRedraw();
            this.antialiased = antialiased;
        }
    }

    public void setWindow(double xmin, double xmax, double ymin, double ymax) {
        if (this.transform != null) {
            this.transform.setLimits(xmin, xmax, ymin, ymax);
        }
    }

    public void setWindow(double[] window) {
        if (window != null) {
            this.setWindow(window[0], window[1], window[2], window[3]);
        }
    }

    public double[] getWindow() {
        if (this.transform == null) {
            return null;
        }
        return new double[]{this.transform.getXmin(), this.transform.getXmax(), this.transform.getYmin(), this.transform.getYmax()};
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform transform) {
        if (transform != null) {
            transform.removeChangeListener(this);
        }
        this.transform = transform;
        if (transform != null) {
            transform.addChangeListener(this);
        }
    }

    public double[] getRequestedWindow() {
        if (this.transform == null) {
            return null;
        }
        return new double[]{this.transform.getXminRequested(), this.transform.getXmaxRequested(), this.transform.getYminRequested(), this.transform.getYmaxRequested()};
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color c) {
        if (c == null) {
            c = this.exhibit != null ? this.exhibit.getDefaultBackground() : Color.white;
        }
        if (c.equals(this.background)) {
            return;
        }
        this.background = c;
        if (c.getRed() < 150 && c.getGreen() < 120 && c.getBlue() < 150) {
            this.setForeground(Color.white);
        } else {
            this.setForeground(Color.black);
        }
        this.forceRedraw();
        if (Color.black.equals(this.getBackground())) {
            this.backgroundCommands.setSelectedIndex(0);
        } else if (Color.white.equals(this.getBackground())) {
            this.backgroundCommands.setSelectedIndex(1);
        } else {
            this.backgroundCommands.setSelectedIndex(2);
        }
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color c) {
        if (c == null) {
            c = this.exhibit != null ? this.exhibit.getDefaultBackground() : Color.white;
        }
        if (c.equals(this.foreground)) {
            return;
        }
        this.foreground = c;
        this.forceRedraw();
    }

    public void setFastDrawing(boolean fast, boolean redrawSynchronizedViews) {
        if (this.transform != null) {
            this.transform.setFastDrawing(fast, redrawSynchronizedViews);
            if (!redrawSynchronizedViews) {
                this.forceRedraw();
            }
        }
    }

    public void setFastDrawing(boolean fast) {
        this.setFastDrawing(fast, true);
    }

    public boolean getFastDrawing() {
        return this.transform == null ? false : this.transform.getFastDrawing();
    }

    public void addExtraXML(Document containingDocument, Element viewElement) {
    }

    public void readExtraXML(Element viewInfo) throws IOException {
    }

    public Parameter[] getParameters() {
        if (this.parameters == null) {
            return new Parameter[0];
        }
        Parameter[] params = new Parameter[this.parameters.size()];
        for (int i = params.length - 1; i >= 0; --i) {
            params[params.length - i - 1] = this.parameters.get(i);
        }
        return params;
    }

    public Parameter[] getViewAndExhibitParameters() {
        int i;
        Parameter[] exhibitParams = null;
        Parameter[] functionParams = null;
        if (this.exhibit != null) {
            exhibitParams = this.exhibit.getParameters();
            if (this.exhibit instanceof UserExhibit) {
                functionParams = ((UserExhibit)((Object)this.exhibit)).getUserExhibitSupport().getFunctionParameters();
            }
        }
        int ct = this.parameters == null ? 0 : this.parameters.size();
        ct += exhibitParams == null ? 0 : exhibitParams.length;
        Parameter[] params = new Parameter[ct += functionParams == null ? 0 : functionParams.length];
        int pos = 0;
        if (functionParams != null) {
            for (i = 0; i < functionParams.length; ++i) {
                params[pos++] = functionParams[i];
            }
        }
        if (exhibitParams != null) {
            for (i = 0; i < exhibitParams.length; ++i) {
                params[pos++] = exhibitParams[i];
            }
        }
        if (this.parameters != null) {
            for (i = 0; i < this.parameters.size(); ++i) {
                params[pos++] = this.parameters.get(i);
            }
        }
        return params;
    }

    public Parameter getParameterByName(String name) {
        if (this.parameters != null && name != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (!name.equals(this.parameters.get(i).getName())) continue;
                return this.parameters.get(i);
            }
        }
        return null;
    }

    public void addParameter(Parameter param) {
        if (param == null) {
            return;
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        if (this.parameters.contains(param)) {
            return;
        }
        this.parameters.add(param);
        param.setOwner(this);
    }

    public void removeParameter(Parameter param) {
        if (param == null || this.parameters == null || !this.parameters.contains(param)) {
            return;
        }
        this.parameters.remove(param);
        param.setOwner(null);
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        this.forceRedraw();
    }

    @Override
    public void addDecoration(Decoration d) {
        if (d == null) {
            return;
        }
        if (this.decorations == null) {
            this.decorations = new ArrayList();
        }
        if (this.decorations.contains(d)) {
            return;
        }
        this.decorations.add(d);
        d.addChangeListener(this);
        this.forceRedraw();
    }

    @Override
    public void removeDecoration(Decoration d) {
        if (this.decorations != null && d != null && this.decorations.contains(d)) {
            this.decorations.remove(d);
            if (this.decorations.size() == 0) {
                this.decorations = null;
            }
            d.removeChangeListener(this);
            this.forceRedraw();
        }
    }

    public void clearDecorations() {
        if (this.decorations != null) {
            for (int i = 0; i < this.decorations.size(); ++i) {
                this.decorations.get(i).removeChangeListener(this);
            }
            this.decorations = null;
            this.forceRedraw();
        }
    }

    public Decoration[] getDecorations() {
        if (this.decorations == null) {
            return new Decoration[0];
        }
        Decoration[] decs = new Decoration[this.decorations.size()];
        this.decorations.toArray(decs);
        return decs;
    }

    public ActionList getViewCommands() {
        ActionList commands = new ActionList();
        commands.add(this.showAxesAction);
        commands.add(null);
        commands.add(this.backgroundCommands);
        return commands;
    }

    public ActionList getSettingsCommands() {
        return new ActionList();
    }

    public ActionList getSettingsCommandsForViewAndExhibit() {
        ActionList exhibitCommands = null;
        AbstractActionVMM changeUserData = null;
        if (this.exhibit != null) {
            UserExhibit.Support s;
            exhibitCommands = this.exhibit.getSettingsCommandsForView(this);
            if (this.exhibit instanceof UserExhibit && (s = ((UserExhibit)((Object)this.exhibit)).getUserExhibitSupport()).getAllowChangeUserDataCommand()) {
                changeUserData = s.makeChangeUserDataAction(this);
            }
        }
        ActionList viewCommands = this.getSettingsCommands();
        if (exhibitCommands == null && changeUserData == null && viewCommands == null) {
            return null;
        }
        ActionList combinedCommands = new ActionList();
        if (exhibitCommands != null) {
            combinedCommands.addAll(exhibitCommands);
        }
        if (changeUserData != null) {
            if (combinedCommands.getItemCount() > 0) {
                combinedCommands.add(null);
            }
            combinedCommands.add(changeUserData);
        }
        if (viewCommands != null && viewCommands.getItemCount() > 0) {
            if (combinedCommands.getItemCount() > 0) {
                combinedCommands.add(null);
            }
            combinedCommands.addAll(viewCommands);
        }
        return combinedCommands;
    }

    public ActionList getActions() {
        return new ActionList();
    }

    public ActionList getActionsForViewAndExhibit() {
        ActionList exhibitCommands = null;
        if (this.exhibit != null) {
            exhibitCommands = this.exhibit.getActionsForView(this);
        }
        ActionList viewCommands = this.getActions();
        if (exhibitCommands == null && viewCommands == null) {
            return null;
        }
        ActionList combinedCommands = new ActionList();
        if (exhibitCommands != null) {
            combinedCommands.addAll(exhibitCommands);
        }
        if (viewCommands != null && viewCommands.getItemCount() > 0) {
            if (combinedCommands.getItemCount() > 0) {
                combinedCommands.add(null);
            }
            combinedCommands.addAll(viewCommands);
        }
        return combinedCommands;
    }

    public ActionList getAdditionalAnimations() {
        return new ActionList();
    }

    public ActionList getAdditionalAnimationsForViewAndExhibit() {
        ActionList exhibitCommands = null;
        if (this.exhibit != null) {
            exhibitCommands = this.exhibit.getAdditionalAnimationsForView(this);
        }
        ActionList viewCommands = this.getAdditionalAnimations();
        if (exhibitCommands == null && viewCommands == null) {
            return null;
        }
        ActionList combinedCommands = new ActionList();
        if (exhibitCommands != null) {
            combinedCommands.addAll(exhibitCommands);
        }
        if (viewCommands != null && viewCommands.getItemCount() > 0) {
            if (combinedCommands.getItemCount() > 0) {
                combinedCommands.add(null);
            }
            combinedCommands.addAll(viewCommands);
        }
        return combinedCommands;
    }

    protected void doDraw(VectorGraphics g) {
        this.needsRedraw = true;
        if (this.exhibit != null) {
            this.exhibit.render(g, this, this.transform, this.decorations);
        }
    }

    public void forceRedraw() {
        this.needsRedraw = true;
        if (this.buildAnimation != null) {
            this.buildAnimation.cancel();
        }
        if (this.display != null) {
            this.display.repaint();
        }
    }

    public void setNeedRedraw(boolean needsRedraw) {
        this.needsRedraw = needsRedraw;
    }

    public boolean getNeedRedraw() {
        return this.needsRedraw;
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.forceRedraw();
    }

    void installBuildAnimation(Animation builder) {
        if (this.buildAnimation != null) {
            this.buildAnimation.cancel();
        }
        this.buildAnimation = builder;
        if (builder != null) {
            this.display.installAnimation(builder);
        }
    }

    Animation getBuildAnimation() {
        return this.buildAnimation;
    }

    public void render(VectorGraphics g, int width, int height) {
        this.currentGraphics = g;
        if (this.directOffscreenDrawing) {
            this.endDrawToOffscreenImage();
        }
        if (width == 0 || height == 0) {
            return;
        }
        if (this.exhibit == null) {
            Color saveColor = g.getColor();
            g.setColor(this.background);
            g.fillRect(0, 0, width, height);
            g.setColor(saveColor);
            return;
        }
        if (this.previousWidth != width || this.previousHeight != height) {
            this.needsRedraw = true;
            this.previousWidth = width;
            this.previousHeight = height;
        }
        if (this.needsRedraw) {
            this.currentGraphics.setStroke((Stroke)new BasicStroke(this.linewidth));
            this.prepareOSIForDrawing();
            this.doDraw(this.currentGraphics);
            this.finishOSIDraw();
            this.transform.finishDrawing();
            this.currentGraphics.dispose();
            this.setFastDrawing(true);
            this.currentGraphics.dispose();
            this.needsRedraw = true;
        }
        this.putOSI(this.currentGraphics, width, height);
    }

    protected boolean needsNewOSI(int width, int height) {
        return this.fullOSI == null || this.fullOSI.getWidth() != width || this.fullOSI.getHeight() != height;
    }

    protected void putOSI(VectorGraphics g, int width, int height) {
    }

    protected void createOSI(int width, int height) {
    }

    public void setCurrentGraphics(VectorGraphics vectorg) {
        this.currentGraphics = vectorg;
    }

    public VectorGraphics getCurrentGraphics() {
        return this.currentGraphics;
    }

    protected void clearOSI() {
    }

    protected VectorGraphics prepareOSIForDrawing() {
        int width = this.display.getWidth();
        int height = this.display.getHeight();
        if (this.currentGraphics == null) {
            return null;
        }
        this.currentGraphics.setColor(this.foreground);
        this.currentGraphics.setBackground(this.background);
        if (this.antialiased) {
            this.currentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.transform.setUpDrawInfo(this.currentGraphics, 0, 0, width, height, this.preserveAspect, this.applyGraphics2DTransform);
        return this.currentGraphics;
    }

    protected void finishOSIDraw() {
    }

    public void setColor(Color c) {
        if (this.currentGraphics != null) {
            this.currentGraphics.setColor(c == null ? this.getForeground() : c);
        }
    }

    public Color getColor() {
        return this.currentGraphics == null ? null : this.currentGraphics.getColor();
    }

    public void setStrokeSizeMultiplier(int pixels) {
        if (this.currentGraphics != null) {
            this.currentGraphics.setStroke((Stroke)new BasicStroke((float)pixels * this.transform.getDefaultStrokeSize()));
        }
    }

    public void drawPixel(double x, double y) {
        this.tempPoint.setLocation(x, y);
        this.transform.windowToViewport(this.tempPoint);
        int xInt = (int)(this.tempPoint.getX() + 0.4999);
        int yInt = (int)(this.tempPoint.getY() + 0.4999);
        this.drawPixelDirect(null, xInt, yInt);
    }

    public void drawPixel(Point2D pt) {
        this.drawPixel(pt.getX(), pt.getY());
    }

    public void drawDot(Point2D pt, double diameter) {
        this.tempPoint.setLocation(pt);
        this.transform.windowToDrawingCoords(this.tempPoint);
        double h = diameter * this.transform.getPixelWidth();
        double w = diameter * this.transform.getPixelHeight();
        this.currentGraphics.fill((Shape)new Ellipse2D.Double(pt.getX() - h / 2.0, pt.getY() - w / 2.0, h, w));
    }

    public void drawPixels(Point2D[] points, int pointIndexStart, int pointIndexEnd) {
        if (points == null) {
            return;
        }
        if (pointIndexStart >= points.length) {
            pointIndexStart = points.length - 1;
        }
        if (pointIndexStart < 0) {
            pointIndexStart = 0;
        }
        if (pointIndexEnd >= points.length) {
            pointIndexEnd = points.length - 1;
        }
        if (pointIndexEnd < 0) {
            pointIndexEnd = 0;
        }
        if (pointIndexEnd <= pointIndexStart) {
            return;
        }
        Color color = this.currentGraphics.getColor();
        for (int i = pointIndexStart; i <= pointIndexEnd; ++i) {
            if (points[i] == null) continue;
            this.tempPoint.setLocation(points[i]);
            this.transform.windowToViewport(this.tempPoint);
            this.drawPixelDirect(color, (int)(this.tempPoint.getX() + 0.499), (int)(this.tempPoint.getY() + 0.499));
        }
    }

    public void drawString(String s, double x, double y) {
        Point2D.Double pt = new Point2D.Double(x, y);
        this.transform.windowToViewport(pt);
        this.transform.getUntransformedGraphics().drawString(s, (float)((Point2D)pt).getX(), (float)((Point2D)pt).getY());
    }

    public void drawString(String s, Point2D xyCoords) {
        this.drawString(s, xyCoords.getX(), xyCoords.getY());
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.tempPoint.setLocation(x1, y1);
        this.transform.windowToDrawingCoords(this.tempPoint);
        double tx1 = this.tempPoint.getX();
        double ty1 = this.tempPoint.getY();
        this.tempPoint.setLocation(x2, y2);
        this.transform.windowToDrawingCoords(this.tempPoint);
        this.currentGraphics.draw((Shape)new Line2D.Double(tx1, ty1, this.tempPoint.getX(), this.tempPoint.getY()));
    }

    public void drawLine(Point2D pt1, Point2D pt2) {
        this.drawLine(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY());
    }

    public void drawCurve(Point2D[] points, int pointIndexStart, int pointIndexEnd) {
        if (points == null) {
            return;
        }
        if (pointIndexStart >= points.length) {
            pointIndexStart = points.length - 1;
        }
        if (pointIndexStart < 0) {
            pointIndexStart = 0;
        }
        if (pointIndexEnd >= points.length) {
            pointIndexEnd = points.length - 1;
        }
        if (pointIndexEnd < 0) {
            pointIndexEnd = 0;
        }
        if (pointIndexEnd <= pointIndexStart) {
            return;
        }
        GeneralPath curve = new GeneralPath();
        double maxJumpX = Math.abs(this.transform.getXmax() - this.transform.getXmin()) / 4.0;
        double maxJumpY = Math.abs(this.transform.getYmax() - this.transform.getYmin()) / 4.0;
        if (this.applyGraphics2DTransform) {
            maxJumpX = maxJumpY = Math.max(maxJumpX, maxJumpY);
        }
        boolean moved = false;
        for (int i = pointIndexStart; i < pointIndexEnd; ++i) {
            if (points[i] == null) continue;
            this.tempPoint.setLocation(points[i]);
            this.transform.windowToDrawingCoords(this.tempPoint);
            if (i == pointIndexStart) {
                curve.moveTo((float)this.tempPoint.getX(), (float)this.tempPoint.getY());
                continue;
            }
            if (i > pointIndexStart && points[i - 1] != null && Math.abs(points[i].getX() - points[i - 1].getX()) <= maxJumpX && Math.abs(points[i].getY() - points[i - 1].getY()) <= maxJumpY) {
                curve.lineTo((float)this.tempPoint.getX(), (float)this.tempPoint.getY());
                continue;
            }
            curve.moveTo((float)this.tempPoint.getX(), (float)this.tempPoint.getY());
            moved = true;
        }
        if (points[pointIndexEnd] != null) {
            if (pointIndexStart == 0 && pointIndexEnd == points.length - 1 && points[0] != null && Math.abs(points[0].getX() - points[pointIndexEnd].getX()) <= this.transform.getPixelWidth() / 100.0 && Math.abs(points[0].getY() - points[pointIndexEnd].getY()) <= this.transform.getPixelHeight() / 100.0 && !moved) {
                curve.closePath();
            } else {
                this.tempPoint.setLocation(points[pointIndexEnd]);
                this.transform.windowToDrawingCoords(this.tempPoint);
                if (points[pointIndexEnd - 1] != null && Math.abs(points[pointIndexEnd].getX() - points[pointIndexEnd - 1].getX()) <= maxJumpX && Math.abs(points[pointIndexEnd].getY() - points[pointIndexEnd - 1].getY()) <= maxJumpY) {
                    curve.lineTo((float)this.tempPoint.getX(), (float)this.tempPoint.getY());
                } else {
                    curve.moveTo((float)this.tempPoint.getX(), (float)this.tempPoint.getY());
                }
            }
        }
        this.currentGraphics.draw((Shape)curve);
    }

    public void drawCurve(Point2D[] points) {
        if (points != null) {
            this.drawCurve(points, points.length);
        }
    }

    public void drawCurve(Point2D[] points, int pointCount) {
        this.drawCurve(points, 0, pointCount - 1);
    }

    public void drawPixelDirect(Color color, int x, int y) {
        if (x < 0 || y < 0 || x >= this.fullOSI.getWidth() || y >= this.fullOSI.getHeight()) {
            return;
        }
        if (color == null) {
            color = this.currentGraphics.getColor();
        }
        int rgb = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        int size = 2;
        this.currentGraphics.setColor(color);
        this.currentGraphics.fill((Shape)new Ellipse2D.Double(x, y, size, size));
    }

    public void drawLineDirect(int x1, int y1, int x2, int y2) {
        this.currentGraphics = this.getTransform().getUntransformedGraphics();
        this.currentGraphics.drawLine(x1, y1, x2, y2);
    }

    public void fillRectDirect(int x, int y, int width, int height) {
        this.currentGraphics = this.getTransform().getUntransformedGraphics();
        this.currentGraphics.fillRect(x, y, width, height);
    }

    public boolean beginDrawToOffscreenImage() {
        if (this.transform == null || this.transform.getWidth() == 0 || this.currentGraphics != null || this.fullOSI == null) {
            return false;
        }
        this.prepareOSIForDrawing();
        this.directOffscreenDrawing = true;
        return true;
    }

    public void endDrawToOffscreenImage() {
        if (!this.directOffscreenDrawing) {
            return;
        }
        this.transform.finishDrawing();
        this.finishOSIDraw();
        this.directOffscreenDrawing = false;
    }

    public BufferedImage getImage(boolean alwaysCopy) {
        if (this.display == null || this.exhibit == null || this.previousWidth == 0) {
            return null;
        }
        if (this.fullOSI != null && !alwaysCopy) {
            return this.fullOSI;
        }
        BufferedImage image = new BufferedImage(this.previousWidth, this.previousHeight, this.offscreenImageType);
        VectorGraphics g = (VectorGraphics)image.getGraphics();
        if (this.fullOSI == null) {
            this.render(g, this.previousWidth, this.previousHeight);
        } else {
            g.drawImage((Image)this.fullOSI, 0, 0, null);
        }
        g.dispose();
        return image;
    }
}

