/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import vmm3d.core.RealParam;
import vmm3d.functions.Variable;

public class VariableParam
extends RealParam {
    private Variable variable;

    public VariableParam() {
        this((String)null, 0.0);
    }

    public VariableParam(String name, double initialValue) {
        super(name, initialValue);
        this.variable = new Variable(name, initialValue);
    }

    public VariableParam(String name, String value) throws NumberFormatException {
        super(name, value);
        this.variable = new Variable(name, this.getValue());
    }

    public VariableParam(Variable v) {
        super(v.getName(), v.getVal());
        this.variable = v;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.variable.setName(name);
    }

    @Override
    public void setValueObject(Object object) {
        super.setValueObject(object);
        if (this.variable != null) {
            this.variable.setVal((Double)object);
        }
    }

    @Override
    public Object getValueObject() {
        Double val = (Double)super.getValueObject();
        if (val.doubleValue() != this.variable.getVal()) {
            val = new Double(this.variable.getVal());
            super.setValueObject(val);
        }
        return val;
    }

    public Variable getVariable() {
        return this.variable;
    }
}

