/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freehep.graphics2d.VectorGraphics;

public class Transform
implements Cloneable {
    private static double NORMAL_SIZE = 600.0;
    private double xmin_requested;
    private double xmax_requested;
    private double ymin_requested;
    private double ymax_requested;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private int x;
    private int y;
    private int width;
    private int height;
    private ArrayList<ChangeListener> changeListeners;
    private ChangeEvent changeEvent;
    private boolean fastDrawing;
    private AffineTransform reverse_transform;
    private double pixelWidth;
    private double pixelHeight;
    private boolean appliedTransform2D;
    private float strokeWidth;
    private AffineTransform transform;
    protected VectorGraphics g;
    protected VectorGraphics untransformedGraphics;

    public Transform() {
        this(-5.0, 5.0, -5.0, 5.0);
    }

    public Transform(double xmin, double xmax, double ymin, double ymax) {
        this.setLimits(xmin, xmax, ymin, ymax);
    }

    public Transform(double nominalGraphicScale) {
        double size = 0.5 * NORMAL_SIZE / nominalGraphicScale;
        this.setLimits(-size, size, -size, size);
    }

    public Transform(Transform tr) {
        this(tr.xmin_requested, tr.xmax_requested, tr.ymin_requested, tr.ymax_requested);
    }

    void setFastDrawing(boolean fast, boolean fireChangeEvent) {
        if (fast != this.fastDrawing) {
            this.fastDrawing = fast;
            if (fireChangeEvent) {
                this.fireTransformChangeEvent();
            }
        }
    }

    boolean getFastDrawing() {
        return this.fastDrawing;
    }

    public void setLimits(double xmin, double xmax, double ymin, double ymax) {
        if (xmin == this.xmin && ymin == this.ymin && xmax == this.xmax && ymax == this.ymax) {
            return;
        }
        this.xmin = this.xmin_requested = xmin;
        this.xmax = this.xmax_requested = xmax;
        this.ymin = this.ymin_requested = ymin;
        this.ymax = this.ymax_requested = ymax;
        this.height = 0;
        this.width = 0;
        this.y = 0;
        this.x = 0;
        this.fireTransformChangeEvent();
    }

    protected void resetLimits(double xmin, double xmax, double ymin, double ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public double getXmaxRequested() {
        return this.xmax_requested;
    }

    public double getXminRequested() {
        return this.xmin_requested;
    }

    public double getYmaxRequested() {
        return this.ymax_requested;
    }

    public double getYminRequested() {
        return this.ymin_requested;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean equals(Object obj) {
        if (obj == null || !Transform.class.equals(obj.getClass())) {
            return false;
        }
        return this.hasSameViewTransform((Transform)obj);
    }

    public boolean hasSameViewTransform(Transform tr) {
        if (tr == null) {
            return false;
        }
        return this.xmin == tr.xmin && this.xmax == tr.xmax && this.ymin == tr.ymin && this.ymax == tr.ymax && this.x == tr.x && this.y == tr.y && this.width == tr.width && this.height == tr.height;
    }

    public Object clone() {
        Transform o = null;
        try {
            o = (Transform)super.clone();
            o.changeListeners = null;
            o.changeEvent = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o;
    }

    public void setUpDrawInfo(VectorGraphics g, int x, int y, int width, int height, boolean preserveAspect, boolean applyTransform2D) {
        Stroke stroke;
        this.g = g;
        this.untransformedGraphics = null;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.appliedTransform2D = applyTransform2D;
        this.transform = null;
        this.strokeWidth = 1.0f;
        this.pixelWidth = this.pixelHeight = (double)1.0f;
        if (width <= 0 || height <= 0) {
            this.height = 0;
            this.width = 0;
            return;
        }
        this.strokeWidth = 1.0f;
        this.pixelWidth = this.pixelHeight = (double)1.0f;
        if (g != null && (stroke = g.getStroke()) instanceof BasicStroke) {
            this.strokeWidth = ((BasicStroke)stroke).getLineWidth();
        }
        if (preserveAspect) {
            double viewAspect = (double)width / (double)height;
            double aspect = Math.abs((this.xmax_requested - this.xmin_requested) / (this.ymax_requested - this.ymin_requested));
            if (viewAspect < aspect) {
                double ycenter = (this.ymin_requested + this.ymax_requested) / 2.0;
                double newheight = (this.ymax_requested - this.ymin_requested) * (aspect / viewAspect);
                this.ymin = ycenter - newheight / 2.0;
                this.ymax = ycenter + newheight / 2.0;
                this.xmin = this.xmin_requested;
                this.xmax = this.xmax_requested;
            } else {
                double xcenter = (this.xmin_requested + this.xmax_requested) / 2.0;
                double newwidth = (this.xmax_requested - this.xmin_requested) * (viewAspect / aspect);
                this.xmin = xcenter - newwidth / 2.0;
                this.xmax = xcenter + newwidth / 2.0;
                this.ymin = this.ymin_requested;
                this.ymax = this.ymax_requested;
            }
        } else {
            this.xmin = this.xmin_requested;
            this.xmax = this.xmax_requested;
            this.ymin = this.ymin_requested;
            this.ymax = this.ymax_requested;
        }
        if (applyTransform2D && g != null) {
            this.pixelWidth = Math.abs(this.xmax - this.xmin) / (double)width;
            this.pixelHeight = Math.abs(this.ymax - this.ymin) / (double)height;
            double vScale = (double)height / (this.ymax - this.ymin);
            double hScale = (double)width / (this.xmax - this.xmin);
            this.transform = new AffineTransform();
            double d1w = width / 2;
            double d1h = height / 2;
            this.transform.translate(d1w, d1h);
            this.transform.scale(hScale, -vScale);
            double x1 = -(this.xmin + this.xmax) / 2.0;
            double y1 = -(this.ymin + this.ymax) / 2.0;
            this.transform.translate(x1, y1);
            g.transform(this.transform);
            this.strokeWidth *= (float)Math.min(this.pixelWidth, this.pixelHeight);
            g.setStroke((Stroke)new BasicStroke(this.strokeWidth));
            this.untransformedGraphics = g;
        }
    }

    public void finishDrawing() {
        this.g = null;
        if (this.untransformedGraphics != null) {
            this.untransformedGraphics.dispose();
        }
        this.untransformedGraphics = null;
    }

    public VectorGraphics getGraphics() {
        return this.g;
    }

    public VectorGraphics getUntransformedGraphics() {
        try {
            AffineTransform transform1 = this.transform.createInverse();
            this.untransformedGraphics.transform(transform1);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        if (this.untransformedGraphics == null) {
            return this.g;
        }
        this.untransformedGraphics.setColor(this.g.getColor());
        this.untransformedGraphics.setFont(this.g.getFont());
        return this.untransformedGraphics;
    }

    public void viewportToWindow(Point2D pt) {
        if (this.width == 0) {
            return;
        }
        double px = this.xmin + (pt.getX() - (double)this.x) / (double)this.width * (this.xmax - this.xmin);
        double py = this.ymax - (pt.getY() - (double)this.y) / (double)this.height * (this.ymax - this.ymin);
        pt.setLocation(px, py);
    }

    public void windowToViewport(Point2D pt) {
        if (this.width == 0) {
            return;
        }
        double px = (double)this.x + (pt.getX() - this.xmin) / (this.xmax - this.xmin) * (double)this.width;
        double py = (double)this.y + (this.ymax - pt.getY()) / (this.ymax - this.ymin) * (double)this.height;
        pt.setLocation(px, py);
    }

    public void windowToDrawingCoords(Point2D pt) {
        if (!this.appliedTransform2D && this.width != 0) {
            double px = (double)this.x + (pt.getX() - this.xmin) / (this.xmax - this.xmin) * (double)this.width;
            double py = (double)this.y + (this.ymax - pt.getY()) / (this.ymax - this.ymin) * (double)this.height;
            pt.setLocation(px, py);
        }
    }

    public double getPixelWidth() {
        if (this.width == 0) {
            return 1.0;
        }
        return this.pixelWidth;
    }

    public double getPixelHeight() {
        if (this.height == 0) {
            return 1.0;
        }
        return this.pixelHeight;
    }

    public float getDefaultStrokeSize() {
        if (this.width == 0) {
            return 1.0f;
        }
        return this.strokeWidth;
    }

    public boolean appliedTransform2D() {
        return this.appliedTransform2D;
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (listener != null && this.changeListeners != null) {
            this.changeListeners.remove(listener);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    protected synchronized void fireTransformChangeEvent() {
        if (this.changeListeners == null) {
            return;
        }
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).stateChanged(this.changeEvent);
        }
    }
}

