/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm3d.core.Animation;

public abstract class ThreadedAnimation
implements Animation {
    private Thread runner;
    private volatile boolean running;
    private volatile boolean canceled;
    private volatile boolean paused;
    volatile double timeDilation;
    private ChangeEvent changeEvent;
    private ArrayList<ChangeListener> changeListeners;

    protected abstract void runAnimation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pause(int milliseconds) throws AnimationCanceledException {
        ThreadedAnimation threadedAnimation;
        if (this.canceled) {
            throw new AnimationCanceledException();
        }
        int delay = (int)((double)milliseconds * this.timeDilation + 0.49);
        if (milliseconds > 0 && delay == 0) {
            delay = 1;
        }
        if (delay <= 0) {
            Thread.yield();
        } else {
            threadedAnimation = this;
            synchronized (threadedAnimation) {
                try {
                    this.wait(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.canceled) {
            throw new AnimationCanceledException();
        }
        if (this.paused) {
            threadedAnimation = this;
            synchronized (threadedAnimation) {
                while (this.paused && !this.canceled) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.canceled) {
                throw new AnimationCanceledException();
            }
        }
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.runner = new Thread(){

            @Override
            public void run() {
                ThreadedAnimation.this.doRun();
            }
        };
        this.runner.start();
        this.running = true;
        this.canceled = false;
        this.paused = false;
        this.fireAnimationChangeEvent();
    }

    @Override
    public synchronized void setPaused(boolean paused) {
        if (this.running) {
            this.paused = paused;
            this.notify();
        }
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public synchronized void cancel() {
        if (!this.running) {
            return;
        }
        this.canceled = true;
        this.notify();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    @Override
    public void setTimeDilation(double dilationFactor) {
        if (dilationFactor < 0.0) {
            dilationFactor = 0.0;
        }
        this.timeDilation = dilationFactor;
    }

    @Override
    public double getTimeDilation() {
        return this.timeDilation;
    }

    private void doRun() {
        try {
            this.runAnimation();
        }
        catch (AnimationCanceledException animationCanceledException) {
        }
        catch (Exception e) {
            System.out.println("Animation aborted by unexpected exception:  " + e);
            e.printStackTrace();
        }
        finally {
            this.doneRunning();
        }
    }

    private synchronized void doneRunning() {
        this.running = false;
        this.paused = false;
        this.runner = null;
        this.fireAnimationChangeEvent();
    }

    @Override
    public synchronized void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(listener);
    }

    @Override
    public synchronized void removeChangeListener(ChangeListener listener) {
        if (listener != null && this.changeListeners != null) {
            this.changeListeners.remove(listener);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    protected synchronized void fireAnimationChangeEvent() {
        if (this.changeListeners == null) {
            return;
        }
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).stateChanged(this.changeEvent);
        }
    }

    @Override
    public String getStatusText(boolean running) {
        return null;
    }

    protected class AnimationCanceledException
    extends RuntimeException {
        protected AnimationCanceledException() {
        }
    }
}

