/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import vmm3d.core.I18n;

public abstract class SettingsDialog
extends JDialog {
    protected JButton okButton;
    protected JButton defaultsButton;
    protected JButton cancelButton;
    protected JButton applyButton;
    protected boolean canceled;
    protected JPanel contentPanel;
    protected JPanel buttonBar;

    protected SettingsDialog(Component parent, String title) {
        this(parent, title, true, true);
    }

    protected SettingsDialog(Component parent, String title, boolean showDefaultsButton, boolean showApplyButton) {
        super(SettingsDialog.frameAncestor(parent), title, true);
        this.setDefaultCloseOperation(0);
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.buttonBar = new JPanel();
        this.buttonBar.setLayout(new FlowLayout(2, 7, 7));
        this.buttonBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.contentPanel.add((Component)this.buttonBar, "South");
        this.setContentPane(this.contentPanel);
        this.okButton = new JButton(I18n.tr("buttonNames.OK"));
        this.defaultsButton = new JButton(I18n.tr("buttonNames.Defaults"));
        this.cancelButton = new JButton(I18n.tr("buttonNames.Cancel"));
        this.applyButton = new JButton(I18n.tr("buttonNames.Apply"));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object src = evt.getSource();
                if (src == SettingsDialog.this.okButton) {
                    if (SettingsDialog.this.doOK()) {
                        SettingsDialog.this.canceled = false;
                        SettingsDialog.this.dispose();
                    }
                } else if (src == SettingsDialog.this.applyButton) {
                    SettingsDialog.this.doApply();
                } else if (src == SettingsDialog.this.defaultsButton) {
                    SettingsDialog.this.doDefaults();
                } else if (src == SettingsDialog.this.cancelButton) {
                    SettingsDialog.this.doCancel();
                }
            }
        };
        this.okButton.addActionListener(listener);
        this.defaultsButton.addActionListener(listener);
        this.cancelButton.addActionListener(listener);
        this.applyButton.addActionListener(listener);
        this.buttonBar.add(this.cancelButton);
        if (showDefaultsButton) {
            this.buttonBar.add(this.defaultsButton);
        }
        if (showApplyButton) {
            this.buttonBar.add(this.applyButton);
        }
        this.buttonBar.add(this.okButton);
        this.setDefaultCloseOperation(0);
        this.buttonBar.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "cancel");
        this.buttonBar.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "ok");
        this.buttonBar.getActionMap().put("cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.cancelButton.doClick();
            }
        });
        this.buttonBar.getActionMap().put("ok", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.okButton.doClick();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SettingsDialog.this.doCancel();
            }
        });
        JFrame parentFrame = SettingsDialog.frameAncestor(parent);
        if (parentFrame != null) {
            Point pt = parentFrame.getLocation();
            this.setLocation(pt.x + 25, pt.y + 45);
        }
        this.setResizable(false);
    }

    private static JFrame frameAncestor(Component c) {
        while (c != null && !(c instanceof JFrame)) {
            c = c.getParent();
        }
        return (JFrame)c;
    }

    protected void addInputPanel(JComponent inputPanel) {
        inputPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.contentPanel.add((Component)inputPanel, "Center");
        this.pack();
    }

    protected void addInfoLabel(String info) {
        JLabel infoLabel = new JLabel(info);
        infoLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.contentPanel.add((Component)infoLabel, "North");
        this.pack();
    }

    protected JButton defaultsButton() {
        return this.defaultsButton;
    }

    protected JPanel borderedPanel(String title) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), title), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        return panel;
    }

    protected void doDefaults() {
    }

    protected void doCancel() {
        this.canceled = true;
        this.dispose();
    }

    protected void doApply() {
        this.doOK();
    }

    protected abstract boolean doOK();
}

