/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import vmm3d.core.I18n;
import vmm3d.core.ParameterInput;
import vmm3d.core.RealParam;
import vmm3d.core.SettingsDialog;
import vmm3d.core.Transform;
import vmm3d.core.View;

public class SetXYWindowDialog
extends SettingsDialog {
    private RealParam xmin;
    private RealParam xmax;
    private RealParam ymin;
    private RealParam ymax;
    private ParameterInput xminInput;
    private ParameterInput xmaxInput;
    private ParameterInput yminInput;
    private ParameterInput ymaxInput;
    private View view;

    public static void showDialog(View view) {
        new SetXYWindowDialog(view).setVisible(true);
    }

    protected SetXYWindowDialog(View view) {
        super(view.getDisplay(), I18n.tr("vmm3d.core.dialogtitle.SetXYWindowDialog"), true, true);
        this.view = view;
        Transform transform = view.getTransform();
        this.xmin = new RealParam("vmm3d.core.dialogtitle.SetXYWindowDialog.xmin", transform.getXminRequested());
        this.xmax = new RealParam("vmm3d.core.dialogtitle.SetXYWindowDialog.xmax", transform.getXmaxRequested());
        this.ymin = new RealParam("vmm3d.core.dialogtitle.SetXYWindowDialog.ymin", transform.getYminRequested());
        this.ymax = new RealParam("vmm3d.core.dialogtitle.SetXYWindowDialog.ymax", transform.getYmaxRequested());
        this.xminInput = new ParameterInput(this.xmin);
        this.xmaxInput = new ParameterInput(this.xmax);
        this.yminInput = new ParameterInput(this.ymin);
        this.ymaxInput = new ParameterInput(this.ymax);
        this.xminInput.setColumns(7);
        this.xmaxInput.setColumns(7);
        this.yminInput.setColumns(7);
        this.ymaxInput.setColumns(7);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new GridLayout(2, 4, 5, 5));
        inputPanel.add(new JLabel(this.xmin.getTitle() + ": ", 4));
        inputPanel.add(this.xminInput);
        inputPanel.add(new JLabel(this.xmax.getTitle() + ": ", 4));
        inputPanel.add(this.xmaxInput);
        inputPanel.add(new JLabel(this.ymin.getTitle() + ": ", 4));
        inputPanel.add(this.yminInput);
        inputPanel.add(new JLabel(this.ymax.getTitle() + ": ", 4));
        inputPanel.add(this.ymaxInput);
        this.addInputPanel(inputPanel);
        this.addInfoLabel(I18n.tr("vmm3d.core.SetXYWindowDialog.info"));
    }

    @Override
    protected boolean doOK() {
        String error = this.xminInput.checkContents();
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, I18n.tr("vmm3d.core.SettingsDialog.errorTitle"), 0);
            this.xminInput.selectAll();
            this.xminInput.requestFocus();
            return false;
        }
        error = this.xmaxInput.checkContents();
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, I18n.tr("vmm3d.core.SettingsDialog.errorTitle"), 0);
            this.xmaxInput.selectAll();
            this.xmaxInput.requestFocus();
            return false;
        }
        error = this.yminInput.checkContents();
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, I18n.tr("vmm3d.core.SettingsDialog.errorTitle"), 0);
            this.yminInput.selectAll();
            this.yminInput.requestFocus();
            return false;
        }
        error = this.ymaxInput.checkContents();
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, I18n.tr("vmm3d.core.SettingsDialog.errorTitle"), 0);
            this.ymaxInput.selectAll();
            this.ymaxInput.requestFocus();
            return false;
        }
        this.xminInput.setValueFromContents();
        this.xmaxInput.setValueFromContents();
        this.yminInput.setValueFromContents();
        this.ymaxInput.setValueFromContents();
        if (this.xmin.getValue() >= this.xmax.getValue()) {
            JOptionPane.showMessageDialog(this, I18n.tr("vmm3d.core.SetXYWindowDialog.XmaxLessThanXminError"), I18n.tr("vmm3d.core.SettingsDialog.errorTitle"), 0);
            this.xminInput.selectAll();
            this.xminInput.requestFocus();
            return false;
        }
        if (this.ymin.getValue() >= this.ymax.getValue()) {
            JOptionPane.showMessageDialog(this, I18n.tr("vmm3d.core.SetXYWindowDialog.YmaxLessThanYminError"), I18n.tr("vmm3d.core.SettingsDialog.errorTitle"), 0);
            this.yminInput.selectAll();
            this.yminInput.requestFocus();
            return false;
        }
        this.view.getTransform().setLimits(this.xmin.getValue(), this.xmax.getValue(), this.ymin.getValue(), this.ymax.getValue());
        return true;
    }

    @Override
    protected void doDefaults() {
        double[] defaultWindow = this.view.getExhibit().getDefaultWindow();
        this.xminInput.setText("" + defaultWindow[0]);
        this.xmaxInput.setText("" + defaultWindow[1]);
        this.yminInput.setText("" + defaultWindow[2]);
        this.ymaxInput.setText("" + defaultWindow[3]);
    }
}

