/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import vmm3d.core.I18n;
import vmm3d.core.Parameter;
import vmm3d.core.Util;
import vmm3d.functions.Expression;
import vmm3d.functions.ParseError;

public class RealParam
extends Parameter {
    private double minimumValueForInput = Double.NEGATIVE_INFINITY;
    private double maximumValueForInput = Double.POSITIVE_INFINITY;

    public RealParam() {
        this((String)null, 0.0);
    }

    public RealParam(String name, double initialValue) {
        super(name, new Double(initialValue));
    }

    public RealParam(String name, String valueAsString) throws NumberFormatException {
        super(name, valueAsString);
    }

    public void reset(double value) {
        this.reset(new Double(value));
    }

    public void setValue(double val) {
        this.setValueObject(new Double(val));
    }

    public double getValue() {
        Double d = (Double)this.getValueObject();
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public void setDefaultValue(double val) {
        this.setDefaultValueObject(new Double(val));
    }

    public void setValueAndDefault(double val) {
        Double d = new Double(val);
        this.setValueObject(d);
        this.setDefaultValueObject(d);
    }

    public double getDefaultValue() {
        Double d = (Double)this.getDefaultValueObject();
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public double getMaximumValueForInput() {
        return this.maximumValueForInput;
    }

    public void setMaximumValueForInput(double maximumValueForInput) {
        this.maximumValueForInput = maximumValueForInput;
    }

    public double getMinimumValueForInput() {
        return this.minimumValueForInput;
    }

    public void setMinimumValueForInput(double minimumValueForInput) {
        this.minimumValueForInput = minimumValueForInput;
    }

    @Override
    protected Object stringToValueObject(String str) throws NumberFormatException {
        Expression exp;
        Double val = null;
        try {
            val = new Double(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (val != null) {
            if (val.isNaN() || val.isInfinite()) {
                throw new NumberFormatException(I18n.tr("vmm3d.core.RealParam.undefined", str));
            }
            return val;
        }
        try {
            exp = Util.parseConstantExpression(str);
        }
        catch (ParseError e) {
            if (str != null) {
                try {
                    return Util.externalStringToValue(str, Double.TYPE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new NumberFormatException(I18n.tr("vmm3d.core.RealParam.badExpression", str, e.getMessage()));
        }
        double d = exp.value();
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new NumberFormatException(I18n.tr("vmm3d.core.RealParam.undefined", str));
        }
        return new Double(d);
    }

    @Override
    protected String valueObjectToString(Object obj) {
        return Util.toExternalString((double)((Double)obj));
    }
}

