/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.Display;
import vmm3d.core.MouseTask;
import vmm3d.core.Transform;
import vmm3d.core.View;

public class BasicMouseTask2D
extends MouseTask {
    private int operation;
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private static final int ZOOM_RECT = 3;
    private int startx;
    private int starty;
    private int prevx;
    private int prevy;
    private double[] startWindow;
    private double requestedAspectRatio;
    private Rectangle scaleRect;
    private long mouseDownTime;
    private boolean startedDragging;
    private boolean saveFastDrawing;

    @Override
    public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
        this.operation = 0;
        if (view.getExhibit() == null) {
            return false;
        }
        this.startx = this.prevx = evt.getX();
        this.starty = this.prevy = evt.getY();
        this.startWindow = view.getWindow();
        Transform tr = view.getTransform();
        this.requestedAspectRatio = Math.abs((tr.getYmaxRequested() - tr.getYminRequested()) / (tr.getXmaxRequested() - tr.getXminRequested()));
        if (evt.isAltDown() || evt.isShiftDown()) {
            this.operation = 2;
        } else if (evt.isControlDown() || evt.isMetaDown()) {
            this.operation = 3;
            this.scaleRect = null;
        } else {
            this.operation = 1;
        }
        this.saveFastDrawing = view.getFastDrawing();
        this.mouseDownTime = evt.getWhen();
        this.startedDragging = false;
        return true;
    }

    @Override
    public void doMouseDrag(MouseEvent evt, Display display, View view, int width, int height) {
        if (!this.startedDragging && evt.getWhen() - this.mouseDownTime < 300L && Math.abs(evt.getX() - this.startx) < 3 && Math.abs(evt.getY() - this.starty) < 3) {
            return;
        }
        if (!this.startedDragging) {
            this.startedDragging = true;
            if (this.operation != 3) {
                view.setFastDrawing(true);
            }
        }
        if (this.operation == 1 && !evt.isControlDown() && !evt.isMetaDown()) {
            if (evt.isAltDown() || evt.isShiftDown()) {
                this.operation = 2;
                this.startx = evt.getX();
                this.starty = evt.getY();
                this.startWindow = view.getWindow();
                return;
            }
        } else if (this.operation == 2 && !evt.isAltDown() && !evt.isShiftDown()) {
            this.operation = 1;
            this.startx = evt.getX();
            this.starty = evt.getY();
            this.startWindow = view.getWindow();
            return;
        }
        switch (this.operation) {
            case 1: {
                double pixelWidth = Math.abs(this.startWindow[1] - this.startWindow[0]) / (double)width;
                double pixelHeight = Math.abs(this.startWindow[3] - this.startWindow[2]) / (double)height;
                double offsetX = (double)(this.startx - evt.getX()) * pixelWidth;
                double offsetY = (double)(-(this.starty - evt.getY())) * pixelHeight;
                this.newWindow(view, this.startWindow[0] + offsetX, this.startWindow[1] + offsetX, this.startWindow[2] + offsetY, this.startWindow[3] + offsetY);
                display.repaint();
                break;
            }
            case 2: {
                double diff = (double)(-(this.starty - evt.getY())) / 200.0;
                double mag = Math.exp(diff);
                double startx_real = this.startWindow[0] + (double)this.startx * ((this.startWindow[1] - this.startWindow[0]) / (double)width);
                double starty_real = this.startWindow[2] + (double)(height - this.starty) * ((this.startWindow[3] - this.startWindow[2]) / (double)height);
                double newwidth = (this.startWindow[1] - this.startWindow[0]) * mag;
                double newheight = (this.startWindow[3] - this.startWindow[2]) * mag;
                double newpixelwidth = newwidth / (double)width;
                double newpixelheight = newheight / (double)height;
                double newxmin = startx_real - newpixelwidth * (double)this.startx;
                double newxmax = newxmin + newwidth;
                double newymin = starty_real - newpixelheight * (double)(height - this.starty);
                double newymax = newymin + newheight;
                this.newWindow(view, newxmin, newxmax, newymin, newymax);
                display.repaint();
                break;
            }
            case 3: {
                if (evt.isShiftDown()) {
                    if (this.scaleRect != null) {
                        int movex = evt.getX() - this.prevx;
                        int movey = evt.getY() - this.prevy;
                        this.startx += movex;
                        this.starty += movey;
                        this.prevx = evt.getX();
                        this.prevy = evt.getY();
                        this.scaleRect.translate(movex, movey);
                    }
                } else {
                    this.prevx = evt.getX();
                    this.prevy = evt.getY();
                    if (this.prevx < 0) {
                        this.prevx = 0;
                    } else if (this.prevx >= width) {
                        this.prevx = width - 1;
                    }
                    if (this.prevy < 0) {
                        this.prevy = 0;
                    } else if (this.prevy >= height) {
                        this.prevy = height - 1;
                    }
                    if (Math.abs(this.prevx - this.startx) < 3 || Math.abs(this.prevy - this.starty) < 3) {
                        this.scaleRect = null;
                    } else {
                        if (this.scaleRect == null) {
                            this.scaleRect = new Rectangle();
                        }
                        this.scaleRect.setBounds(this.startx, this.starty, 0, 0);
                        if (view.getPreserveAspect()) {
                            int h;
                            double aspect = (double)width / (double)height;
                            int w = Math.abs(this.prevx - this.startx);
                            double rectAspect = (double)w / (double)(h = Math.abs(this.prevy - this.starty));
                            if (aspect > rectAspect) {
                                w = (int)((double)w * aspect / rectAspect + 0.499);
                            } else if (aspect < rectAspect) {
                                h = (int)((double)h * rectAspect / aspect + 0.499);
                            }
                            this.scaleRect.add(this.prevx > this.startx ? this.startx + w : this.startx - w, this.prevy > this.starty ? this.starty + h : this.starty - h);
                        } else {
                            this.scaleRect.add(this.prevx, this.prevy);
                        }
                    }
                }
                display.repaint();
            }
        }
    }

    private void newWindow(View view, double xmin, double xmax, double ymin, double ymax) {
        double aspect = Math.abs((ymax - ymin) / (xmax - xmin));
        if (aspect > this.requestedAspectRatio) {
            double shrinkFactor = this.requestedAspectRatio / aspect;
            double newHeight = (ymax - ymin) * shrinkFactor;
            double middle = (ymax + ymin) / 2.0;
            ymin = middle - newHeight / 2.0;
            ymax = middle + newHeight / 2.0;
        } else {
            double shrinkFactor = aspect / this.requestedAspectRatio;
            double newWidth = (xmax - xmin) * shrinkFactor;
            double middle = (xmax + xmin) / 2.0;
            xmin = middle - newWidth / 2.0;
            xmax = middle + newWidth / 2.0;
        }
        view.setWindow(xmin, xmax, ymin, ymax);
    }

    @Override
    public void doMouseUp(MouseEvent evt, Display display, View view, int width, int height) {
        if (!this.startedDragging) {
            return;
        }
        if (this.operation == 3 && this.scaleRect != null) {
            double pixelWidth = (this.startWindow[1] - this.startWindow[0]) / (double)width;
            double pixelHeight = (this.startWindow[3] - this.startWindow[2]) / (double)height;
            double newxmin = this.startWindow[0] + (double)this.scaleRect.x * pixelWidth;
            double newxmax = newxmin + (double)this.scaleRect.width * pixelWidth;
            double newymax = this.startWindow[3] - (double)this.scaleRect.y * pixelHeight;
            double newymin = newymax - (double)this.scaleRect.height * pixelHeight;
            this.newWindow(view, newxmin, newxmax, newymin, newymax);
            display.repaint();
        }
        view.setFastDrawing(this.saveFastDrawing);
    }

    @Override
    public Cursor getCursorForDragging(MouseEvent mouseDownEvent, Display display, View view) {
        if (this.operation == 3) {
            return Cursor.getPredefinedCursor(1);
        }
        if (this.operation == 1) {
            return Cursor.getPredefinedCursor(13);
        }
        if (this.operation == 2) {
            return Cursor.getPredefinedCursor(9);
        }
        return null;
    }

    @Override
    public void drawWhileDragging(VectorGraphics g, Display display, View view, int width, int height) {
        if (this.operation != 3 || this.scaleRect == null) {
            return;
        }
        if (Math.abs(this.startx - this.prevx) < 3 || Math.abs(this.starty - this.prevy) < 3) {
            return;
        }
        g.setColor(Color.WHITE);
        g.drawRect(this.scaleRect.x - 1, this.scaleRect.y - 1, this.scaleRect.width + 2, this.scaleRect.height + 2);
        g.drawRect(this.scaleRect.x + 1, this.scaleRect.y + 1, this.scaleRect.width - 2, this.scaleRect.height - 2);
        g.setColor(Color.BLACK);
        g.drawRect(this.scaleRect.x, this.scaleRect.y, this.scaleRect.width, this.scaleRect.height);
    }
}

