/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import java.awt.Color;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.core.Decoration;
import vmm3d.core.Transform;
import vmm3d.core.VMMSave;
import vmm3d.core.View;

public class Axes2D
extends Decoration {
    @VMMSave
    private Color color = Color.gray;

    public Axes2D() {
        this.setLayer(-100);
    }

    public void setColor(Color c) {
        this.color = c == null ? Color.gray : c;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void doDraw(VectorGraphics g, View view, Transform transform) {
        Color saveColor = g.getColor();
        g.setColor(this.color);
        if (this.between(0.0, transform.getYmin(), transform.getYmax())) {
            view.drawLine(transform.getXmin(), 0.0, transform.getXmax(), 0.0);
        }
        if (this.between(0.0, transform.getXmin(), transform.getYmax())) {
            view.drawLine(0.0, transform.getYmax(), 0.0, transform.getYmin());
        }
        g.setColor(saveColor);
    }

    private boolean between(double x, double x1, double x2) {
        if (x <= x1 && x >= x2) {
            return true;
        }
        return x >= x1 && x <= x2;
    }
}

