/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import vmm3d.core.Animateable;
import vmm3d.core.BasicAnimator;
import vmm3d.core.Display;
import vmm3d.core.Exhibit;
import vmm3d.core.I18n;
import vmm3d.core.Parameter;
import vmm3d.core.ParameterInput;
import vmm3d.core.SettingsDialog;
import vmm3d.core.View;

public class AnimationLimitsDialog
extends SettingsDialog {
    private Parameter[] parameters;
    private ParameterInput[][] inputBoxes;

    public static boolean showDialog(Component parentComponent, String title, Parameter[] params) {
        boolean animated = false;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof Animateable)) continue;
                animated = true;
                break;
            }
        }
        if (!animated) {
            JOptionPane.showMessageDialog(parentComponent, I18n.tr("vmm3d.core.AnimationLimitsDialog.noMorphing"));
            return false;
        }
        AnimationLimitsDialog dialog = new AnimationLimitsDialog(parentComponent, title, params);
        dialog.setVisible(true);
        return !dialog.canceled;
    }

    public AnimationLimitsDialog(Component parentComponent, String title, Parameter[] params) {
        super(parentComponent, title, true, false);
        if (parentComponent != null && parentComponent instanceof Display) {
            final Display display = (Display)parentComponent;
            AbstractAction morph = new AbstractAction(I18n.tr("vmm3d.core.AnimatinonLimitsDialog.MorphButtonName")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!AnimationLimitsDialog.this.doOK()) {
                        return;
                    }
                    View view = display.getView();
                    if (view == null) {
                        return;
                    }
                    Exhibit exhibit = view.getExhibit();
                    if (exhibit == null) {
                        return;
                    }
                    BasicAnimator morphAnim = exhibit.getMorphingAnimation(view, 2);
                    if (morphAnim != null) {
                        AnimationLimitsDialog.this.canceled = false;
                        AnimationLimitsDialog.this.dispose();
                        display.installAnimation(morphAnim);
                    }
                }
            };
            this.buttonBar.add((Component)new JButton(morph), 2);
        }
        int animatedCount = 0;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof Animateable)) continue;
                ++animatedCount;
            }
        }
        if (animatedCount == params.length) {
            this.parameters = params;
        } else {
            this.parameters = new Parameter[animatedCount];
            int pos = 0;
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof Animateable)) continue;
                this.parameters[pos++] = params[i];
            }
        }
        JPanel topPanel = new JPanel();
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        topPanel.setLayout(new GridLayout(1, 0, 5, 5));
        topPanel.add(new JLabel(I18n.tr("vmm3d.core.ParameterDialog.ParameterName"), 0));
        topPanel.add(new JLabel(I18n.tr("vmm3d.core.ParameterDialog.AnimationStartValue"), 0));
        topPanel.add(new JLabel(I18n.tr("vmm3d.core.ParameterDialog.AnimationEndValue"), 0));
        JPanel inputPanel = new JPanel();
        inputPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.inputBoxes = new ParameterInput[this.parameters.length][2];
        inputPanel.setLayout(new GridLayout(0, 3, 5, 5));
        for (int i = 0; i < this.parameters.length; ++i) {
            JLabel label = new JLabel(this.parameters[i].getTitle(), 0);
            String tip = this.parameters[i].getHint();
            if (tip != null) {
                label.setToolTipText(tip);
            }
            inputPanel.add(label);
            this.inputBoxes[i][0] = this.parameters[i].createParameterInput(1);
            inputPanel.add(this.inputBoxes[i][0]);
            this.inputBoxes[i][0].setMargin(new Insets(3, 3, 3, 3));
            this.inputBoxes[i][1] = this.parameters[i].createParameterInput(2);
            inputPanel.add(this.inputBoxes[i][1]);
            this.inputBoxes[i][1].setMargin(new Insets(3, 3, 3, 3));
        }
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)inputPanel, "Center");
        p.add((Component)topPanel, "North");
        this.addInputPanel(p);
        this.setResizable(false);
    }

    @Override
    protected boolean doOK() {
        int i;
        for (i = 0; i < this.parameters.length; ++i) {
            String error = this.inputBoxes[i][0].checkContents();
            if (error != null) {
                this.errorMessage(error);
                return false;
            }
            error = this.inputBoxes[i][1].checkContents();
            if (error == null) continue;
            this.errorMessage(error);
            return false;
        }
        for (i = 0; i < this.parameters.length; ++i) {
            this.inputBoxes[i][0].setValueFromContents();
            this.inputBoxes[i][1].setValueFromContents();
        }
        return true;
    }

    private void errorMessage(String message) {
        JOptionPane.showMessageDialog(this, message, I18n.tr("vmm3d.core.ParameterDialog.errorTitle"), 0);
    }

    @Override
    protected void doDefaults() {
        for (int i = 0; i < this.parameters.length; ++i) {
            this.inputBoxes[i][0].defaultVal();
            this.inputBoxes[i][1].defaultVal();
        }
    }
}

