/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.conformalmap;

import java.awt.Shape;
import java.awt.geom.Line2D;
import org.freehep.graphics2d.VectorGraphics;
import vmm3d.conformalmap.ConformalMap;
import vmm3d.core.Complex;
import vmm3d.core.ComplexODE;
import vmm3d.core.ComplexParamAnimateable;
import vmm3d.core3D.Transform3D;
import vmm3d.core3D.View3D;

public class Weierstrass_p
extends ConformalMap {
    private ComplexParamAnimateable branch = new ComplexParamAnimateable("vmm3d.conformalmap.Weierstrass_p.branchPoint", "0.8 + 0.6*i", "0.8", "0.8 + i");
    private final Complex zero = new Complex(Complex.ZERO_C);
    private final Complex one = new Complex(Complex.ONE_C);
    private final Complex iC = new Complex(Complex.I_C);
    private ComplexODE myODE = new ComplexODE(this.zero, this.one.times(2.0), this.zero, this.one.times(-2.0), this.zero);
    private Complex branchP = this.branch.getValue();
    private Complex approxInitDeriv = new Complex(this.one.plus(this.iC));
    private Complex period1 = new Complex(1.0, 0.0);
    private Complex period2 = new Complex(0.0, 1.0);
    private Complex periodAverage = new Complex(0.5, 0.5);
    private boolean needsInvers = false;
    private double detPeriod = 1.0;
    private Complex localArg = new Complex(1.0, 0.0);
    private Complex localVal = new Complex(1.0, 0.0);
    private Complex[][] argumentGridPart2;
    private Complex[][] ValueGridPart2;

    public Weierstrass_p() {
        this.addParameter(this.branch);
        this.umin.reset(-1.0);
        this.umax.reset(1.0);
        this.vmin.reset(0.0);
        this.vmax.reset(0.5);
        this.removeParameter(this.umin);
        this.removeParameter(this.umax);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.vres.setValueAndDefault(8);
        this.ures.setValueAndDefault(4 * this.vres.getDefaultValue());
        this.setDefaultWindow2D(-5.0, 5.0, -4.0, 4.0);
        this.gridTypeSelect.setEnabled(false);
        this.setFramesForMorphing(20);
        this.setUseFilmstripForMorphing(true);
    }

    @Override
    protected void computeDrawData3D(View3D view, boolean exhibitNeedsRedraw, Transform3D previousTransform3D, Transform3D newTransform3D) {
        if (exhibitNeedsRedraw) {
            int j;
            int i;
            this.branchP = this.branch.getValue();
            this.myODE.setPoly(this.zero, this.one, this.branchP.minus(this.branchP.inverse()), this.one.times(-1.0), this.zero);
            this.period1 = this.ComputeFirstPeriod();
            this.period2 = this.ComputeSecondPeriod();
            this.periodAverage = this.period1.plus(this.period2).times(0.5);
            this.detPeriod = this.period1.det(this.period2);
            Complex[] val = new Complex[2];
            Complex storedDerivative = new Complex(this.one.plus(this.iC));
            int uCount = this.ures.getValue() * 4;
            int vCount = this.vres.getValue() * 4;
            this.valueGrid = new Complex[uCount + 1][vCount + 1];
            this.argumentGrid = new Complex[uCount + 1][vCount + 1];
            double uStart = this.umin.getValue();
            double vStart = this.vmin.getValue();
            double uEnd = this.umax.getValue();
            double vEnd = this.vmax.getValue();
            double du = (uEnd - uStart) / (double)uCount;
            double dv = (vEnd - vStart) / (double)vCount;
            for (i = 0; i <= uCount; ++i) {
                for (j = 0; j <= vCount; ++j) {
                    this.argumentGrid[i][j] = this.gridMap(uStart + (double)i * du, vStart + (double)j * dv);
                }
            }
            for (i = 0; i <= uCount; ++i) {
                val = i == 0 ? this.myODE.ODEstep4(this.periodAverage, this.argumentGrid[0][0], this.iC, this.one.plus(this.iC), 24) : this.myODE.ODEstep4(this.argumentGrid[i - 1][0], this.argumentGrid[i][0], this.valueGrid[i - 1][0], storedDerivative, 16);
                this.valueGrid[i][0] = val[0];
                storedDerivative = val[1];
                for (j = 1; j <= vCount; ++j) {
                    val = this.myODE.ODEstep4(this.argumentGrid[i][j - 1], this.argumentGrid[i][j], val[0], val[1], 16);
                    this.valueGrid[i][j] = val[0];
                }
            }
            this.argumentGridPart2 = new Complex[uCount + 1][vCount + 1];
            this.ValueGridPart2 = new Complex[uCount + 1][vCount + 1];
            for (i = 0; i <= uCount; ++i) {
                for (j = 0; j <= vCount; ++j) {
                    this.argumentGridPart2[i][j] = this.argumentGrid[i][j];
                    this.argumentGrid[i][j] = this.argumentGrid[i][j].times(-1.0).plus(this.period2);
                    this.ValueGridPart2[i][j] = this.valueGrid[i][j];
                    this.valueGrid[i][j] = this.valueGrid[i][j].inverse().times(-1.0);
                }
            }
        }
    }

    @Override
    protected void doDraw3D(VectorGraphics g, View3D view, Transform3D transform) {
        boolean savedColor = ((ConformalMap.ConformalMapView)view).getUseColor();
        ((ConformalMap.ConformalMapView)view).setUseColor(false);
        super.doDraw3D(g, view, transform);
        if (!((ConformalMap.ConformalMapView)view).getDrawValueGrid()) {
            int n = 7;
            for (int i = -n; i <= n; i += 2) {
                g.draw((Shape)new Line2D.Double((double)(-n) * this.period1.re - (double)i * this.period2.re, (double)(-n) * this.period1.im - (double)i * this.period2.im, (double)n * this.period1.re - (double)i * this.period2.re, (double)n * this.period1.im - (double)i * this.period2.im));
                g.draw((Shape)new Line2D.Double((double)i * this.period1.re - (double)n * this.period2.re, (double)i * this.period1.im - (double)n * this.period2.im, (double)i * this.period1.re + (double)n * this.period2.re, (double)i * this.period1.im + (double)n * this.period2.im));
            }
        }
        Complex[][] temp = this.argumentGrid;
        this.argumentGrid = this.argumentGridPart2;
        this.argumentGridPart2 = temp;
        temp = this.valueGrid;
        this.valueGrid = this.ValueGridPart2;
        this.ValueGridPart2 = temp;
        ((ConformalMap.ConformalMapView)view).setUseColor(savedColor);
        super.doDraw3D(g, view, transform);
        temp = this.argumentGrid;
        this.argumentGrid = this.argumentGridPart2;
        this.argumentGridPart2 = temp;
        temp = this.valueGrid;
        this.valueGrid = this.ValueGridPart2;
        this.ValueGridPart2 = temp;
    }

    private Complex ComputeFirstPeriod() {
        Complex[] w = new Complex[2];
        Complex middle = this.branchP.inverse();
        middle.assignTimes(-0.5);
        w = this.myODE.ComplexMultiStepIntegrator(this.iC, middle, this.zero, this.approxInitDeriv, 32.0);
        w = this.myODE.ComplexMultiStepIntegrator(middle, this.iC.times(-1.0), w[1], w[0], 32.0);
        w[1].assignTimes(-1.0);
        return w[1];
    }

    private Complex ComputeSecondPeriod() {
        Complex[] w = new Complex[2];
        w = this.myODE.ComplexMultiStepIntegrator(this.iC, this.branchP.times(0.5), this.zero, this.approxInitDeriv, 32.0);
        w = this.myODE.ComplexMultiStepIntegrator(this.branchP.times(0.5), this.iC.times(-1.0), w[1], w[0], 32.0);
        w[1].assignTimes(-1.0);
        return w[1];
    }

    @Override
    protected Complex gridMap(double u, double v) {
        return new Complex(u * this.period1.re + v * this.period2.re, u * this.period1.im + v * this.period2.im);
    }

    private Complex reduceModPeriods(Complex argument) {
        double uComp = argument.det(this.period2) / this.detPeriod;
        double vComp = this.period1.det(argument) / this.detPeriod;
        if (uComp > 1.0) {
            uComp -= 2.0 * Math.floor((1.0 + uComp) / 2.0);
        } else if (uComp < -1.0) {
            uComp -= 2.0 * Math.floor((1.0 + uComp) / 2.0);
        }
        if (vComp > 1.0) {
            vComp -= 2.0 * Math.floor((1.0 + vComp) / 2.0);
        } else if (vComp < -1.0) {
            vComp -= 2.0 * Math.floor((1.0 + vComp) / 2.0);
        }
        Complex w = new Complex(uComp * this.period1.re + vComp * this.period2.re, uComp * this.period1.im + vComp * this.period2.im);
        if (vComp > 0.5) {
            this.needsInvers = true;
            w.re = -w.re + this.period1.re + this.period2.re;
            w.im = -w.im + this.period1.im + this.period2.im;
        } else if (vComp < -0.5) {
            this.needsInvers = true;
            w.re = -w.re + this.period1.re - this.period2.re;
            w.im = -w.im + this.period1.im - this.period2.im;
        }
        return w;
    }

    @Override
    protected Complex function(Complex argument) {
        this.needsInvers = false;
        this.localArg = this.reduceModPeriods(argument);
        this.localVal = this.myODE.ODEstep4(this.periodAverage, this.localArg, this.iC, this.one.plus(this.iC), 16)[0];
        if (this.needsInvers) {
            this.localVal.assignInvert();
            this.localVal.assignTimes(-1.0);
        }
        return this.localVal;
    }
}

