/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.CC;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.StoreCached;
import org.mapdb.StoreDirect;
import org.mapdb.Volume;

public class StoreWAL
extends StoreCached {
    protected static final int WAL_STORE_VERSION = 100;
    protected static final int WAL_HEADER = -1971912604;
    protected static final long WAL_SEAL = 8234892392398238983L;
    protected static final int FULL_REPLAY_AFTER_N_TX = 16;
    protected final Store.LongLongMap[] prevLongLongs;
    protected final Store.LongLongMap[] currLongLongs;
    protected final Store.LongLongMap[] prevDataLongs;
    protected final Store.LongLongMap[] currDataLongs;
    protected final Store.LongLongMap pageLongStack = new Store.LongLongMap();
    protected final List<Volume> volumes = Collections.synchronizedList(new ArrayList());
    protected volatile Volume walC;
    protected volatile Volume walCCompact;
    protected final List<Volume> walRec = Collections.synchronizedList(new ArrayList());
    protected final ReentrantLock compactLock = new ReentrantLock(false);
    protected volatile boolean compactionInProgress = false;
    protected Volume curVol;
    protected int fileNum = -1;
    protected final AtomicLong walOffset = new AtomicLong();
    protected Volume headVolBackup;
    protected long[] indexPagesBackup;
    protected Volume realVol;
    protected volatile boolean $_TEST_HACK_COMPACT_PRE_COMMIT_WAIT = false;
    protected volatile boolean $_TEST_HACK_COMPACT_POST_COMMIT_WAIT = false;

    public StoreWAL(String fileName) {
        this(fileName, fileName == null ? CC.DEFAULT_MEMORY_VOLUME_FACTORY : CC.DEFAULT_FILE_VOLUME_FACTORY, null, 16, 0, false, false, null, false, false, false, null, null, 0L, 0L, false, 0L, 0);
    }

    public StoreWAL(String fileName, Volume.VolumeFactory volumeFactory, Store.Cache cache, int lockScale, int lockingStrategy, boolean checksum, boolean compress, byte[] password, boolean readonly, boolean snapshotEnable, boolean fileLockDisable, DataIO.HeartbeatFileLock fileLockHeartbeat, ScheduledExecutorService executor, long startSize, long sizeIncrement, boolean recidReuseDisable, long executorScheduledRate, int writeQueueSize) {
        super(fileName, volumeFactory, cache, lockScale, lockingStrategy, checksum, compress, password, readonly, snapshotEnable, fileLockDisable, fileLockHeartbeat, executor, startSize, sizeIncrement, recidReuseDisable, executorScheduledRate, writeQueueSize);
        int i;
        this.prevLongLongs = new Store.LongLongMap[this.lockScale];
        this.currLongLongs = new Store.LongLongMap[this.lockScale];
        for (i = 0; i < this.prevLongLongs.length; ++i) {
            this.prevLongLongs[i] = new Store.LongLongMap();
            this.currLongLongs[i] = new Store.LongLongMap();
        }
        this.prevDataLongs = new Store.LongLongMap[this.lockScale];
        this.currDataLongs = new Store.LongLongMap[this.lockScale];
        for (i = 0; i < this.prevDataLongs.length; ++i) {
            this.prevDataLongs[i] = new Store.LongLongMap();
            this.currDataLongs[i] = new Store.LongLongMap();
        }
    }

    @Override
    protected void initCreate() {
        super.initCreate();
        this.indexPagesBackup = (long[])this.indexPages.clone();
        this.realVol = this.vol;
        this.vol = new Volume.ReadOnly(this.vol);
        this.walStartNextFile();
    }

    @Override
    public void initOpen() {
        boolean walCompSealExists;
        this.realVol = this.vol;
        String wal0Name = this.getWalFileName("0");
        String walCompSeal = this.getWalFileName("c");
        boolean bl = walCompSealExists = walCompSeal != null && new File(walCompSeal).exists();
        if (walCompSealExists || wal0Name != null && new File(wal0Name).exists()) {
            String wname;
            String rname;
            this.walC = walCompSealExists ? this.volumeFactory.makeVolume(walCompSeal, this.readonly, true) : null;
            this.walCCompact = walCompSealExists ? this.volumeFactory.makeVolume(walCompSeal + ".compact", this.readonly, true) : null;
            int i = 0;
            while (new File(rname = this.getWalFileName("r" + i)).exists()) {
                this.walRec.add(this.volumeFactory.makeVolume(rname, this.readonly, true));
                ++i;
            }
            i = 0;
            while (new File(wname = this.getWalFileName("" + i)).exists()) {
                this.volumes.add(this.volumeFactory.makeVolume(wname, this.readonly, true));
                ++i;
            }
            this.initOpenPost();
            this.replayWAL();
            if (this.walC != null) {
                this.walC.close();
            }
            this.walC = null;
            if (this.walCCompact != null) {
                this.walCCompact.close();
            }
            this.walCCompact = null;
            for (Volume v : this.walRec) {
                v.close();
            }
            this.walRec.clear();
            this.volumes.clear();
        }
        this.walStartNextFile();
        this.initOpenPost();
    }

    @Override
    protected void initFailedCloseFiles() {
        if (this.walC != null && !this.walC.isClosed()) {
            this.walC.close();
        }
        this.walC = null;
        if (this.walCCompact != null && !this.walCCompact.isClosed()) {
            this.walCCompact.close();
        }
        this.walCCompact = null;
        if (this.walRec != null) {
            for (Volume v : this.walRec) {
                if (v == null || v.isClosed()) continue;
                v.close();
            }
            this.walRec.clear();
        }
        if (this.volumes != null) {
            for (Volume v : this.volumes) {
                if (v == null || v.isClosed()) continue;
                v.close();
            }
            this.volumes.clear();
        }
    }

    protected void initOpenPost() {
        super.initOpen();
        this.indexPagesBackup = (long[])this.indexPages.clone();
        this.vol = new Volume.ReadOnly(this.vol);
    }

    @Override
    protected void initHeadVol() {
        super.initHeadVol();
        if (this.headVolBackup != null && !this.headVolBackup.isClosed()) {
            this.headVolBackup.close();
        }
        byte[] b = new byte[32856];
        this.headVol.getData(0L, b, 0, b.length);
        this.headVolBackup = new Volume.SingleByteArrayVol(b);
    }

    protected void walStartNextFile() {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        ++this.fileNum;
        if (this.fileNum != this.volumes.size()) {
            throw new DBException.DataCorruption();
        }
        String filewal = this.getWalFileName("" + this.fileNum);
        Volume nextVol = this.readonly && filewal != null && !new File(filewal).exists() ? new Volume.ReadOnly(new Volume.ByteArrayVol(8, 0L)) : this.volumeFactory.makeVolume(filewal, this.readonly, true);
        nextVol.ensureAvailable(16L);
        if (!this.readonly) {
            nextVol.putInt(0L, -1971912604);
            nextVol.putLong(8L, this.makeFeaturesBitmap());
        }
        this.walOffset.set(16L);
        this.volumes.add(nextVol);
        this.curVol = nextVol;
    }

    protected String getWalFileName(String ext) {
        return this.fileName == null ? null : this.fileName + ".wal" + "." + ext;
    }

    protected void walPutLong(long offset, long value) {
        int plusSize = 15;
        long walOffset2 = this.walOffset.getAndAdd(15L);
        Volume curVol2 = this.curVol;
        if (this.hadToSkip(walOffset2, 15)) {
            this.walPutLong(offset, value);
            return;
        }
        if (offset >>> 48 != 0L) {
            throw new DBException.DataCorruption();
        }
        curVol2.ensureAvailable(walOffset2 + 15L);
        int parity = 1 + Long.bitCount(value) + Long.bitCount(offset);
        curVol2.putUnsignedByte(walOffset2, 0x10 | (parity &= 0xF));
        curVol2.putLong(++walOffset2, value);
        curVol2.putSixLong(walOffset2 += 8L, offset);
    }

    protected void walPutUnsignedShort(long offset, int value) {
        int plusSize = 9;
        long walOffset2 = this.walOffset.getAndAdd(9L);
        Volume curVol2 = this.curVol;
        if (this.hadToSkip(walOffset2, 9)) {
            this.walPutUnsignedShort(offset, value);
            return;
        }
        curVol2.ensureAvailable(walOffset2 + 9L);
        if (offset >>> 48 != 0L) {
            throw new DBException.DataCorruption();
        }
        offset = (long)value << 48 | offset;
        int parity = 1 + Long.bitCount(offset);
        curVol2.putUnsignedByte(walOffset2, 0x60 | (parity &= 0xF));
        curVol2.putLong(++walOffset2, offset);
    }

    protected boolean hadToSkip(long walOffset2, int plusSize) {
        if (walOffset2 >>> 20 == walOffset2 + (long)plusSize >>> 20) {
            return false;
        }
        while ((walOffset2 & 0xFFFFFL) >= 1048572L || plusSize < 5) {
            int singleByteSkip = 0x40 | Long.bitCount(walOffset2) & 0xF;
            this.curVol.putUnsignedByte(walOffset2++, singleByteSkip);
            if (--plusSize >= 0) continue;
            throw new DBException.DataCorruption();
        }
        int val = 0x30000000 | plusSize - 4 | (Integer.bitCount(plusSize - 4) & 0xF) << 24;
        this.curVol.ensureAvailable(walOffset2 + 4L);
        this.curVol.putInt(walOffset2, val);
        return true;
    }

    @Override
    protected void putDataSingleWithLink(int segment, long offset, long link, byte[] buf, int bufPos, int size) {
        if ((size & 0xFFFF) != size) {
            throw new DBException.DataCorruption();
        }
        byte[] buf2 = new byte[size + 8];
        DataIO.putLong(buf2, 0, link);
        System.arraycopy(buf, bufPos, buf2, 8, size);
        this.putDataSingleWithoutLink(segment, offset, buf2, 0, buf2.length);
    }

    @Override
    protected void putDataSingleWithoutLink(int segment, long offset, byte[] buf, int bufPos, int size) {
        if ((size & 0xFFFF) != size) {
            throw new DBException.DataCorruption();
        }
        if (offset % 16L != 0L && offset != 4L) {
            throw new DBException.DataCorruption();
        }
        if (segment != -1) {
            this.assertWriteLocked(segment);
        }
        if (segment == -1 && !this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        int plusSize = 9 + size;
        long walOffset2 = this.walOffset.getAndAdd(plusSize);
        if (this.hadToSkip(walOffset2, plusSize)) {
            this.putDataSingleWithoutLink(segment, offset, buf, bufPos, size);
            return;
        }
        this.curVol.ensureAvailable(walOffset2 + (long)plusSize);
        int checksum = 1 + Integer.bitCount(size) + Long.bitCount(offset) + this.sum(buf, bufPos, size);
        this.curVol.putUnsignedByte(walOffset2, 0x20 | (checksum &= 0xF));
        this.curVol.putLong(++walOffset2, (long)size << 48 | offset);
        this.curVol.putData(walOffset2 += 8L, buf, bufPos, size);
        long val = (long)size << 48;
        val |= (long)this.fileNum << 32;
        (segment == -1 ? this.pageLongStack : this.currDataLongs[segment]).put(offset, val |= walOffset2);
    }

    protected DataInput walGetData(long offset, int segment) {
        if (offset % 16L != 0L) {
            throw new DBException.DataCorruption();
        }
        long longval = this.currDataLongs[segment].get(offset);
        if (longval == 0L) {
            longval = this.prevDataLongs[segment].get(offset);
        }
        if (longval == 0L) {
            return null;
        }
        int arraySize = (int)(longval >>> 48);
        int fileNum = (int)(longval >>> 32 & 0xFFFFL);
        long dataOffset = longval & 0xFFFFFFFFL;
        Volume vol = this.volumes.get(fileNum);
        return vol.getDataInput(dataOffset, arraySize);
    }

    @Override
    protected long indexValGet(long recid) {
        this.assertReadLocked(recid);
        int segment = this.lockPos(recid);
        long offset = this.recidToOffset(recid);
        long ret = this.currLongLongs[segment].get(offset);
        if (ret != 0L) {
            return ret;
        }
        ret = this.prevLongLongs[segment].get(offset);
        if (ret != 0L) {
            return ret;
        }
        return super.indexValGet(recid);
    }

    @Override
    protected long indexValGetRaw(long recid) {
        this.assertReadLocked(recid);
        int segment = this.lockPos(recid);
        long offset = this.recidToOffset(recid);
        long ret = this.currLongLongs[segment].get(offset);
        if (ret != 0L) {
            return ret;
        }
        ret = this.prevLongLongs[segment].get(offset);
        if (ret != 0L) {
            return ret;
        }
        return super.indexValGetRaw(recid);
    }

    @Override
    protected void indexValPut(long recid, int size, long offset, boolean linked, boolean unused) {
        this.assertWriteLocked(this.lockPos(recid));
        long newVal = StoreWAL.composeIndexVal(size, offset, linked, unused, true);
        this.currLongLongs[this.lockPos(recid)].put(this.recidToOffset(recid), newVal);
    }

    @Override
    protected void indexLongPut(long offset, long val) {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        if (this.compactionInProgress) {
            throw new AssertionError();
        }
        this.walPutLong(offset, val);
    }

    @Override
    protected long pageAllocate() {
        long storeSize = DataIO.parity16Get(this.headVol.getLong(16L));
        this.headVol.putLong(16L, DataIO.parity16Set(storeSize + 0x100000L));
        if (storeSize % 0x100000L != 0L) {
            throw new DBException.DataCorruption();
        }
        return storeSize;
    }

    @Override
    protected byte[] loadLongStackPage(long pageOffset, boolean willBeModified) {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        byte[] page = (byte[])this.dirtyStackPages.get(pageOffset);
        if (page != null) {
            return page;
        }
        long walval = this.pageLongStack.get(pageOffset);
        if (walval != 0L) {
            int arraySize = (int)(walval >>> 48);
            int fileNum = (int)(walval >>> 32 & 0xFFFFL);
            long dataOffset = walval & 0xFFFFFFFFL;
            byte[] b = new byte[arraySize];
            Volume vol = this.volumes.get(fileNum);
            vol.getData(dataOffset, b, 0, arraySize);
            if (willBeModified) {
                this.dirtyStackPages.put(pageOffset, b);
            }
            return b;
        }
        int pageSize = (int)(DataIO.parity4Get(this.vol.getLong(pageOffset)) >>> 48);
        page = new byte[pageSize];
        this.vol.getData(pageOffset, page, 0, pageSize);
        if (willBeModified) {
            this.dirtyStackPages.put(pageOffset, page);
        }
        return page;
    }

    @Override
    protected long[] offsetsGet(int segment, long indexVal) {
        if (indexVal >>> 48 == 0L) {
            return (indexVal & 8L) != 0L ? null : StoreDirect.EMPTY_LONGS;
        }
        long[] ret = new long[]{indexVal};
        while ((ret[ret.length - 1] & 8L) != 0L) {
            long oldLink = (ret = Arrays.copyOf(ret, ret.length + 1))[ret.length - 2] & 0xFFFFFFFFFFF0L;
            long val = this.currDataLongs[segment].get(oldLink);
            if (val == 0L) {
                val = this.prevDataLongs[segment].get(oldLink);
            }
            if (val != 0L) {
                int file = (int)(val >>> 32 & 0xFFFFL);
                val &= 0xFFFFFFFFL;
                val = this.volumes.get(file).getLong(val);
            } else {
                val = this.vol.getLong(oldLink);
            }
            ret[ret.length - 1] = DataIO.parity3Get(val);
        }
        this.offsetsVerify(ret);
        return ret;
    }

    @Override
    protected <A> A get2(long recid, Serializer<A> serializer) {
        this.assertReadLocked(recid);
        int segment = this.lockPos(recid);
        Object cached = this.writeCache[segment].get1(recid);
        if (cached != null) {
            if (cached == TOMBSTONE2) {
                return null;
            }
            return (A)cached;
        }
        long walval = this.currLongLongs[segment].get(this.recidToOffset(recid));
        if (walval == 0L) {
            walval = this.prevLongLongs[segment].get(this.recidToOffset(recid));
        }
        if (walval != 0L) {
            if (this.compactionInProgress) {
                long offset;
                if (walval == Long.MAX_VALUE) {
                    return null;
                }
                int fileNum = (int)(walval >>> 40);
                Volume recVol = this.walRec.get(fileNum);
                int instruction = recVol.getUnsignedByte(offset = walval & 0xFFFFFFFFFFL);
                if (instruction != 80) {
                    throw new DBException.DataCorruption("wrong instruction");
                }
                if (recid != recVol.getSixLong(offset + 1L)) {
                    throw new DBException.DataCorruption("wrong recid");
                }
                int size = recVol.getInt(offset += 7L);
                DataInput in = size == 0 ? new DataIO.DataInputByteArray(new byte[0]) : recVol.getDataInput(offset + 4L, size);
                return this.deserialize(serializer, size, in);
            }
            boolean linked = (walval & 8L) != 0L;
            int size = (int)(walval >>> 48);
            if (linked && size == 0) {
                return null;
            }
            if (size == 0) {
                return this.deserialize(serializer, 0, new DataIO.DataInputByteArray(new byte[0]));
            }
            if (linked) {
                try {
                    int chunkSize;
                    DataInput in2;
                    int totalSize = 0;
                    byte[] in = new byte[100];
                    long link = walval;
                    while ((link & 8L) != 0L) {
                        in2 = this.walGetData(link & 0xFFFFFFFFFFF0L, segment);
                        chunkSize = (int)(link >>> 48);
                        link = in2.readLong();
                        if (in.length < totalSize + chunkSize - 8) {
                            in = Arrays.copyOf(in, Math.max(in.length * 2, totalSize + chunkSize - 8));
                        }
                        in2.readFully(in, totalSize, chunkSize - 8);
                        totalSize += chunkSize - 8;
                    }
                    in2 = this.walGetData(link & 0xFFFFFFFFFFF0L, segment);
                    chunkSize = (int)(link >>> 48);
                    if (in.length < totalSize + chunkSize) {
                        in = Arrays.copyOf(in, Math.max(in.length * 2, totalSize + chunkSize));
                    }
                    in2.readFully(in, totalSize, chunkSize);
                    return this.deserialize(serializer, totalSize += chunkSize, new DataIO.DataInputByteArray(in, 0));
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
            DataInput in = this.walGetData(walval & 0xFFFFFFFFFFF0L, segment);
            return this.deserialize(serializer, (int)(walval >>> 48), in);
        }
        long[] offsets = this.offsetsGet(this.lockPos(recid), this.indexValGet(recid));
        if (offsets == null) {
            return null;
        }
        if (offsets.length == 0) {
            return this.deserialize(serializer, 0, new DataIO.DataInputByteArray(new byte[0]));
        }
        if (offsets.length == 1) {
            int size = (int)(offsets[0] >>> 48);
            long offset = offsets[0] & 0xFFFFFFFFFFF0L;
            DataInput in = this.vol.getDataInput(offset, size);
            return this.deserialize(serializer, size, in);
        }
        int totalSize = this.offsetsTotalSize(offsets);
        byte[] b = new byte[totalSize];
        int bpos = 0;
        for (int i = 0; i < offsets.length; ++i) {
            int plus = i == offsets.length - 1 ? 0 : 8;
            long size = (offsets[i] >>> 48) - (long)plus;
            if ((size & 0xFFFFL) != size) {
                throw new DBException.DataCorruption("size mismatch");
            }
            long offset = offsets[i] & 0xFFFFFFFFFFF0L;
            this.vol.getData(offset + (long)plus, b, bpos, (int)size);
            bpos = (int)((long)bpos + size);
        }
        if (bpos != totalSize) {
            throw new DBException.DataCorruption("size does not match");
        }
        DataIO.DataInputByteArray in = new DataIO.DataInputByteArray(b);
        return this.deserialize(serializer, totalSize, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws UnsupportedOperationException {
        this.commitLock.lock();
        try {
            for (int segment = 0; segment < this.locks.length; ++segment) {
                Lock lock = this.locks[segment].writeLock();
                lock.lock();
                try {
                    this.writeCache[segment].clear();
                    if (this.caches == null) continue;
                    this.caches[segment].clear();
                    continue;
                }
                finally {
                    lock.unlock();
                }
            }
            this.structuralLock.lock();
            try {
                this.dirtyStackPages.clear();
                byte[] b = new byte[32856];
                this.headVolBackup.getData(0L, b, 0, b.length);
                this.headVol.putData(0L, b, 0, b.length);
                this.lastAllocatedData = DataIO.parity3Get(this.headVol.getLong(32L));
                this.indexPages = (long[])this.indexPagesBackup.clone();
            }
            finally {
                this.structuralLock.unlock();
            }
        }
        finally {
            this.commitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.commitLock.lock();
        try {
            if (this.compactionInProgress) {
                String recvalName = this.getWalFileName("r" + this.walRec.size());
                Volume v = this.volumeFactory.makeVolume(recvalName, this.readonly, true);
                this.walRec.add(v);
                v.ensureAvailable(16L);
                long offset = 16L;
                for (int segment = 0; segment < this.locks.length; ++segment) {
                    Lock lock = this.locks[segment].writeLock();
                    lock.lock();
                    try {
                        Store.LongObjectObjectMap writeCache1 = this.writeCache[segment];
                        Store.LongLongMap prevLongs = this.prevLongLongs[segment];
                        long[] set = writeCache1.set;
                        Object[] values = writeCache1.values;
                        for (int i = 0; i < set.length; ++i) {
                            int size;
                            DataIO.DataOutputByteArray buf;
                            long recid = set[i];
                            if (recid == 0L) continue;
                            Object value = values[i * 2];
                            if (value == TOMBSTONE2) {
                                buf = null;
                                size = -2;
                            } else {
                                Serializer s = (Serializer)values[i * 2 + 1];
                                buf = this.serialize(value, s);
                                size = buf == null ? -1 : buf.pos;
                            }
                            int needed = 11 + (buf == null ? 0 : buf.pos);
                            prevLongs.put(this.recidToOffset(recid), (long)this.fileNum << 40 | offset);
                            v.putUnsignedByte(offset, 80);
                            v.putSixLong(++offset, recid);
                            v.putInt(offset += 6L, size);
                            offset += 4L;
                            if (size > 0) {
                                v.putData(offset, buf.buf, 0, size);
                                offset += (long)size;
                            }
                            if (buf == null) continue;
                            this.recycledDataOut.lazySet(buf);
                        }
                        writeCache1.clear();
                        continue;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                this.structuralLock.lock();
                try {
                    v.putUnsignedByte(offset, 0);
                    v.sync();
                    v.putLong(8L, 8234892392398238983L);
                    v.sync();
                    return;
                }
                finally {
                    this.structuralLock.unlock();
                }
            }
            if (this.volumes.size() > 16 && !this.compactionInProgress) {
                this.commitFullWALReplay();
                return;
            }
            for (int segment = 0; segment < this.locks.length; ++segment) {
                Lock lock = this.locks[segment].writeLock();
                lock.lock();
                try {
                    long value;
                    long offset;
                    int i;
                    this.flushWriteCacheSegment(segment);
                    long[] v = this.currLongLongs[segment].table;
                    for (i = 0; i < v.length; i += 2) {
                        offset = v[i];
                        if (offset == 0L) continue;
                        value = v[i + 1];
                        this.prevLongLongs[segment].put(offset, value);
                        this.walPutLong(offset, value);
                        if (!this.checksum || offset <= 32856L || offset % 0x100000L == 0L) continue;
                        this.walPutUnsignedShort(offset + 8L, DataIO.longHash(value) & 0xFFFF);
                    }
                    this.currLongLongs[segment].clear();
                    v = this.currDataLongs[segment].table;
                    for (i = 0; i < v.length; i += 2) {
                        offset = v[i];
                        if (offset == 0L) continue;
                        value = v[i + 1];
                        this.prevDataLongs[segment].put(offset, value);
                    }
                    this.currDataLongs[segment].clear();
                    continue;
                }
                finally {
                    lock.unlock();
                }
            }
            this.structuralLock.lock();
            try {
                long[] set = this.dirtyStackPages.set;
                for (int i = 0; i < set.length; ++i) {
                    long offset = set[i];
                    if (offset == 0L) continue;
                    byte[] val = (byte[])this.dirtyStackPages.values[i];
                    if (offset < 0x100000L) {
                        throw new DBException.DataCorruption();
                    }
                    if (val.length % 16 != 0) {
                        throw new DBException.DataCorruption();
                    }
                    if (val.length <= 0 || val.length > 65535) {
                        throw new DBException.DataCorruption();
                    }
                    this.putDataSingleWithoutLink(-1, offset, val, 0, val.length);
                }
                this.dirtyStackPages.clear();
                this.headVol.putLong(32L, DataIO.parity3Set(this.lastAllocatedData));
                this.headVol.putInt(4L, this.headChecksum(this.headVol));
                byte[] b = new byte[32852];
                this.headVol.getData(4L, b, 0, b.length);
                this.putDataSingleWithoutLink(-1, 4L, b, 0, b.length);
                this.headVolBackup.putData(4L, b, 0, b.length);
                this.indexPagesBackup = (long[])this.indexPages.clone();
                long finalOffset = this.walOffset.get();
                this.curVol.ensureAvailable(finalOffset + 1L);
                this.curVol.putUnsignedByte(finalOffset, 0 | Long.bitCount(finalOffset) & 0xF);
                this.curVol.sync();
                this.curVol.putLong(8L, 8234892392398238983L);
                this.curVol.sync();
                this.walStartNextFile();
            }
            finally {
                this.structuralLock.unlock();
            }
        }
        finally {
            this.commitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitFullWALReplay() {
        if (!this.commitLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i].writeLock().lock();
        }
        try {
            for (int segment = 0; segment < this.locks.length; ++segment) {
                this.flushWriteCacheSegment(segment);
                long[] v = this.currLongLongs[segment].table;
                for (int i = 0; i < v.length; i += 2) {
                    long offset = v[i];
                    if (offset == 0L) continue;
                    long value = v[i + 1];
                    this.walPutLong(offset, value);
                    if (this.checksum && offset > 32856L && offset % 0x100000L != 0L) {
                        this.walPutUnsignedShort(offset + 8L, DataIO.longHash(value) & 0xFFFF);
                    }
                    v[i] = 0L;
                    v[i + 1] = 0L;
                }
                this.currLongLongs[segment].clear();
                if (this.currLongLongs[segment].size() != 0) {
                    throw new AssertionError();
                }
                this.currDataLongs[segment].clear();
                this.prevDataLongs[segment].clear();
                this.prevLongLongs[segment].clear();
            }
            this.structuralLock.lock();
            try {
                long[] set = this.dirtyStackPages.set;
                for (int i = 0; i < set.length; ++i) {
                    long offset = set[i];
                    if (offset == 0L) continue;
                    byte[] val = (byte[])this.dirtyStackPages.values[i];
                    if (offset < 0x100000L) {
                        throw new DBException.DataCorruption();
                    }
                    if (val.length % 16 != 0) {
                        throw new DBException.DataCorruption();
                    }
                    if (val.length <= 0 || val.length > 65535) {
                        throw new DBException.DataCorruption();
                    }
                    this.putDataSingleWithoutLink(-1, offset, val, 0, val.length);
                }
                this.dirtyStackPages.clear();
                if (this.dirtyStackPages.size != 0) {
                    throw new AssertionError();
                }
                this.pageLongStack.clear();
                this.headVol.putLong(32L, DataIO.parity3Set(this.lastAllocatedData));
                this.headVol.putInt(4L, this.headChecksum(this.headVol));
                byte[] b = new byte[32852];
                this.headVol.getData(4L, b, 0, b.length);
                this.putDataSingleWithoutLink(-1, 4L, b, 0, b.length);
                this.headVolBackup.putData(4L, b, 0, b.length);
                this.indexPagesBackup = (long[])this.indexPages.clone();
                long finalOffset = this.walOffset.get();
                this.curVol.ensureAvailable(finalOffset + 1L);
                this.curVol.putUnsignedByte(finalOffset, 0 | Long.bitCount(finalOffset) & 0xF);
                this.curVol.sync();
                this.curVol.putLong(8L, 8234892392398238983L);
                this.curVol.sync();
                this.replayWAL();
                this.walStartNextFile();
            }
            finally {
                this.structuralLock.unlock();
            }
        }
        finally {
            for (int i = this.locks.length - 1; i >= 0; --i) {
                this.locks[i].writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replayWAL() {
        boolean compaction;
        boolean bl = compaction = this.walC != null && this.walC.length() != 0L && this.walCCompact != null && this.walCCompact.length() != 0L;
        if (compaction) {
            boolean walCSeal;
            this.walC.ensureAvailable(16L);
            boolean bl2 = walCSeal = this.walC.getLong(8L) == 8234892392398238983L;
            if (!walCSeal) {
                LOG.warning("Compaction failed, seal not present. Removing incomplete compacted file, keeping old fragmented file.");
                this.walC.close();
                this.walC.deleteFile();
                this.walC = null;
                this.walCCompact.close();
                this.walCCompact.deleteFile();
                this.walCCompact = null;
            } else {
                if (this.vol.getFile() == null) {
                    Volume oldVol = this.vol;
                    this.realVol = this.walCCompact;
                    this.vol = new Volume.ReadOnly(this.realVol);
                    this.headVol.close();
                    this.headVolBackup.close();
                    this.initHeadVol();
                    oldVol.close();
                } else {
                    File walCCompactFile = this.walCCompact.getFile();
                    this.walCCompact.sync();
                    this.walCCompact.close();
                    this.walCCompact = null;
                    File thisFile = new File(this.fileName);
                    File thisFileBackup = new File(this.fileName + ".wal.c.orig");
                    this.vol.close();
                    if (!thisFile.renameTo(thisFileBackup)) {
                        throw new AssertionError((Object)("failed to rename file " + thisFile));
                    }
                    if (!walCCompactFile.renameTo(thisFile)) {
                        throw new AssertionError((Object)("failed to rename file " + walCCompactFile));
                    }
                    this.realVol = this.volumeFactory.makeVolume(this.fileName, this.readonly, this.fileLockDisable);
                    this.vol = new Volume.ReadOnly(this.realVol);
                    this.initHeadVol();
                    if (!thisFileBackup.delete()) {
                        LOG.warning("Could not delete original compacted file: " + thisFileBackup);
                    }
                }
                this.walC.close();
                this.walC.deleteFile();
                this.walC = null;
                this.initOpenPost();
            }
        }
        if (!this.walRec.isEmpty()) {
            this.structuralLock.lock();
            try {
                this.walStartNextFile();
            }
            finally {
                this.structuralLock.unlock();
            }
            for (Volume wr : this.walRec) {
                int instr;
                if (wr.length() == 0L) break;
                wr.ensureAvailable(16L);
                if (wr.getLong(8L) != 8234892392398238983L) break;
                long pos = 16L;
                while ((instr = wr.getUnsignedByte(pos++)) >>> 4 != 0) {
                    if (instr >>> 4 != 5) {
                        throw new DBException.DataCorruption("Invalid instruction in WAL REC" + (instr >>> 4));
                    }
                    long recid = wr.getSixLong(pos);
                    int size = wr.getInt(pos += 6L);
                    byte[] arr = new byte[size];
                    wr.getData(pos += 4L, arr, 0, size);
                    pos += (long)size;
                    this.update(recid, arr, Serializer.BYTE_ARRAY_NOSIZE);
                }
            }
            ArrayList<Volume> l = new ArrayList<Volume>(this.walRec);
            this.walRec.clear();
            this.commitFullWALReplay();
            for (Volume wr : l) {
                File f = wr.getFile();
                wr.close();
                wr.deleteFile();
                if (f == null || !f.exists() || f.delete()) continue;
                LOG.warning("Could not delete WAL REC file: " + f);
            }
            this.walRec.clear();
        }
        this.replayWALInstructionFiles();
    }

    private void replayWALInstructionFiles() {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        if (!this.commitLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        block0: for (Volume wal : this.volumes) {
            if (wal.length() < 16L || wal.getLong(8L) != 8234892392398238983L) break;
            long pos = 16L;
            while (true) {
                long offset;
                int checksum = wal.getUnsignedByte(pos++);
                int instruction = checksum >>> 4;
                checksum &= 0xF;
                if (instruction == 0) {
                    if ((Long.bitCount(pos - 1L) & 0xF) == checksum) continue block0;
                    throw new InternalError("WAL corrupted");
                }
                if (instruction == 1) {
                    long val = wal.getLong(pos);
                    offset = wal.getSixLong(pos += 8L);
                    pos += 6L;
                    if ((1 + Long.bitCount(val) + Long.bitCount(offset) & 0xF) != checksum) {
                        throw new InternalError("WAL corrupted");
                    }
                    this.realVol.ensureAvailable(offset + 8L);
                    this.realVol.putLong(offset, val);
                    continue;
                }
                if (instruction == 2) {
                    int dataSize = wal.getUnsignedShort(pos);
                    long offset2 = wal.getSixLong(pos += 2L);
                    byte[] data = new byte[dataSize];
                    wal.getData(pos += 6L, data, 0, data.length);
                    pos += (long)data.length;
                    if ((1 + Integer.bitCount(dataSize) + Long.bitCount(offset2) + this.sum(data) & 0xF) != checksum) {
                        throw new InternalError("WAL corrupted");
                    }
                    this.realVol.ensureAvailable(offset2 + (long)data.length);
                    this.realVol.putData(offset2, data, 0, data.length);
                    continue;
                }
                if (instruction == 3) {
                    int skipN = wal.getInt(pos - 1L) & 0xFFFFFF;
                    if ((Integer.bitCount(skipN) & 0xF) != checksum) {
                        throw new InternalError("WAL corrupted");
                    }
                    pos += (long)(3 + skipN);
                    continue;
                }
                if (instruction == 4) {
                    if ((Long.bitCount(pos - 1L) & 0xF) == checksum) continue;
                    throw new InternalError("WAL corrupted");
                }
                if (instruction != 6) break;
                long s = wal.getLong(pos);
                pos += 8L;
                if ((1 + Long.bitCount(s) & 0xF) != checksum) {
                    throw new InternalError("WAL corrupted");
                }
                offset = s & 0xFFFFFFFFFFFFL;
                this.realVol.ensureAvailable(offset + 2L);
                this.realVol.putUnsignedShort(offset, (int)(s >>> 48));
            }
            throw new InternalError("WAL corrupted, unknown instruction");
        }
        this.realVol.sync();
        for (Volume wal : this.volumes) {
            if (!wal.isClosed()) {
                wal.truncate(0L);
                wal.close();
            }
            wal.deleteFile();
        }
        this.fileNum = -1;
        this.curVol = null;
        this.volumes.clear();
    }

    private int sum(byte[] data) {
        int ret = 0;
        for (byte b : data) {
            ret += b;
        }
        return Math.abs(ret);
    }

    private int sum(byte[] buf, int bufPos, int size) {
        int ret = 0;
        size += bufPos;
        while (bufPos < size) {
            ret += buf[bufPos++];
        }
        return Math.abs(ret);
    }

    @Override
    public boolean canRollback() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.compactLock.lock();
        try {
            this.commitLock.lock();
            try {
                if (this.closed) {
                    return;
                }
                if (this.hasUncommitedData()) {
                    LOG.warning("Closing storage with uncommited data, those data will be discarded.");
                }
                if (!this.readonly) {
                    this.structuralLock.lock();
                    try {
                        this.replayWAL();
                    }
                    finally {
                        this.structuralLock.unlock();
                    }
                }
                if (this.walC != null) {
                    this.walC.close();
                }
                if (this.walCCompact != null) {
                    this.walCCompact.close();
                }
                for (Volume v : this.walRec) {
                    v.close();
                }
                this.walRec.clear();
                for (Volume v : this.volumes) {
                    v.close();
                }
                this.volumes.clear();
                this.vol.close();
                this.vol = null;
                this.headVol.close();
                this.headVol = null;
                this.headVolBackup.close();
                this.headVolBackup = null;
                this.curVol = null;
                this.dirtyStackPages.clear();
                if (this.caches != null) {
                    for (Store.Cache c : this.caches) {
                        c.close();
                    }
                    Arrays.fill(this.caches, null);
                }
                if (this.fileLockHeartbeat != null) {
                    this.fileLockHeartbeat.unlock();
                    this.fileLockHeartbeat = null;
                }
                this.closed = true;
            }
            finally {
                this.commitLock.unlock();
            }
        }
        finally {
            this.compactLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact() {
        this.compactLock.lock();
        try {
            if (this.compactOldFilesExists()) {
                return;
            }
            this.commitLock.lock();
            try {
                if (this.hasUncommitedData()) {
                    LOG.warning("Compaction started with uncommited data. Calling commit automatically.");
                }
                this.snapshotCloseAllOnCompact();
                this.commitFullWALReplay();
                this.compactionInProgress = true;
                this.structuralLock.lock();
                try {
                    if (this.fileNum != 0) {
                        throw new AssertionError();
                    }
                    if (this.walC != null) {
                        throw new AssertionError();
                    }
                    String walCFileName = this.getWalFileName("c");
                    if (this.walC != null) {
                        this.walC.close();
                    }
                    this.walC = this.volumeFactory.makeVolume(walCFileName, this.readonly, true);
                    this.walC.ensureAvailable(16L);
                    this.walC.putLong(0L, 0L);
                    this.walC.putLong(8L, 0L);
                    this.freeSize.set(-1L);
                }
                finally {
                    this.structuralLock.unlock();
                }
            }
            finally {
                this.commitLock.unlock();
            }
            long maxRecidOffset = DataIO.parity1Get(this.headVol.getLong(24L));
            String targetFile = this.getWalFileName("c.compact");
            StoreDirect target = new StoreDirect(targetFile, this.volumeFactory, null, this.lockScale, this.executor == null ? 2 : 1, this.checksum, this.compress, null, false, false, this.fileLockDisable, null, null, 0L, 0L, false);
            target.init();
            this.walCCompact = target.vol;
            AtomicLong maxRecid = new AtomicLong(DataIO.parity1Get(this.headVol.getLong(24L)) / this.indexValSize);
            this.compactIndexPages(target, maxRecid);
            while (this.$_TEST_HACK_COMPACT_PRE_COMMIT_WAIT) {
                LockSupport.parkNanos(10000L);
            }
            target.vol.putLong(24L, DataIO.parity1Set(maxRecid.get() * this.indexValSize));
            target.commit();
            this.walC.putLong(8L, 8234892392398238983L);
            this.walC.sync();
            this.commitLock.lock();
            try {
                if (this.hasUncommitedData()) {
                    LOG.warning("Uncommited data at end of compaction, autocommit");
                }
                this.commitFullWALReplay();
                this.compactionInProgress = false;
            }
            finally {
                this.commitLock.unlock();
            }
            while (this.$_TEST_HACK_COMPACT_POST_COMMIT_WAIT) {
                LockSupport.parkNanos(10000L);
            }
        }
        finally {
            this.compactionInProgress = false;
            this.compactLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasUncommitedData() {
        for (int i = 0; i < this.locks.length; ++i) {
            Lock lock = this.locks[i].readLock();
            lock.lock();
            try {
                if (this.currLongLongs[i].size() == 0 && this.currDataLongs[i].size() == 0 && this.writeCache[i].size == 0) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }
}

