/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class FloatPolygon {
    private Rectangle bounds;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    public int npoints;
    public float[] xpoints;
    public float[] ypoints;

    public FloatPolygon() {
        this.npoints = 0;
        this.xpoints = new float[10];
        this.ypoints = new float[10];
    }

    public FloatPolygon(float[] xpoints, float[] ypoints) {
        if (xpoints.length != ypoints.length) {
            throw new IllegalArgumentException("xpoints.length!=ypoints.length");
        }
        this.npoints = xpoints.length;
        this.xpoints = xpoints;
        this.ypoints = ypoints;
    }

    public FloatPolygon(float[] xpoints, float[] ypoints, int npoints) {
        this.npoints = npoints;
        this.xpoints = xpoints;
        this.ypoints = ypoints;
    }

    public boolean contains(float x, float y) {
        boolean inside = false;
        int i = 0;
        int j = this.npoints - 1;
        while (i < this.npoints) {
            if (this.ypoints[i] > y != this.ypoints[j] > y && x < (this.xpoints[j] - this.xpoints[i]) * (y - this.ypoints[i]) / (this.ypoints[j] - this.ypoints[i]) + this.xpoints[i]) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    public Rectangle getBounds() {
        if (this.npoints == 0) {
            return new Rectangle();
        }
        if (this.bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return this.bounds.getBounds();
    }

    public Rectangle2D.Double getFloatBounds() {
        if (this.npoints == 0) {
            return new Rectangle2D.Double();
        }
        if (this.bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return new Rectangle2D.Double(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    void calculateBounds(float[] xpoints, float[] ypoints, int npoints) {
        this.minX = Float.MAX_VALUE;
        this.minY = Float.MAX_VALUE;
        this.maxX = Float.MIN_VALUE;
        this.maxY = Float.MIN_VALUE;
        for (int i = 0; i < npoints; ++i) {
            float x = xpoints[i];
            this.minX = Math.min(this.minX, x);
            this.maxX = Math.max(this.maxX, x);
            float y = ypoints[i];
            this.minY = Math.min(this.minY, y);
            this.maxY = Math.max(this.maxY, y);
        }
        int iMinX = (int)Math.floor(this.minX);
        int iMinY = (int)Math.floor(this.minY);
        this.bounds = new Rectangle(iMinX, iMinY, (int)((double)(this.maxX - (float)iMinX) + 0.5), (int)((double)(this.maxY - (float)iMinY) + 0.5));
    }

    public void addPoint(float x, float y) {
        if (this.npoints == this.xpoints.length) {
            float[] tmp = new float[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, tmp, 0, this.npoints);
            this.xpoints = tmp;
            tmp = new float[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, tmp, 0, this.npoints);
            this.ypoints = tmp;
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        ++this.npoints;
        this.bounds = null;
    }

    public void addPoint(double x, double y) {
        this.addPoint((float)x, (float)y);
    }

    public FloatPolygon duplicate() {
        int n = this.npoints;
        float[] xpoints = new float[n];
        float[] ypoints = new float[n];
        System.arraycopy(this.xpoints, 0, xpoints, 0, n);
        System.arraycopy(this.ypoints, 0, ypoints, 0, n);
        return new FloatPolygon(xpoints, ypoints, n);
    }

    public double getLength(boolean isLine) {
        double dy;
        double dx;
        double length = 0.0;
        for (int i = 0; i < this.npoints - 1; ++i) {
            dx = this.xpoints[i + 1] - this.xpoints[i];
            dy = this.ypoints[i + 1] - this.ypoints[i];
            length += Math.sqrt(dx * dx + dy * dy);
        }
        if (!isLine) {
            dx = this.xpoints[0] - this.xpoints[this.npoints - 1];
            dy = this.ypoints[0] - this.ypoints[this.npoints - 1];
            length += Math.sqrt(dx * dx + dy * dy);
        }
        return length;
    }
}

