/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Arrow;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;

public class Filler
implements PlugInFilter,
Measurements {
    String arg;
    Roi roi;
    ImagePlus imp;
    int sliceCount;
    ImageProcessor mask;
    boolean isTextRoi;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        if (imp != null) {
            this.roi = imp.getRoi();
        }
        boolean bl = this.isTextRoi = this.roi != null && this.roi instanceof TextRoi;
        if (this.isTextRoi && (arg.equals("draw") || arg.equals("fill")) && ((TextRoi)this.roi).getAngle() != 0.0) {
            String s = IJ.isMacOSX() ? "command+b" : "ctrl+b";
            IJ.error("Draw rotated text by pressing " + s + " (Image>Overlay>Add Selection).");
            return 4096;
        }
        IJ.register(Filler.class);
        int baseCapabilities = 1055;
        if (arg.equals("clear")) {
            if (this.roi != null && this.roi.getType() == 10) {
                IJ.error("Clear", "Area selection required");
                return 4096;
            }
            if (this.isTextRoi || this.isLineSelection()) {
                return baseCapabilities;
            }
            return IJ.setupDialog(imp, baseCapabilities + 64);
        }
        if (arg.equals("draw")) {
            return IJ.setupDialog(imp, baseCapabilities);
        }
        if (arg.equals("label")) {
            if (Analyzer.firstParticle < Analyzer.lastParticle) {
                return baseCapabilities - 1024;
            }
            return baseCapabilities;
        }
        if (arg.equals("outside")) {
            return IJ.setupDialog(imp, baseCapabilities);
        }
        if (this.roi != null && this.roi.getType() == 10 && arg.equals("fill")) {
            IJ.error("Fill", "Area selection required");
            return 4096;
        }
        return IJ.setupDialog(imp, baseCapabilities + 64);
    }

    @Override
    public void run(ImageProcessor ip) {
        if (this.arg.equals("clear")) {
            this.clear(ip);
        } else if (this.isTextRoi && (this.arg.equals("draw") || this.arg.equals("fill"))) {
            this.draw(ip);
        } else if (this.arg.equals("fill")) {
            this.fill(ip);
        } else if (this.arg.equals("draw")) {
            this.draw(ip);
        } else if (this.arg.equals("label")) {
            this.label(ip);
        } else if (this.arg.equals("outside")) {
            this.clearOutside(ip);
        }
    }

    boolean isLineSelection() {
        return this.roi != null && this.roi.isLine();
    }

    boolean isStraightLine() {
        return this.roi != null && this.roi.getType() == 5;
    }

    public void clear(ImageProcessor ip) {
        ip.setColor(Toolbar.getBackgroundColor());
        if (this.isLineSelection()) {
            if (this.isStraightLine() && this.roi.getStrokeWidth() > 1.0f) {
                ip.fillPolygon(this.roi.getPolygon());
            } else {
                this.roi.drawPixels();
            }
        } else if (this.roi != null && this.roi instanceof TextRoi) {
            ((TextRoi)this.roi).clear(ip);
        } else {
            ip.fill();
        }
        ip.setColor(Toolbar.getForegroundColor());
    }

    public void fill(ImageProcessor ip) {
        ip.setColor(Toolbar.getForegroundColor());
        if (this.isLineSelection()) {
            if (this.isStraightLine() && this.roi.getStrokeWidth() > 1.0f && !(this.roi instanceof Arrow)) {
                ip.fillPolygon(this.roi.getPolygon());
            } else {
                this.roi.drawPixels(ip);
            }
        } else {
            ip.fill();
        }
    }

    public void draw(ImageProcessor ip) {
        ip.setColor(Toolbar.getForegroundColor());
        this.roi.drawPixels(ip);
        if (IJ.altKeyDown()) {
            this.drawLabel(ip);
        }
    }

    public void label(ImageProcessor ip) {
        if (!IJ.isMacro()) {
            IJ.error("Label", "To label a selection, enable \"Add to overlay\" in Analyze>\nSet Measurements and press 'm' (Analyze>Measure).");
            return;
        }
        if (Analyzer.getCounter() == 0) {
            IJ.error("Label", "Measurement counter is zero");
            return;
        }
        if (Analyzer.firstParticle < Analyzer.lastParticle) {
            this.drawParticleLabels(ip);
        } else {
            double mag;
            ip.setColor(Toolbar.getForegroundColor());
            ImageCanvas ic = this.imp.getCanvas();
            if (ic != null && (mag = ic.getMagnification()) < 1.0) {
                int lineWidth = 1;
                lineWidth = (int)((double)lineWidth / mag);
                ip.setLineWidth(lineWidth);
            }
            this.roi.drawPixels(ip);
            ip.setLineWidth(1);
            this.drawLabel(ip);
        }
    }

    void drawParticleLabels(ImageProcessor ip) {
        ResultsTable rt = ResultsTable.getResultsTable();
        int count = rt.size();
        int first = Analyzer.firstParticle;
        int last = Analyzer.lastParticle;
        if (count == 0 || first >= count || last >= count) {
            return;
        }
        if (!rt.columnExists(6)) {
            IJ.error("Label", "\"Centroids\" required to label particles");
            return;
        }
        for (int i = first; i <= last; ++i) {
            int x = (int)rt.getValueAsDouble(6, i);
            int y = (int)rt.getValueAsDouble(7, i);
            this.drawLabel(this.imp, ip, i + 1, new Rectangle(x, y, 0, 0));
        }
    }

    void drawLabel(ImageProcessor ip) {
        int count = Analyzer.getCounter();
        if (count > 0 && this.roi != null) {
            this.drawLabel(this.imp, ip, count, this.roi.getBounds());
        }
    }

    public void drawLabel(ImagePlus imp, ImageProcessor ip, int count, Rectangle r) {
        double mag;
        Color background;
        Color foreground = Toolbar.getForegroundColor();
        if (foreground.equals(background = Toolbar.getBackgroundColor())) {
            foreground = Color.black;
            background = Color.white;
        }
        int size = 9;
        ImageCanvas ic = imp.getCanvas();
        if (ic != null && (mag = ic.getMagnification()) < 1.0) {
            size = (int)((double)size / mag);
        }
        if (size == 9 && r.width > 50 && r.height > 50) {
            size = 12;
        }
        ip.setFont(new Font("SansSerif", 0, size));
        String label = "" + count;
        int w = ip.getStringWidth(label);
        int x = r.x + r.width / 2 - w / 2;
        int y = r.y + r.height / 2 + Math.max(size / 2, 6);
        FontMetrics metrics = ip.getFontMetrics();
        int h = metrics.getHeight();
        ip.setColor(background);
        ip.setRoi(x - 1, y - h + 2, w + 1, h - 3);
        ip.fill();
        ip.resetRoi();
        ip.setColor(foreground);
        ip.drawString(label, x, y);
    }

    public synchronized void clearOutside(ImageProcessor ip) {
        if (this.isLineSelection()) {
            IJ.error("\"Clear Outside\" does not work with line selections.");
            return;
        }
        ++this.sliceCount;
        Rectangle r = ip.getRoi();
        if (this.mask == null) {
            this.makeMask(ip, r);
        }
        ip.setColor(Toolbar.getBackgroundColor());
        int stackSize = this.imp.getStackSize();
        if (stackSize > 1) {
            ip.snapshot();
        }
        ip.fill();
        ip.reset(this.mask);
        int width = ip.getWidth();
        int height = ip.getHeight();
        ip.setRoi(0, 0, r.x, height);
        ip.fill();
        ip.setRoi(r.x, 0, r.width, r.y);
        ip.fill();
        ip.setRoi(r.x, r.y + r.height, r.width, height - (r.y + r.height));
        ip.fill();
        ip.setRoi(r.x + r.width, 0, width - (r.x + r.width), height);
        ip.fill();
        ip.setRoi(r);
        if (this.sliceCount == stackSize) {
            ip.setColor(Toolbar.getForegroundColor());
            Roi roi = this.imp.getRoi();
            this.imp.deleteRoi();
            this.imp.updateAndDraw();
            this.imp.setRoi(roi);
        }
    }

    public void makeMask(ImageProcessor ip, Rectangle r) {
        this.mask = ip.getMask();
        if (this.mask == null) {
            this.mask = new ByteProcessor(r.width, r.height);
            this.mask.invert();
        } else {
            this.mask = this.mask.duplicate();
        }
        this.mask.invert();
    }
}

