/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.gui.Arrow;
import ij.gui.EllipseRoi;
import ij.gui.ImageRoi;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RotatedRectRoi;
import ij.gui.ShapeRoi;
import ij.gui.TextRoi;
import ij.process.FloatPolygon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RoiEncoder {
    static final int HEADER_SIZE = 64;
    static final int HEADER2_SIZE = 64;
    static final int VERSION = 227;
    private String path;
    private OutputStream f;
    private final int polygon = 0;
    private final int rect = 1;
    private final int oval = 2;
    private final int line = 3;
    private final int freeline = 4;
    private final int polyline = 5;
    private final int noRoi = 6;
    private final int freehand = 7;
    private final int traced = 8;
    private final int angle = 9;
    private final int point = 10;
    private byte[] data;
    private String roiName;
    private int roiNameSize;
    private String roiProps;
    private int roiPropsSize;
    private int countersSize;
    private int[] counters;

    public RoiEncoder(String path) {
        this.path = path;
    }

    public RoiEncoder(OutputStream f) {
        this.f = f;
    }

    public static boolean save(Roi roi, String path) {
        RoiEncoder re = new RoiEncoder(path);
        try {
            re.write(roi);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void write(Roi roi) throws IOException {
        if (this.f != null) {
            this.write(roi, this.f);
        } else {
            this.f = new FileOutputStream(this.path);
            this.write(roi, this.f);
            this.f.close();
        }
    }

    public static byte[] saveAsByteArray(Roi roi) {
        if (roi == null) {
            return null;
        }
        byte[] bytes = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            RoiEncoder encoder = new RoiEncoder(out);
            encoder.write(roi);
            out.close();
            bytes = out.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
        return bytes;
    }

    void write(Roi roi, OutputStream f) throws IOException {
        int arcSize;
        Rectangle r = roi.getBounds();
        if (r.width > 65535 || r.height > 65535 || r.x > 65535 || r.y > 65535) {
            roi.enableSubPixelResolution();
        }
        int roiType = roi.getType();
        int type = 1;
        int options = 0;
        this.roiName = roi.getName();
        this.roiNameSize = this.roiName != null ? this.roiName.length() * 2 : 0;
        this.roiProps = roi.getProperties();
        this.roiPropsSize = this.roiProps != null ? this.roiProps.length() * 2 : 0;
        switch (roiType) {
            case 2: {
                type = 0;
                break;
            }
            case 3: {
                type = 7;
                break;
            }
            case 4: {
                type = 8;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            case 5: {
                type = 3;
                break;
            }
            case 6: {
                type = 5;
                break;
            }
            case 7: {
                type = 4;
                break;
            }
            case 8: {
                type = 9;
                break;
            }
            case 9: {
                type = 1;
                break;
            }
            case 10: {
                type = 10;
                break;
            }
            default: {
                type = 1;
            }
        }
        if (roiType == 9) {
            this.saveShapeRoi(roi, type, f, options);
            return;
        }
        int n = 0;
        int[] x = null;
        int[] y = null;
        float[] xf = null;
        float[] yf = null;
        int floatSize = 0;
        if (roi instanceof PolygonRoi) {
            PolygonRoi proi = (PolygonRoi)roi;
            Polygon p = proi.getNonSplineCoordinates();
            n = p.npoints;
            x = p.xpoints;
            y = p.ypoints;
            if (roi.subPixelResolution()) {
                FloatPolygon fp = null;
                fp = proi.isSplineFit() ? proi.getNonSplineFloatPolygon() : roi.getFloatPolygon();
                if (n == fp.npoints) {
                    options |= 0x80;
                    if (roi.getDrawOffset()) {
                        options |= 0x100;
                    }
                    xf = fp.xpoints;
                    yf = fp.ypoints;
                    floatSize = n * 8;
                }
            }
        }
        if (roi instanceof PointRoi) {
            this.countersSize = 0;
            this.counters = ((PointRoi)roi).getCounters();
            if (this.counters != null && this.counters.length >= n) {
                this.countersSize = n * 4;
            }
        }
        this.data = new byte[128 + n * 4 + floatSize + this.roiNameSize + this.roiPropsSize + this.countersSize];
        this.data[0] = 73;
        this.data[1] = 111;
        this.data[2] = 117;
        this.data[3] = 116;
        this.putShort(4, 227);
        this.data[6] = (byte)type;
        this.putShort(8, r.y);
        this.putShort(10, r.x);
        this.putShort(12, r.y + r.height);
        this.putShort(14, r.x + r.width);
        if (roi.subPixelResolution() && (type == 1 || type == 2)) {
            FloatPolygon p = roi.getFloatPolygon();
            if (p.npoints == 4) {
                this.putFloat(18, p.xpoints[0]);
                this.putFloat(22, p.ypoints[0]);
                this.putFloat(26, p.xpoints[1] - p.xpoints[0]);
                this.putFloat(30, p.ypoints[2] - p.ypoints[1]);
                this.putShort(50, options |= 0x80);
            }
        }
        if (n > 65535) {
            IJ.beep();
            IJ.log("ROIs with more than 65k points cannot be saved.");
            n = 65535;
        }
        this.putShort(16, n);
        this.putInt(56, roi.getPosition());
        if (type == 1 && (arcSize = roi.getCornerDiameter()) > 0) {
            this.putShort(54, arcSize);
        }
        if (roi instanceof Line) {
            Line line = (Line)roi;
            this.putFloat(18, (float)line.x1d);
            this.putFloat(22, (float)line.y1d);
            this.putFloat(26, (float)line.x2d);
            this.putFloat(30, (float)line.y2d);
            if (roi instanceof Arrow) {
                this.putShort(48, 2);
                if (((Arrow)roi).getDoubleHeaded()) {
                    options |= 2;
                }
                if (((Arrow)roi).getOutline()) {
                    options |= 4;
                }
                this.putShort(50, options);
                this.putByte(52, ((Arrow)roi).getStyle());
                this.putByte(53, (int)((Arrow)roi).getHeadSize());
            } else if (roi.getDrawOffset()) {
                options |= 0x180;
            }
        }
        if (roi instanceof PointRoi) {
            PointRoi point = (PointRoi)roi;
            this.putByte(52, point.getPointType());
            this.putShort(34, point.getSize());
        }
        if (roi instanceof RotatedRectRoi || roi instanceof EllipseRoi) {
            double[] p = null;
            if (roi instanceof RotatedRectRoi) {
                this.putShort(48, 5);
                p = ((RotatedRectRoi)roi).getParams();
            } else {
                this.putShort(48, 3);
                p = ((EllipseRoi)roi).getParams();
            }
            this.putFloat(18, (float)p[0]);
            this.putFloat(22, (float)p[1]);
            this.putFloat(26, (float)p[2]);
            this.putFloat(30, (float)p[3]);
            this.putFloat(52, (float)p[4]);
        }
        this.saveStrokeWidthAndColor(roi);
        if (roi instanceof PolygonRoi && ((PolygonRoi)roi).isSplineFit()) {
            this.putShort(50, options |= 1);
        }
        if (n == 0 && roi instanceof TextRoi) {
            this.saveTextRoi((TextRoi)roi);
        } else if (n == 0 && roi instanceof ImageRoi) {
            options = this.saveImageRoi((ImageRoi)roi, options);
        } else {
            this.putHeader2(roi, 64 + n * 4 + floatSize);
        }
        if (n > 0) {
            int i;
            int base1 = 64;
            int base2 = base1 + 2 * n;
            for (i = 0; i < n; ++i) {
                this.putShort(base1 + i * 2, x[i]);
                this.putShort(base2 + i * 2, y[i]);
            }
            if (xf != null) {
                base1 = 64 + 4 * n;
                base2 = base1 + 4 * n;
                for (i = 0; i < n; ++i) {
                    this.putFloat(base1 + i * 4, xf[i]);
                    this.putFloat(base2 + i * 4, yf[i]);
                }
            }
        }
        this.saveOverlayOptions(roi, options);
        f.write(this.data);
    }

    void saveStrokeWidthAndColor(Roi roi) {
        Color fillColor;
        Color strokeColor;
        BasicStroke stroke = roi.getStroke();
        if (stroke != null) {
            this.putShort(34, (int)stroke.getLineWidth());
        }
        if ((strokeColor = roi.getStrokeColor()) != null) {
            this.putInt(40, strokeColor.getRGB());
        }
        if ((fillColor = roi.getFillColor()) != null) {
            this.putInt(44, fillColor.getRGB());
        }
    }

    void saveShapeRoi(Roi roi, int type, OutputStream f, int options) throws IOException {
        float[] shapeArray = ((ShapeRoi)roi).getShapeAsArray();
        if (shapeArray == null) {
            return;
        }
        BufferedOutputStream bout = new BufferedOutputStream(f);
        Rectangle r = roi.getBounds();
        this.data = new byte[128 + shapeArray.length * 4 + this.roiNameSize + this.roiPropsSize];
        this.data[0] = 73;
        this.data[1] = 111;
        this.data[2] = 117;
        this.data[3] = 116;
        this.putShort(4, 227);
        this.data[6] = (byte)type;
        this.putShort(8, r.y);
        this.putShort(10, r.x);
        this.putShort(12, r.y + r.height);
        this.putShort(14, r.x + r.width);
        this.putInt(56, roi.getPosition());
        this.putInt(36, shapeArray.length);
        this.saveStrokeWidthAndColor(roi);
        this.saveOverlayOptions(roi, options);
        int base = 64;
        for (int i = 0; i < shapeArray.length; ++i) {
            this.putFloat(base, shapeArray[i]);
            base += 4;
        }
        int hdr2Offset = 64 + shapeArray.length * 4;
        this.putHeader2(roi, hdr2Offset);
        bout.write(this.data, 0, this.data.length);
        bout.flush();
    }

    void saveOverlayOptions(Roi roi, int options) {
        Font font;
        Overlay proto = roi.getPrototypeOverlay();
        if (proto.getDrawLabels()) {
            options |= 8;
        }
        if (proto.getDrawNames()) {
            options |= 0x10;
        }
        if (proto.getDrawBackgrounds()) {
            options |= 0x20;
        }
        if ((font = proto.getLabelFont()) != null && font.getStyle() == 1) {
            options |= 0x40;
        }
        this.putShort(50, options);
    }

    void saveTextRoi(TextRoi roi) {
        int i;
        Font font = roi.getCurrentFont();
        String fontName = font.getName();
        int size = font.getSize();
        int drawStringMode = roi.getDrawStringMode() ? 1024 : 0;
        int style = font.getStyle() + roi.getJustification() * 256 + drawStringMode;
        String text = roi.getText();
        float angle = (float)roi.getAngle();
        int angleLength = 4;
        int fontNameLength = fontName.length();
        int textLength = text.length();
        int textRoiDataLength = 16 + fontNameLength * 2 + textLength * 2 + angleLength;
        byte[] data2 = new byte[128 + textRoiDataLength + this.roiNameSize + this.roiPropsSize];
        System.arraycopy(this.data, 0, data2, 0, 64);
        this.data = data2;
        this.putShort(48, 1);
        this.putInt(64, size);
        this.putInt(68, style);
        this.putInt(72, fontNameLength);
        this.putInt(76, textLength);
        for (i = 0; i < fontNameLength; ++i) {
            this.putShort(80 + i * 2, fontName.charAt(i));
        }
        for (i = 0; i < textLength; ++i) {
            this.putShort(80 + fontNameLength * 2 + i * 2, text.charAt(i));
        }
        int hdr2Offset = 64 + textRoiDataLength;
        this.putFloat(hdr2Offset - angleLength, angle);
        this.putHeader2(roi, hdr2Offset);
    }

    private int saveImageRoi(ImageRoi roi, int options) {
        byte[] bytes = roi.getSerializedImage();
        int imageSize = bytes.length;
        byte[] data2 = new byte[128 + imageSize + this.roiNameSize + this.roiPropsSize];
        System.arraycopy(this.data, 0, data2, 0, 64);
        this.data = data2;
        this.putShort(48, 4);
        for (int i = 0; i < imageSize; ++i) {
            this.putByte(64 + i, bytes[i] & 0xFF);
        }
        int hdr2Offset = 64 + imageSize;
        double opacity = roi.getOpacity();
        this.putByte(hdr2Offset + 31, (int)(opacity * 255.0));
        this.putInt(hdr2Offset + 32, imageSize);
        if (roi.getZeroTransparent()) {
            options |= 0x200;
        }
        this.putHeader2(roi, hdr2Offset);
        return options;
    }

    void putHeader2(Roi roi, int hdr2Offset) {
        Font font;
        this.putInt(60, hdr2Offset);
        this.putInt(hdr2Offset + 4, roi.getCPosition());
        this.putInt(hdr2Offset + 8, roi.hasHyperStackPosition() ? roi.getZPosition() : 0);
        this.putInt(hdr2Offset + 12, roi.getTPosition());
        Overlay proto = roi.getPrototypeOverlay();
        Color overlayLabelColor = proto.getLabelColor();
        if (overlayLabelColor != null) {
            this.putInt(hdr2Offset + 24, overlayLabelColor.getRGB());
        }
        if ((font = proto.getLabelFont()) != null) {
            this.putShort(hdr2Offset + 28, font.getSize());
        }
        if (this.roiNameSize > 0) {
            this.putName(roi, hdr2Offset);
        }
        double strokeWidth = roi.getStrokeWidth();
        if (roi.getStroke() == null) {
            strokeWidth = 0.0;
        }
        this.putFloat(hdr2Offset + 36, (float)strokeWidth);
        if (this.roiPropsSize > 0) {
            this.putProps(roi, hdr2Offset);
        }
        if (this.countersSize > 0) {
            this.putPointCounters(roi, hdr2Offset);
        }
    }

    void putName(Roi roi, int hdr2Offset) {
        int offset = hdr2Offset + 64;
        int nameLength = this.roiNameSize / 2;
        this.putInt(hdr2Offset + 16, offset);
        this.putInt(hdr2Offset + 20, nameLength);
        for (int i = 0; i < nameLength; ++i) {
            this.putShort(offset + i * 2, this.roiName.charAt(i));
        }
    }

    void putProps(Roi roi, int hdr2Offset) {
        int offset = hdr2Offset + 64 + this.roiNameSize;
        int roiPropsLength = this.roiPropsSize / 2;
        this.putInt(hdr2Offset + 40, offset);
        this.putInt(hdr2Offset + 44, roiPropsLength);
        for (int i = 0; i < roiPropsLength; ++i) {
            this.putShort(offset + i * 2, this.roiProps.charAt(i));
        }
    }

    void putPointCounters(Roi roi, int hdr2Offset) {
        int offset = hdr2Offset + 64 + this.roiNameSize + this.roiPropsSize;
        this.putInt(hdr2Offset + 48, offset);
        for (int i = 0; i < this.countersSize / 4; ++i) {
            this.putInt(offset + i * 4, this.counters[i]);
        }
    }

    void putByte(int base, int v) {
        this.data[base] = (byte)v;
    }

    void putShort(int base, int v) {
        this.data[base] = (byte)(v >>> 8);
        this.data[base + 1] = (byte)v;
    }

    void putFloat(int base, float v) {
        int tmp = Float.floatToIntBits(v);
        this.data[base] = (byte)(tmp >> 24);
        this.data[base + 1] = (byte)(tmp >> 16);
        this.data[base + 2] = (byte)(tmp >> 8);
        this.data[base + 3] = (byte)tmp;
    }

    void putInt(int base, int i) {
        this.data[base] = (byte)(i >> 24);
        this.data[base + 1] = (byte)(i >> 16);
        this.data[base + 2] = (byte)(i >> 8);
        this.data[base + 3] = (byte)i;
    }
}

