/*
 * Decompiled with CFR 0.152.
 */
package jminhep.utils;

import java.text.FieldPosition;
import java.text.NumberFormat;
import jminhep.utils.ArrayOps;
import org.apache.commons.math3.util.FastMath;

public class VEC {
    public static String getSpaces(int n) {
        StringBuffer sb = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static void printMatrix(int n1, int n2, double[][] m, int d, int w) {
        NumberFormat myFormat = NumberFormat.getNumberInstance();
        FieldPosition fp = new FieldPosition(0);
        myFormat.setMaximumIntegerDigits(d);
        myFormat.setMaximumFractionDigits(d);
        myFormat.setMinimumFractionDigits(d);
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                String valString = myFormat.format(m[i][j], new StringBuffer(), fp).toString();
                valString = VEC.getSpaces(w - fp.getEndIndex()) + valString;
                System.out.print(valString);
            }
            System.out.println();
        }
        System.out.println();
    }

    public static String getMatrix(int n1, int n2, double[][] m, int d, int w) {
        String s = "\n";
        NumberFormat myFormat = NumberFormat.getNumberInstance();
        FieldPosition fp = new FieldPosition(0);
        myFormat.setMaximumIntegerDigits(d);
        myFormat.setMaximumFractionDigits(d);
        myFormat.setMinimumFractionDigits(d);
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                String valString = myFormat.format(m[i][j], new StringBuffer(), fp).toString();
                valString = VEC.getSpaces(w - fp.getEndIndex()) + valString;
                s = s + valString;
            }
            s = s + "\n";
        }
        s = s + "\n";
        return s;
    }

    public static void printMatrix(int n1, int n2, int[][] m, int d, int w) {
        NumberFormat myFormat = NumberFormat.getNumberInstance();
        FieldPosition fp = new FieldPosition(0);
        myFormat.setMaximumIntegerDigits(d);
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                String valString = myFormat.format(m[i][j], new StringBuffer(), fp).toString();
                valString = VEC.getSpaces(w - fp.getEndIndex()) + valString;
                System.out.print(valString);
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void printVect(double[] m, int d, int w) {
        NumberFormat myFormat = NumberFormat.getNumberInstance();
        FieldPosition fp = new FieldPosition(0);
        myFormat.setMaximumIntegerDigits(d);
        myFormat.setMaximumFractionDigits(d);
        myFormat.setMinimumFractionDigits(d);
        int len = m.length;
        for (int i = 0; i < len; ++i) {
            String valString = myFormat.format(m[i], new StringBuffer(), fp).toString();
            valString = VEC.getSpaces(w - fp.getEndIndex()) + valString;
            System.out.print(valString);
        }
        System.out.println();
        System.out.println();
    }

    public static void printVect(int[] m, int d, int w) {
        NumberFormat myFormat = NumberFormat.getNumberInstance();
        FieldPosition fp = new FieldPosition(0);
        myFormat.setMaximumIntegerDigits(d);
        int len = m.length;
        for (int i = 0; i < len; ++i) {
            String valString = myFormat.format(m[i], new StringBuffer(), fp).toString();
            valString = VEC.getSpaces(w - fp.getEndIndex()) + valString;
            System.out.print(valString);
        }
        System.out.println();
        System.out.println();
    }

    public static double[][] Standardize(int nrow, int ncol, double[][] A) {
        int i;
        int j;
        double[] colmeans = new double[ncol];
        double[] colstdevs = new double[ncol];
        double[][] Adat = new double[nrow][ncol];
        double[] tempcol = new double[nrow];
        for (j = 0; j < ncol; ++j) {
            double tot = 0.0;
            for (i = 0; i < nrow; ++i) {
                tempcol[i] = A[i][j];
                tot += tempcol[i];
            }
            colmeans[j] = tot / (double)nrow;
            for (i = 0; i < nrow; ++i) {
                int n = j;
                colstdevs[n] = colstdevs[n] + FastMath.pow((double)(tempcol[i] - colmeans[j]), (double)2.0);
            }
            colstdevs[j] = FastMath.sqrt((double)(colstdevs[j] / (double)nrow));
            if (!(colstdevs[j] < 1.0E-4)) continue;
            colstdevs[j] = 1.0;
        }
        for (j = 0; j < ncol; ++j) {
            for (i = 0; i < nrow; ++i) {
                Adat[i][j] = (A[i][j] - colmeans[j]) / (FastMath.sqrt((double)nrow) * colstdevs[j]);
            }
        }
        return Adat;
    }

    public static double[][] GetSummaryData(int nrow, int ncol, double[][] A) {
        double[] tempcol = new double[nrow];
        double[][] summary = new double[ncol][4];
        for (int j = 0; j < ncol; ++j) {
            int i;
            double tot = 0.0;
            for (i = 0; i < nrow; ++i) {
                tempcol[i] = A[i][j];
                tot += tempcol[i];
                int itmp = 0;
                itmp = ArrayOps.findLargest(tempcol);
                summary[j][2] = tempcol[itmp];
                itmp = ArrayOps.findSmallest(tempcol);
                summary[j][3] = tempcol[itmp];
            }
            summary[j][0] = tot / (double)nrow;
            for (i = 0; i < nrow; ++i) {
                double[] dArray = summary[j];
                dArray[1] = dArray[1] + FastMath.pow((double)(tempcol[i] - summary[j][0]), (double)2.0);
            }
            summary[j][1] = FastMath.sqrt((double)(summary[j][1] / (double)nrow));
            if (!(summary[j][1] < 1.0E-4)) continue;
            summary[j][1] = 1.0;
        }
        return summary;
    }

    public static void inSort(double[] invect) {
        for (int j = 1; j < invect.length; ++j) {
            double a = invect[j];
            for (int i = j - 1; i >= 0 && invect[i] > a; --i) {
                invect[i + 1] = invect[i];
            }
            invect[i + 1] = a;
        }
    }
}

