/*
 * Decompiled with CFR 0.152.
 */
package jminhep.gui;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import jminhep.clcontrol.ClControl;
import jminhep.cluster.DataHolder;
import jminhep.cluster.DataPoint;
import jminhep.gui.AboutDialog;
import jminhep.gui.CSelector;
import jminhep.gui.Constants;
import jminhep.gui.OidNode;
import jminhep.gui.SetEnv;
import jminhep.gui.TableSummary;
import jminhep.gui.ThreadShow;
import jminhep.utils.MemoryMonitor;
import jminhep.utils.ResourceLoader;
import jminhep.utils.VEC;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.ui.RectangleInsets;

public class MainFrame
extends JFrame
implements Constants {
    public static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private BorderLayout borderLayout1;
    private JMenuBar jMenuBar1;
    private JMenu jMenuFile;
    private JMenuItem jMenuFileExit;
    private JMenuItem jMenuFileOpen;
    private JMenuItem jMenuFileClose;
    private JMenu jMenuHelp;
    private JMenuItem jMenuHelpAbout;
    private JMenuItem jMenuExport;
    private JToolBar jToolBar;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private CSelector m_CSelector;
    private static int Mode_old = 1;
    private JToolBar jToolBar1;
    private JPanel jPanel2;
    private ClControl m_ClControl;
    private JPanel infoPanel;
    private TableSummary jSummary;
    private JPanel jSumPanel;
    public static String file_input = "";
    public static String file_open = "";
    public static String file_save = "";
    public static File afile;
    public static Vector<String> textX;
    public static Vector<String> textY;
    protected Thread m_IOThread;
    private JComboBox selX;
    private JComboBox selY;
    private JComboBox selStyle;
    private ThreadShow SThX = null;
    private ThreadShow SThY = null;

    public MainFrame(String input) {
        try {
            file_input = input;
            this.setDefaultCloseOperation(2);
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MainFrame(DataHolder d) {
        try {
            SetEnv.DATA = d;
            this.setDefaultCloseOperation(2);
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        SetEnv.init();
        ResourceLoader.init("jminhep/resources/");
        this.m_CSelector = new CSelector();
        this.infoPanel = new JPanel();
        this.jMenuFileExit = new JMenuItem();
        this.jMenuExport = new JMenuItem("Export to PDF...", 112);
        this.jMenuFileOpen = new JMenuItem();
        this.jMenuFileClose = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuHelpAbout = new JMenuItem();
        this.jToolBar = new JToolBar(null, 0);
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jSummary = new TableSummary();
        this.jSumPanel = new JPanel();
        this.jSumPanel.setLayout(new BorderLayout());
        this.jSumPanel.setPreferredSize(new Dimension(SetEnv.SizeB, 300));
        this.jSumPanel.add((Component)this.jSummary, "Center");
        this.borderLayout1 = new BorderLayout();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jToolBar1 = new JToolBar(null, 1);
        this.jToolBar1.setLayout(new BorderLayout());
        this.jPanel2 = new JPanel();
        textX = new Vector();
        textY = new Vector();
        textX.addElement("not set");
        textY.addElement("not set");
        this.jPanel2.add(this.m_CSelector);
        String[] plots = new String[]{"Points", "Density"};
        this.selStyle = new JComboBox<String>(plots);
        this.selStyle.setSelectedIndex(0);
        this.selStyle.setPreferredSize(new Dimension(200, 50));
        this.selStyle.setBorder(new TitledBorder(null, "Style", 0, 0, new Font("Dialog", 0, 12)));
        this.selX = new JComboBox<String>(textX);
        this.selX.setSelectedIndex(0);
        this.selX.setPreferredSize(new Dimension(200, 50));
        this.selX.setBorder(new TitledBorder(null, "X:", 0, 0, new Font("Dialog", 0, 12)));
        this.jPanel2.add(this.selX);
        this.selY = new JComboBox<String>(textY);
        this.selY.setBorder(new TitledBorder(null, "Y:", 0, 0, new Font("Dialog", 0, 12)));
        this.selY.setSelectedIndex(0);
        this.selY.setPreferredSize(new Dimension(200, 50));
        this.jPanel2.add(this.selY);
        this.selX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JComboBox cb = (JComboBox)evt.getSource();
                int nn = cb.getSelectedIndex();
                if (nn > -1 && SetEnv.JboxX != nn) {
                    SetEnv.JboxX = nn;
                    MainFrame.this.SThX = new ThreadShow(SetEnv.Style);
                    if (!MainFrame.this.SThX.Alive()) {
                        MainFrame.this.SThX.Start();
                    }
                }
            }
        });
        this.selY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JComboBox cb = (JComboBox)evt.getSource();
                int nn = cb.getSelectedIndex();
                if (nn > -1 && SetEnv.JboxY != nn) {
                    SetEnv.JboxY = nn;
                    MainFrame.this.SThY = new ThreadShow(SetEnv.Style);
                    if (!MainFrame.this.SThY.Alive()) {
                        MainFrame.this.SThY.Start();
                    }
                }
            }
        });
        MyItemListenerStyle actionListenerStyle = new MyItemListenerStyle();
        this.selStyle.addItemListener(actionListenerStyle);
        this.jPanel2.add(this.selStyle);
        this.jPanel2.add(this.jSumPanel);
        this.m_ClControl = new ClControl();
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(SetEnv.SizeX, SetEnv.SizeY));
        this.setTitle("jMinHEP");
        this.infoPanel.setLayout(new BorderLayout());
        this.infoPanel.setBorder(new EtchedBorder());
        this.infoPanel.add((Component)SetEnv.statusbar, "West");
        MemoryMonitor memMon = new MemoryMonitor();
        memMon.setPreferredSize(new Dimension(65, 24));
        memMon.setMinimumSize(new Dimension(30, 10));
        this.infoPanel.add((Component)memMon, "East");
        this.jMenuFile.setText("File");
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileOpen.setText("Open");
        this.jMenuFileClose.setText("Close");
        this.jMenuFileExit.addActionListener(new MainFrame_jMenuFileExit_ActionAdapter(this));
        this.jMenuFileOpen.addActionListener(new MainFrame_jMenuFileOpen_ActionAdapter(this));
        this.jMenuFileClose.addActionListener(new MainFrame_jMenuFileClose_ActionAdapter(this));
        this.jMenuExport.addActionListener(new MainFrame_jMenuExport_ActionAdapter(this));
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new MainFrame_jMenuHelpAbout_ActionAdapter(this));
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuFile.add(this.jMenuFileOpen);
        this.jMenuFile.add(this.jMenuFileClose);
        this.jMenuFile.add(this.jMenuExport);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuBar1.add(this.jMenuHelp);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.setJMenuBar(this.jMenuBar1);
        this.jButton1.setIcon(OpeN);
        this.jButton1.setToolTipText("Open File");
        this.jToolBar.add(this.jButton1);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.OpenFile();
            }
        });
        this.jButton2.setIcon(ClosE);
        this.jButton2.setToolTipText("Close File");
        this.jToolBar.add(this.jButton2);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.closeFile();
            }
        });
        this.jButton3.setIcon(HelP);
        this.jButton3.setToolTipText("Help");
        this.jToolBar.add(this.jButton3);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.openHelp();
            }
        });
        this.contentPane.add((Component)this.infoPanel, "South");
        this.contentPane.add((Component)this.jToolBar, "North");
        this.contentPane.add((Component)this.jToolBar1, "East");
        this.jToolBar1.add((Component)this.m_CSelector, "North");
        this.jToolBar1.add((Component)this.jPanel2, "Center");
        this.jPanel2.setPreferredSize(new Dimension(SetEnv.SizeB, SetEnv.SizeY));
        this.m_ClControl.setPreferredSize(new Dimension(SetEnv.SizeB, SetEnv.SizeY));
        this.m_CSelector.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getPath();
                Object[] nodes = path.getPath();
                String oid = "";
                for (int k = 0; k < nodes.length; ++k) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes[k];
                    OidNode nd = (OidNode)node.getUserObject();
                    oid = oid + nd.getId();
                }
                SetEnv.Mode = Integer.parseInt(oid);
                SetEnv.statusbar.setText("Partition mode " + SetEnv.Mode + " initiated");
                if (SetEnv.Mode == 1) {
                    if (Mode_old != 1) {
                        MainFrame.this.jToolBar1.remove(MainFrame.this.m_ClControl);
                        MainFrame.this.jToolBar1.add((Component)MainFrame.this.jPanel2, "Center");
                        Mode_old = SetEnv.Mode;
                        MainFrame.this.jToolBar1.updateUI();
                    }
                } else if (Mode_old == 1) {
                    MainFrame.this.jToolBar1.remove(MainFrame.this.jPanel2);
                    MainFrame.this.jToolBar1.add((Component)MainFrame.this.m_ClControl, "Center");
                    Mode_old = SetEnv.Mode;
                    MainFrame.this.jToolBar1.updateUI();
                }
            }
        });
        this.contentPane.add((Component)SetEnv.PLOT, "Center");
        if (file_input.length() > 1) {
            this.LoadFile(file_input);
        } else if (SetEnv.DATA != null) {
            this.LoadFile();
        }
    }

    void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        JOptionPane dialog = new JOptionPane();
        int ask = JOptionPane.showConfirmDialog(dialog, "Exit JMinHEP?", "Question", 0, 3, null);
        if (ask == 0) {
            this.setVisible(false);
            this.dispose();
        }
    }

    void jMenuFileOpen_actionPerformed(ActionEvent actionEvent) {
        this.OpenFile();
    }

    void jMenuFileClose_actionPerformed(ActionEvent actionEvent) {
        this.closeFile();
    }

    void jMenuExport_actionPerformed(ActionEvent actionEvent) {
        this.export();
    }

    void export() {
        ChartPanel chartpanel = SetEnv.PLOT.getChartPanel();
        JFreeChart jfreechart = SetEnv.PLOT.getChart();
        int i = chartpanel.getWidth();
        int j = chartpanel.getHeight();
        if (jfreechart != null) {
            JFileChooser jfilechooser = new JFileChooser();
            jfilechooser.setName("untitled.pdf");
            jfilechooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".pdf");
                }

                @Override
                public String getDescription() {
                    return "Portable Document Format (PDF)";
                }
            });
            int k = jfilechooser.showSaveDialog(this);
            if (k == 0) {
                try {
                    JFreeChart jfreechart1 = (JFreeChart)jfreechart.clone();
                    PDFExportTask pdfexporttask = new PDFExportTask(jfreechart1, i, j, jfilechooser.getSelectedFile());
                    Thread thread = new Thread(pdfexporttask);
                    thread.start();
                }
                catch (CloneNotSupportedException clonenotsupportedexception) {
                    clonenotsupportedexception.printStackTrace();
                }
            }
        } else {
            String s = "Unable to export the selected item.  There is ";
            s = s + "either no chart selected,\nor else the chart is not ";
            s = s + "at the expected location in the component hierarchy\n";
            s = s + "(future versions of the demo may include code to ";
            s = s + "handle these special cases).";
            JOptionPane.showMessageDialog(this, s, "PDF Export", 1);
        }
    }

    void closeFile() {
        JOptionPane dialog = new JOptionPane();
        int ask = JOptionPane.showConfirmDialog(dialog, "Close current ARFF file?", "Question", 0, 3, null);
        if (ask == 0) {
            SetEnv.PLOT.clearPlot();
            SetEnv.DATA = null;
            SetEnv.Dim = 0;
            SetEnv.NRow = 0;
        }
    }

    void openHelp() {
        new AboutDialog(this);
    }

    void SetOptions(int iX, int iY) {
        this.selX.removeAllItems();
        this.selY.removeAllItems();
        SetEnv.JboxX = iX;
        SetEnv.JboxY = iY;
        for (int i = 0; i < SetEnv.Dim; ++i) {
            String a = SetEnv.DATA.getName(i);
            this.selX.addItem(a);
            this.selY.addItem(a);
        }
        if (SetEnv.Dim > 1) {
            ThreadShow STh1;
            this.selX.setSelectedIndex(iX);
            this.selY.setSelectedIndex(iY);
            SetEnv.JboxX = iX;
            SetEnv.JboxY = iY;
            if (SetEnv.Style == 0 && !(STh1 = new ThreadShow(SetEnv.Style)).Alive()) {
                STh1.Start();
            }
        }
    }

    void SetTableSummary() {
        if (this.jSummary.model.getRowCount() > 0) {
            this.jSummary.model.setRowCount(0);
        }
        int n = SetEnv.NRow;
        int m = SetEnv.Dim;
        double[][] indat = new double[n][m];
        for (int i = 0; i < n; ++i) {
            DataPoint dp = SetEnv.DATA.getRow(i);
            for (int i2 = 0; i2 < m; ++i2) {
                indat[i][i2] = dp.getAttribute(i2);
            }
        }
        double[][] sum = VEC.GetSummaryData(n, m, indat);
        DecimalFormat formatter = new DecimalFormat("0.00E00");
        for (int i = 0; i < m; ++i) {
            String s0 = SetEnv.DATA.getName(i);
            String s1 = formatter.format(sum[i][0]);
            String s2 = formatter.format(sum[i][1]);
            this.jSummary.model.addRow(new Object[]{new String(s0), new String(s1 + "/" + s2)});
        }
    }

    void ShowStatus(String s) {
        SetEnv.statusbar.setText(s);
    }

    void OpenFile() {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new FilterARFF());
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            afile = fc.getSelectedFile();
            file_open = afile.getAbsolutePath().trim();
            this.LoadFile(file_open);
        }
    }

    void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        this.openHelp();
    }

    public void LoadFile(String sfile) {
        SetEnv.Load(sfile);
        SetEnv.JboxX = 0;
        SetEnv.JboxY = 1;
        this.SetOptions(SetEnv.JboxX, SetEnv.JboxY);
        this.ShowStatus("File " + sfile + " loaded");
    }

    public void LoadFile() {
        SetEnv.Load();
        SetEnv.JboxX = 0;
        SetEnv.JboxY = 1;
        this.SetOptions(SetEnv.JboxX, SetEnv.JboxY);
        this.ShowStatus("Data are loaded");
    }

    public static void saveChartAsPDF(File file, JFreeChart jfreechart, int i, int j, FontMapper fontmapper) throws IOException {
        BufferedOutputStream bufferedoutputstream = new BufferedOutputStream(new FileOutputStream(file));
        MainFrame.writeChartAsPDF(bufferedoutputstream, jfreechart, i, j, fontmapper);
        bufferedoutputstream.close();
    }

    public static void writeChartAsPDF(OutputStream outputstream, JFreeChart jfreechart, int i, int j, FontMapper fontmapper) throws IOException {
        Rectangle rectangle = new Rectangle((float)i, (float)j);
        Document document = new Document(rectangle, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            PdfWriter pdfwriter = PdfWriter.getInstance((Document)document, (OutputStream)outputstream);
            document.addAuthor("S.Chekanov");
            document.addSubject("jMinHEP");
            document.open();
            PdfContentByte pdfcontentbyte = pdfwriter.getDirectContent();
            PdfTemplate pdftemplate = pdfcontentbyte.createTemplate((float)i, (float)j);
            Graphics2D graphics2d = pdftemplate.createGraphics((float)i, (float)j, fontmapper);
            Rectangle2D.Double double1 = new Rectangle2D.Double(0.0, 0.0, i, j);
            jfreechart.draw(graphics2d, (Rectangle2D)double1);
            graphics2d.dispose();
            pdfcontentbyte.addTemplate(pdftemplate, 0.0f, 0.0f);
        }
        catch (DocumentException documentexception) {
            System.err.println(documentexception.getMessage());
        }
        document.close();
    }

    static class PDFExportTask
    implements Runnable {
        JFreeChart chart;
        int width;
        int height;
        File file;

        @Override
        public void run() {
            try {
                MainFrame.saveChartAsPDF(this.file, this.chart, this.width, this.height, (FontMapper)new DefaultFontMapper());
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }

        public PDFExportTask(JFreeChart jfreechart, int i, int j, File file1) {
            this.chart = jfreechart;
            this.file = file1;
            this.width = i;
            this.height = j;
            jfreechart.setBorderVisible(true);
            jfreechart.setPadding(new RectangleInsets(2.0, 2.0, 2.0, 2.0));
        }
    }

    class MyItemListenerStyle
    implements ItemListener {
        MyItemListenerStyle() {
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            JComboBox cb = (JComboBox)evt.getSource();
            if (evt.getStateChange() == 1) {
                ThreadShow STh3;
                int nn = cb.getSelectedIndex();
                if (nn == 0) {
                    SetEnv.Style = 0;
                }
                if (nn == 1) {
                    SetEnv.Style = 1;
                }
                if (!(STh3 = new ThreadShow(SetEnv.Style)).Alive()) {
                    STh3.Start();
                }
            } else if (evt.getStateChange() == 2) {
                // empty if block
            }
        }
    }

    class MainFrame_jMenuHelpAbout_ActionAdapter
    implements ActionListener {
        MainFrame adaptee;

        MainFrame_jMenuHelpAbout_ActionAdapter(MainFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.jMenuHelpAbout_actionPerformed(actionEvent);
        }
    }

    class MainFrame_jMenuExport_ActionAdapter
    implements ActionListener {
        MainFrame adaptee;

        MainFrame_jMenuExport_ActionAdapter(MainFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.jMenuExport_actionPerformed(actionEvent);
        }
    }

    class MainFrame_jMenuFileClose_ActionAdapter
    implements ActionListener {
        MainFrame adaptee;

        MainFrame_jMenuFileClose_ActionAdapter(MainFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.jMenuFileClose_actionPerformed(actionEvent);
        }
    }

    class MainFrame_jMenuFileOpen_ActionAdapter
    implements ActionListener {
        MainFrame adaptee;

        MainFrame_jMenuFileOpen_ActionAdapter(MainFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.jMenuFileOpen_actionPerformed(actionEvent);
        }
    }

    class MainFrame_jMenuFileExit_ActionAdapter
    implements ActionListener {
        MainFrame adaptee;

        MainFrame_jMenuFileExit_ActionAdapter(MainFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.jMenuFileExit_actionPerformed(actionEvent);
        }
    }

    class FilterARFF
    extends FileFilter {
        FilterARFF() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(".arff") || f.getName().endsWith(".ARFF");
        }

        @Override
        public String getDescription() {
            return "*.arff";
        }
    }

    class LoadCombo
    extends Thread {
        private String name;

        public LoadCombo(String str) {
            super(str);
            this.name = str;
        }

        @Override
        public void run() {
            SetEnv.Load(this.name);
            SetEnv.JboxX = 0;
            SetEnv.JboxY = 1;
            MainFrame.this.SetOptions(SetEnv.JboxX, SetEnv.JboxY);
            MainFrame.this.ShowStatus("File " + this.name + " loaded");
        }
    }
}

