/*
 * Decompiled with CFR 0.152.
 */
package jminhep.cluster;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;
import jminhep.cluster.DataPoint;

public class DataHolder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<DataPoint> Points = new ArrayList();
    private DataPoint Min;
    private DataPoint Max;
    private String[] names;
    private int Dim;
    private String relation;
    private static boolean first;
    private double[] xmin;
    private double[] xmax;
    private int[] in_xmin;
    private int[] in_xmax;

    public DataHolder() {
        this.Dim = 0;
        this.relation = "DataHolder";
        first = true;
    }

    public DataHolder(int dim) {
        this.Dim = dim;
        this.relation = "DataHolder";
        first = true;
        this.names = new String[this.Dim];
        for (int j = 0; j < this.Dim; ++j) {
            this.names[j] = Integer.toString(j + 1);
        }
    }

    public DataHolder(String name) {
        this.Dim = 0;
        first = true;
        this.relation = name;
    }

    public DataHolder(DataPoint xMin, DataPoint xMax, int Dim, int Size) {
        this.Dim = Dim;
        this.relation = "Random";
        for (int m = 0; m < Dim; ++m) {
            this.names[m] = "random_" + Integer.toString(m + 1);
        }
        this.Min = xMin;
        this.Min = xMax;
        first = true;
        Random generator = new Random();
        double[] a = new double[Dim];
        for (int j = 0; j < Size; ++j) {
            for (int m = 0; m < Dim; ++m) {
                a[m] = xMin.getAttribute(m) + generator.nextDouble() * (xMax.getAttribute(m) - xMin.getAttribute(m));
            }
            DataPoint Seed = new DataPoint(a, Dim);
            this.Points.add(Seed);
        }
    }

    public void fillRandom(DataPoint xMin, DataPoint xMax, int Dim, int Size) {
        this.Points.clear();
        this.Dim = Dim;
        this.relation = "Random";
        this.names = new String[Dim];
        for (int m = 0; m < Dim; ++m) {
            this.names[m] = "random_" + String.valueOf(m + 1);
        }
        this.Min = xMin;
        this.Min = xMax;
        Random generator = new Random();
        double[] a = new double[Dim];
        for (int j = 0; j < Size; ++j) {
            for (int m = 0; m < Dim; ++m) {
                a[m] = xMin.getAttribute(m) + generator.nextDouble() * (xMax.getAttribute(m) - xMin.getAttribute(m));
            }
            DataPoint Seed = new DataPoint(a, Dim);
            this.Points.add(Seed);
        }
    }

    public ArrayList getArrayList() {
        return this.Points;
    }

    public DataPoint[] getArray() {
        int nn = this.Points.size();
        DataPoint[] d = new DataPoint[nn];
        for (int m = 0; m < nn; ++m) {
            DataPoint dp;
            d[m] = dp = this.getRow(m);
        }
        return d;
    }

    public void clear() {
        this.Points.clear();
        this.relation = "";
        this.Dim = 0;
        this.names = null;
    }

    public void add(DataPoint p) {
        this.Points.add(p);
        this.Dim = p.getDimension();
        if (first) {
            first = false;
            this.names = new String[this.Dim];
            for (int j = 0; j < this.Dim; ++j) {
                this.names[j] = Integer.toString(j + 1);
            }
        }
    }

    public void setRelation(String s) {
        this.relation = s;
    }

    public void add(double[] xx) {
        this.Dim = xx.length;
        double[] a = new double[xx.length];
        for (int i = 0; i < xx.length; ++i) {
            a[i] = xx[i];
        }
        DataPoint dp = new DataPoint(a, this.Dim);
        this.Points.add(dp);
        if (first) {
            first = false;
            this.names = new String[this.Dim];
            for (int j = 0; j < this.Dim; ++j) {
                this.names[j] = Integer.toString(j + 1);
            }
        }
    }

    public void read(String file) {
        String[] tmpholder = new String[100];
        int nn = 0;
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = "";
            int Nlines = 0;
            while ((line = in.readLine()) != null) {
                int j;
                String[] word;
                if ((line = line.trim()).startsWith("@")) {
                    word = line.split(" ");
                    word[0] = word[0].toLowerCase();
                    if (word[0].equals("@relation")) {
                        this.relation = word[1];
                        continue;
                    }
                    if (word[0].equals("@attribute")) {
                        if (nn < 100) {
                            tmpholder[nn] = word[1];
                            ++nn;
                            continue;
                        }
                        System.out.println("cannot read more than 100 attributes!");
                        continue;
                    }
                }
                if (line.startsWith("@")) {
                    word = line.split(" ");
                    word[0] = word[0].toLowerCase();
                    if (word[0].equals("@data")) {
                        this.Dim = nn;
                        this.names = new String[nn];
                        this.xmin = new double[nn];
                        this.xmax = new double[nn];
                        this.in_xmin = new int[nn];
                        this.in_xmax = new int[nn];
                        for (int i = 0; i < nn; ++i) {
                            this.names[i] = tmpholder[i];
                        }
                        if (this.Dim != 0) continue;
                        System.out.println("You did not define @ATTRIBUTE statements");
                        System.exit(0);
                    }
                }
                if ((line = line.trim()).startsWith("#") || line.startsWith("%") || line.startsWith("*") || line.startsWith("@")) continue;
                StringTokenizer st = new StringTokenizer(line, " \t\n\r\f,");
                int ncount = st.countTokens();
                if (ncount != this.Dim) {
                    System.out.println("Wrong number of attributes at line=" + Nlines);
                    System.exit(0);
                }
                double[] antrub = new double[ncount];
                int m = 0;
                while (st.hasMoreTokens()) {
                    String tmp = st.nextToken();
                    antrub[m] = Double.parseDouble(tmp);
                    ++m;
                }
                DataPoint dp = new DataPoint(antrub, ncount);
                this.Points.add(dp);
                if (Nlines == 0) {
                    for (j = 0; j < ncount; ++j) {
                        this.xmin[j] = antrub[j];
                        this.xmax[j] = antrub[j];
                    }
                }
                for (j = 0; j < ncount; ++j) {
                    if (antrub[j] < this.xmin[j]) {
                        this.xmin[j] = antrub[j];
                        this.in_xmin[j] = Nlines;
                    }
                    if (!(antrub[j] > this.xmax[j])) continue;
                    this.xmax[j] = antrub[j];
                    this.in_xmax[j] = Nlines;
                }
                ++Nlines;
            }
            this.Min = new DataPoint(this.xmin, this.Dim);
            this.Max = new DataPoint(this.xmax, this.Dim);
            in.close();
        }
        catch (Exception e) {
            System.out.println("Error in read of =" + file);
            System.err.println(e);
            System.exit(-1);
        }
    }

    public int getDimention() {
        return this.Dim;
    }

    public void setDimention(int Dim) {
        this.Dim = Dim;
    }

    public void analyseSet() {
        double[] antrub = new double[this.Dim];
        this.xmin = new double[this.Dim];
        this.xmax = new double[this.Dim];
        if (this.Points == null) {
            System.out.println("DataHolder not filled");
            System.exit(1);
        }
        DataPoint first = this.Points.get(0);
        for (int j = 0; j < this.Dim; ++j) {
            antrub[j] = first.getAttribute(j);
            this.xmin[j] = antrub[j];
            this.xmax[j] = antrub[j];
        }
        for (int i = 1; i < this.Points.size(); ++i) {
            DataPoint dp = this.Points.get(i);
            for (int j = 0; j < this.Dim; ++j) {
                antrub[j] = dp.getAttribute(j);
                if (antrub[j] < this.xmin[j]) {
                    this.xmin[j] = antrub[j];
                }
                if (!(antrub[j] > this.xmax[j])) continue;
                this.xmax[j] = antrub[j];
            }
        }
        this.Min = new DataPoint(this.xmin, this.Dim);
        this.Max = new DataPoint(this.xmax, this.Dim);
    }

    public DataPoint getMin() {
        return this.Min;
    }

    public DataPoint getMax() {
        return this.Max;
    }

    public int getSize() {
        return this.Points.size();
    }

    public String getRelation() {
        return this.relation;
    }

    public String getName(int i) {
        if (i < this.getDimention()) {
            return this.names[i];
        }
        return null;
    }

    public void setName(int i, String title) {
        this.names = new String[this.getDimention()];
        if (i < this.getDimention()) {
            this.names[i] = title;
        }
    }

    public double[] getElement(int n) {
        double[] ele = new double[this.Dim];
        int m = 0;
        for (DataPoint dp : this.Points) {
            ele[m] = dp.getAttribute(n);
            ++m;
        }
        return ele;
    }

    public DataPoint getRow(int n) {
        DataPoint xx = null;
        if (n < this.Points.size()) {
            xx = this.Points.get(n);
        } else {
            System.out.println("Requested row=" + n + " but data have only the size=" + this.Points.size());
        }
        return xx;
    }

    public void print() {
        if (this.Points != null) {
            for (DataPoint dp : this.Points) {
                dp.showAttributes();
            }
        }
    }

    public String toString() {
        int kk = 0;
        String tmp = "";
        if (this.Points != null) {
            for (DataPoint dp : this.Points) {
                tmp = tmp + Integer.toString(kk) + "  " + dp.toString() + "\n";
                ++kk;
            }
        }
        return tmp;
    }

    public static void main(String[] args) {
        DataHolder d = new DataHolder();
        d.read("input.d");
        DataPoint dp = d.getRow(3);
        dp.showAttributes();
        System.out.println("Min");
        DataPoint dmin = d.getMin();
        dmin.showAttributes();
        System.out.println("Max");
        DataPoint dmax = d.getMax();
        dmax.showAttributes();
        double[] a1 = new double[3];
        double[] a2 = new double[3];
        a1[0] = 2.0;
        a1[1] = 3.0;
        a1[2] = 1.0;
        a2[0] = 13.0;
        a2[1] = 14.0;
        a2[2] = 17.0;
        DataPoint dp1 = new DataPoint(a1, 3);
        DataPoint dp2 = new DataPoint(a2, 3);
        DataHolder rand = new DataHolder(dp1, dp2, 3, 10);
        rand.print();
    }
}

